/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.venus.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.api.dimension.ILightning;
import galaxyspace.api.dimension.IPlanetFog;
import galaxyspace.api.dimension.IProviderFreeze;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.ChunkProviderVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.WorldChunkManagerVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.sky.CloudProviderVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.sky.SkyProviderVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.sky.WeatherProviderVenus;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderVenus
extends WorldProviderAdvancedSpace
implements IProviderFreeze,
IExitHeight,
ISolarLevel,
ILightning,
IAdvancedSpace,
IPlanetFog {
    private float prevRainingStrength;
    private float rainingStrength;
    private boolean raining = false;
    private int rainTime = 100;
    private int rainChange = 100;
    private float targetRain = 0.0f;

    @Override
    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            solarMultiplier = s / 4.0;
        }
        return solarMultiplier;
    }

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.8f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer(new CloudProviderVenus());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderVenus());
        }
        return super.getSkyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getWeatherRenderer() {
        if (super.getWeatherRenderer() == null) {
            this.setWeatherRenderer(new WeatherProviderVenus());
        }
        return super.getWeatherRenderer();
    }

    public float getRainStrength(float var1) {
        return 1.0f;
    }

    public boolean canRainOrSnow() {
        return true;
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return false;
    }

    public boolean canDoLightning(Chunk chunk) {
        return true;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.planetVenus;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderVenus.class;
    }

    public Vector3 getFogColor() {
        float f = 0.5f;
        return new Vector3((double)(0.7607843f * f), (double)(0.44313726f * f), (double)(0.1254902f * f));
    }

    public Vector3 getSkyColor() {
        float f = 0.5f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.93333334f * f), (double)(0.54901963f * f), (double)(0.16078432f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerVenus.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return false;
    }

    @Override
    public double getYCoordinateToTeleport() {
        return 1000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.25f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.2f - f2;
        return f2 * 1.0f;
    }

    @Override
    public double getLightningStormFrequency() {
        return 0.8;
    }

    @Override
    public float getFogDensity(int x, int y, int z) {
        return GSConfigCore.enableFogVenus ? 0.25f : 1.0f;
    }

    @Override
    public int getFogColor(int x, int y, int z) {
        int R = 0xC20000;
        int G = 38912;
        int B = 44;
        int color = R + G + B;
        return color - 0x1000000;
    }

    @Override
    public int getYPosLightning() {
        return 20;
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        return solarMultiplier;
    }

    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K) {
            float strength;
            if (--this.rainTime <= 0) {
                this.raining = !this.raining;
                this.rainTime = this.raining ? this.field_76579_a.field_73012_v.nextInt(3600) + 1000 : this.field_76579_a.field_73012_v.nextInt(2000) + 1000;
            }
            if (--this.rainChange <= 0) {
                this.targetRain = 0.15f + this.field_76579_a.field_73012_v.nextFloat() * 0.45f;
                this.rainChange = this.field_76579_a.field_73012_v.nextInt(200) + 100;
            }
            this.field_76579_a.field_73003_n = strength = this.field_76579_a.field_73004_o;
            if (this.raining && strength < this.targetRain) {
                strength += 0.004f;
            } else if (!this.raining || strength > this.targetRain) {
                strength -= 0.004f;
            }
            this.field_76579_a.field_73004_o = MathHelper.func_76131_a((float)strength, (float)0.0f, (float)0.6f);
        }
    }
}

