/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.registers.blocks.GSBlocks;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySolarPanel
extends TileBaseUniversalElectricalSource
implements IMultiBlock,
IPacketReceiver,
IDisableableMachine,
IInventory,
ISidedInventory,
IConnector {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int solarStrength = 0;
    public double angle;
    public float targetAngle;
    public float currentAngle;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean disabled = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int disableCooldown = 0;
    private ItemStack[] containingItems = new ItemStack[2];
    public static final int MAX_GENERATE_WATTS = 450;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int generateWatts = 0;
    private boolean initialised = false;

    public TileEntitySolarPanel() {
        this.storage.setMaxExtract(450.0f);
        this.storage.setMaxReceive(450.0f);
        this.storage.setCapacity(40000.0f);
        this.initialised = true;
        this.tierGC = 1;
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            this.storage.setCapacity(40000.0f);
            this.initialised = true;
        }
        this.receiveEnergyGC(null, this.generateWatts, false);
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.recharge(this.containingItems[0]);
            this.storage.setCapacity(this.containingItems[1] != null ? 60000.0f : 40000.0f);
            if (this.disableCooldown > 0) {
                --this.disableCooldown;
            }
            if (!this.getDisabled(0) && this.ticks % 20 == 0) {
                this.solarStrength = 0;
                if (this.field_145850_b.func_72935_r() && (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider || !this.field_145850_b.func_72896_J() && !this.field_145850_b.func_72911_I())) {
                    double distance = 100.0;
                    double sinA = -Math.sin(((double)this.currentAngle - 77.5) * Math.PI / 180.0);
                    double cosA = Math.abs(Math.cos(((double)this.currentAngle - 77.5) * Math.PI / 180.0));
                    for (int x = -1; x <= 1; ++x) {
                        for (int z = -1; z <= 1; ++z) {
                            boolean valid = true;
                            BlockVec3 blockVec = new BlockVec3((TileEntity)this).translate(x, 3, z);
                            for (double d = 0.0; d < distance; d += 1.0) {
                                BlockVec3 blockAt = blockVec.clone().translate((int)(d * sinA), (int)(d * cosA), 0);
                                Block block = blockAt.getBlock((IBlockAccess)this.field_145850_b);
                                if (!block.func_149662_c()) continue;
                                valid = false;
                                break;
                            }
                            if (!valid) continue;
                            ++this.solarStrength;
                        }
                    }
                }
            }
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.7845194f < 0.0f ? 0.21548063f : -0.7845194f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        if ((celestialAngle %= 360.0f) > 30.0f && celestialAngle < 150.0f && !this.field_145850_b.func_72896_J()) {
            float difference = this.targetAngle - celestialAngle;
            this.targetAngle -= difference / 20.0f;
        } else if (!this.field_145850_b.func_72935_r() || this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) {
            this.targetAngle = 177.5f;
        } else if (celestialAngle < 50.0f) {
            this.targetAngle = 50.0f;
        } else if (celestialAngle > 150.0f) {
            this.targetAngle = 150.0f;
        }
        float difference = this.targetAngle - this.currentAngle;
        this.currentAngle += difference / 20.0f;
        if (!this.field_145850_b.field_72995_K) {
            this.generateWatts = (float)this.getGenerate() > 0.0f ? Math.min(Math.max(this.getGenerate(), 0), 450) : 0;
        }
        this.produce();
    }

    public int getGenerate() {
        if (this.getDisabled(0)) {
            return 0;
        }
        float angle = this.field_145850_b.func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (this.field_145850_b.func_72826_c(1.0f) + angle) * 360.0f;
        float difference = (180.0f - Math.abs(this.currentAngle % 180.0f - (celestialAngle %= 360.0f))) / 180.0f;
        return MathHelper.func_76141_d((float)(0.01f * difference * difference * ((float)this.solarStrength * (Math.abs(difference) * 500.0f)) * this.getSolarBoost() * (this.containingItems[1] != null ? 4.0f : 2.0f * GSConfigEnergy.coefficientSolarPanel)));
    }

    public float getSolarBoost() {
        return (float)(this.field_145850_b.field_73011_w instanceof ISolarLevel ? ((ISolarLevel)this.field_145850_b.field_73011_w).getSolarEnergyMultiplier() : 1.0);
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        return this.func_145838_q().func_149727_a(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, entityPlayer, 0, (float)this.field_145851_c, (float)this.field_145848_d, (float)this.field_145849_e);
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean checkItem() {
        return this.containingItems[1] != null;
    }

    public void onCreate(BlockVec3 placedPosition) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        if (placedPosition.y + 1 > buildHeight) {
            return;
        }
        BlockVec3 vecStrut = new BlockVec3(placedPosition.x, placedPosition.y + 1, placedPosition.z);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecStrut, placedPosition, 1);
        BlockVec3 vecStrut1 = new BlockVec3(placedPosition.x, placedPosition.y + 2, placedPosition.z);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecStrut1, placedPosition, 1);
        if (placedPosition.y + 2 > buildHeight) {
            return;
        }
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                BlockVec3 vecToAdd = new BlockVec3(placedPosition.x + x, placedPosition.y + 3, placedPosition.z + z);
                ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(this.field_145850_b, vecToAdd, placedPosition, 1);
            }
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockVec3 thisBlock = new BlockVec3((TileEntity)this);
        for (int y = 1; y <= 3; ++y) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                        FMLClientHandler.instance().getClient().field_71452_i.func_147215_a(thisBlock.x + (y == 3 ? x : 0), thisBlock.y + y, thisBlock.z + (y == 3 ? z : 0), GSBlocks.SolarPanel, Block.func_149682_b((Block)GSBlocks.SolarPanel) >> 12 & 0xFF);
                    }
                    this.field_145850_b.func_147468_f(thisBlock.x + (y == 3 ? x : 0), thisBlock.y + y, thisBlock.z + (y == 3 ? z : 0));
                }
            }
        }
        this.field_145850_b.func_147480_a(thisBlock.x, thisBlock.y, thisBlock.z, true);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.storage.setCapacity(nbt.func_74760_g("maxEnergy"));
        this.currentAngle = nbt.func_74760_g("currentAngle");
        this.targetAngle = nbt.func_74760_g("targetAngle");
        this.setDisabled(0, nbt.func_74767_n("disabled"));
        this.disableCooldown = nbt.func_74762_e("disabledCooldown");
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.initialised = false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74776_a("maxEnergy", this.getMaxEnergyStoredGC());
        nbt.func_74776_a("currentAngle", this.currentAngle);
        nbt.func_74776_a("targetAngle", this.targetAngle);
        nbt.func_74768_a("disabledCooldown", this.disableCooldown);
        nbt.func_74757_a("disabled", this.getDisabled(0));
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        int metadata = this.func_145832_p() & 3;
        return EnumSet.of(ForgeDirection.getOrientation((int)(metadata + 2 ^ 1)), ForgeDirection.UNKNOWN);
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        int metadata = this.func_145832_p() & 3;
        return ForgeDirection.getOrientation((int)(metadata + 2 ^ 1));
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)(this.tierGC == 1 ? "tile.SolarPanel.name" : "tile.SolarPanel.name"));
    }

    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            this.disabled = disabled;
            this.disableCooldown = 20;
        }
    }

    public boolean getDisabled(int index) {
        return this.disabled;
    }

    public int getScaledElecticalLevel(int i) {
        return (int)Math.floor(this.getEnergyStoredGC() * (float)i / this.getMaxEnergyStoredGC());
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 0;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return slotID == 0 && ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricalOutputDirectionMain();
    }
}

