/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemGSCanisterGeneric;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.RecyclerRecipes;
import java.util.List;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityRecycler
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank2;
    private ItemStack[] containingItems;

    public TileEntityRecycler() {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 130;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.waterTank = new FluidTank(this.tankCapacity);
        this.waterTank1 = new FluidTank(this.tankCapacity);
        this.waterTank2 = new FluidTank(this.tankCapacity);
        this.containingItems = new ItemStack[5];
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(1);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            this.checkFluidTankTransfer(2, this.waterTank);
            if (this.containingItems[4] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[4])) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("liquidethanemethane")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(new FluidStack(GSFluids.LiquidEthaneMethane, liquid.amount), true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[4]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[4])) {
                    int amount = this.containingItems[4].field_77994_a;
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(GSFluids.LiquidEthaneMethane, (amount - 1) * 1000), true);
                    }
                    this.containingItems[4] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    --this.containingItems[4].field_77994_a;
                    if (this.containingItems[4].field_77994_a == 0) {
                        this.containingItems[4] = null;
                    }
                }
            }
            if (this.hasEnoughEnergyToRun) {
                if (this.canProcess()) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidStack liquid;
        if (TileEntityRecycler.isValidContainer(this.containingItems[slot]) && (liquid = tank.getFluid()) != null) {
            if (liquid.getFluid() == GSFluids.Helium3) {
                TileEntityRecycler.tryFillContainer(tank, liquid, this.containingItems, slot, GSItems.Helium3Canister);
            }
            if (liquid.getFluid() == AsteroidsModule.fluidMethaneGas) {
                TileEntityRecycler.tryFillContainer(tank, liquid, this.containingItems, slot, AsteroidsItems.methaneCanister);
            }
            TileEntityRecycler.tryFillContainer(tank, liquid, this.containingItems, slot, Items.field_151133_ar);
        }
    }

    public static boolean isValidContainer(ItemStack slotItem) {
        return slotItem != null && slotItem.field_77994_a == 1 && (slotItem.func_77973_b() instanceof ItemCanisterGeneric || slotItem.func_77973_b() instanceof ItemGSCanisterGeneric || FluidContainerRegistry.isContainer((ItemStack)slotItem));
    }

    public static void tryFillContainer(FluidTank tank, FluidStack liquid, ItemStack[] inventory, int slot, Item canisterType) {
        ItemStack slotItem = inventory[slot];
        boolean isCanister = slotItem.func_77973_b() instanceof ItemGSCanisterGeneric || slotItem.func_77973_b() instanceof ItemCanisterGeneric;
        int amountToFill = Math.min(liquid.amount, isCanister ? slotItem.func_77960_j() - 1 : 1000);
        if (amountToFill <= 0 || isCanister && slotItem.func_77973_b() != canisterType && slotItem.func_77960_j() != 1001) {
            return;
        }
        if (isCanister) {
            inventory[slot] = new ItemStack(canisterType, 1, slotItem.func_77960_j() - amountToFill);
            tank.drain(amountToFill, true);
        } else if (amountToFill == 1000) {
            inventory[slot] = FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)inventory[slot]);
            if (inventory[slot] == null) {
                inventory[slot] = slotItem;
            } else {
                tank.drain(amountToFill, true);
            }
        }
    }

    public boolean canProcess() {
        if (this.containingItems[1] != null) {
            ItemStack input = this.containingItems[1];
            List<RecyclerRecipes.RecycleRecipe> recipes = RecyclerRecipes.recycling().getRecipes();
            RecyclerRecipes.RecycleRecipe recipe = null;
            for (RecyclerRecipes.RecycleRecipe rec : recipes) {
                if (!input.func_77969_a(rec.getInput())) continue;
                recipe = rec;
                break;
            }
            if (recipe != null) {
                if (recipe.getInput() == null) {
                    return false;
                }
                if (input.field_77994_a < recipe.getInput().field_77994_a) {
                    return false;
                }
                if (recipe.getFluidStack() != null) {
                    if (this.waterTank.getFluidAmount() > 0 && !this.waterTank.getFluid().isFluidEqual(recipe.getFluidStack())) {
                        return false;
                    }
                    if (this.waterTank.getFluidAmount() >= this.waterTank.getCapacity()) {
                        return false;
                    }
                }
                if (recipe.getOutput() != null) {
                    if (this.containingItems[3] == null) {
                        return true;
                    }
                    if (!this.containingItems[3].func_77969_a(recipe.getOutput())) {
                        return false;
                    }
                    int result = this.containingItems[3].field_77994_a + recipe.getOutput().field_77994_a;
                    return result <= this.func_70297_j_() && result <= this.containingItems[3].func_77976_d();
                }
            }
            return false;
        }
        return false;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            ItemStack input = this.containingItems[1];
            List<RecyclerRecipes.RecycleRecipe> recyclerecipes = RecyclerRecipes.recycling().getRecipes();
            RecyclerRecipes.RecycleRecipe recipe = null;
            for (RecyclerRecipes.RecycleRecipe recipes : recyclerecipes) {
                if (!recipes.getInput().func_77969_a(input)) continue;
                recipe = recipes;
                break;
            }
            if (recipe != null) {
                boolean hasRand = recipe.hasChance();
                if (!hasRand) {
                    if (this.containingItems[3] == null) {
                        this.containingItems[3] = recipe.getOutput().func_77946_l();
                    } else if (this.containingItems[3].func_77969_a(recipe.getOutput())) {
                        this.containingItems[3].field_77994_a += recipe.getOutput().field_77994_a;
                    }
                } else if (this.containingItems[3] == null) {
                    if (this.field_145850_b.field_73012_v.nextInt(100) <= recipe.getChance()) {
                        this.containingItems[3] = recipe.getOutput().func_77946_l();
                    }
                } else if (this.containingItems[3].func_77969_a(recipe.getOutput()) && this.field_145850_b.field_73012_v.nextInt(100) <= recipe.getChance()) {
                    this.containingItems[3].field_77994_a += recipe.getOutput().field_77994_a;
                }
                if (this.containingItems[1].field_77994_a == 1) {
                    this.containingItems[1] = null;
                } else {
                    --this.containingItems[1].field_77994_a;
                }
                if (recipe.getFluidStack() != null) {
                    this.waterTank.fill(new FluidStack(recipe.getFluidStack().getFluid(), recipe.getFluidStack().amount > this.waterTank.getCapacity() ? this.waterTank.getCapacity() : recipe.getFluidStack().amount), true);
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank1")) {
            this.waterTank1.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank1"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank2")) {
            this.waterTank2.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank2"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank1.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank1", (NBTBase)this.waterTank1.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank2.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank2", (NBTBase)this.waterTank2.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.Recycler.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 3, 4};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 3;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.UP) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
            used = this.waterTank1.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1) && resource != null && resource.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.waterTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
        } else if (from.equals((Object)ForgeDirection.UP)) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank1)};
        }
        return tankInfo;
    }

    public int getScaledFuelLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }
}

