/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.tile.IDisableableMachine;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.entities.IBubbleProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;

public class TileEntityRadiationStabiliser
extends TileBaseElectricBlockWithInventory
implements ISidedInventory,
IDisableableMachine,
IBubbleProvider {
    public float bubbleSize;
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    private ItemStack[] containingItems = new ItemStack[2];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean shouldRenderBubble = true;

    public TileEntityRadiationStabiliser() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
    }

    public double getDistanceFromServer(double par1, double par3, double par5) {
        double d3 = (double)this.field_145851_c + 0.5 - par1;
        double d4 = (double)this.field_145848_d + 0.5 - par3;
        double d5 = (double)this.field_145849_e + 0.5 - par5;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    public void onChunkUnload() {
        loadedTiles.remove(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        super.onChunkUnload();
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            int bubbleR = MathHelper.func_76143_f((double)this.bubbleSize);
            int bubbleR2 = (int)(this.bubbleSize * this.bubbleSize);
            for (int x = this.field_145851_c - bubbleR; x < this.field_145851_c + bubbleR; ++x) {
                for (int y = this.field_145848_d - bubbleR; y < this.field_145848_d + bubbleR; ++y) {
                    for (int z = this.field_145849_e - bubbleR; z < this.field_145849_e + bubbleR; ++z) {
                        Block block = this.field_145850_b.func_147439_a(x, y, z);
                    }
                }
            }
            loadedTiles.remove(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        }
        super.func_145843_s();
    }

    public double getPacketRange() {
        return 64.0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.bubbleSize = this.getEnergyStoredGC() > 0.0f && this.hasEnoughEnergyToRun && !this.disabled ? (this.bubbleSize += 0.01f) : (this.bubbleSize -= 0.05f);
            this.bubbleSize = Math.min(Math.max(this.bubbleSize, 0.0f), this.containingItems[1] != null ? 20.0f : 10.0f);
        }
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            if (MinecraftServer.func_71276_C().func_71262_S()) {
                networkedList.add(loadedTiles.size());
                for (BlockVec3Dim distributor : loadedTiles) {
                    if (distributor == null) {
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        networkedList.add(-1);
                        continue;
                    }
                    networkedList.add(distributor.x);
                    networkedList.add(distributor.y);
                    networkedList.add(distributor.z);
                    networkedList.add(distributor.dim);
                }
            } else {
                networkedList.add(-1);
            }
            networkedList.add(Float.valueOf(this.bubbleSize));
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K) {
            int size = dataStream.readInt();
            if (size >= 0) {
                loadedTiles.clear();
                for (int i = 0; i < size; ++i) {
                    int i1 = dataStream.readInt();
                    int i2 = dataStream.readInt();
                    int i3 = dataStream.readInt();
                    int i4 = dataStream.readInt();
                    if (i1 == -1 && i2 == -1 && i3 == -1 && i4 == -1) continue;
                    loadedTiles.add(new BlockVec3Dim(i1, i2, i3, i4));
                }
            }
            this.bubbleSize = dataStream.readFloat();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)((float)this.field_145851_c - this.bubbleSize), (double)((float)this.field_145848_d - this.bubbleSize), (double)((float)this.field_145849_e - this.bubbleSize), (double)((float)this.field_145851_c + this.bubbleSize), (double)((float)this.field_145848_d + this.bubbleSize), (double)((float)this.field_145849_e + this.bubbleSize));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150296_c().contains("bubbleVisible")) {
            this.setBubbleVisible(nbt.func_74767_n("bubbleVisible"));
        }
        if (nbt.func_150296_c().contains("bubbleSize")) {
            this.bubbleSize = nbt.func_74760_g("bubbleSize");
        }
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("bubbleVisible", this.shouldRenderBubble);
        nbt.func_74776_a("bubbleSize", this.bubbleSize);
        NBTTagList list = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            list.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.radiation_stabiliser.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
        }
        return false;
    }

    public float getBubbleSize() {
        return this.bubbleSize;
    }

    public void setBubbleVisible(boolean shouldRender) {
        this.shouldRenderBubble = shouldRender;
    }

    public boolean getBubbleVisible() {
        return this.shouldRenderBubble;
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 0;
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean shouldUseEnergy() {
        return this.hasEnoughEnergyToRun;
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public boolean inBubble(double pX, double pY, double pZ) {
        double r = this.bubbleSize;
        r *= r;
        double d3 = (double)this.field_145851_c + 0.5 - pX;
        if ((d3 *= d3) > r) {
            return false;
        }
        double d4 = (double)this.field_145849_e + 0.5 - pZ;
        if (d3 + (d4 *= d4) > r) {
            return false;
        }
        double d5 = (double)this.field_145848_d + 0.5 - pY;
        return d3 + d4 + d5 * d5 < r;
    }
}

