/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.registers.items.GSItems;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityPortableNuclearReactor
extends TileBaseUniversalElectricalSource
implements IFluidHandler,
IInventory,
ISidedInventory,
IPacketReceiver,
IConnector {
    public static final float MAX_GENERATE_GJ_PER_TICK = 1024.0f * GSConfigEnergy.coefficientNuclearGenerator;
    public static final float MIN_GENERATE_GJ_PER_TICK = 1.0f;
    private static final float BASE_ACCELERATION = 0.3f;
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    public float prevGenerateWatts = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int heatTick = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int itemCookTime = 0;
    private ItemStack[] containingItems = new ItemStack[6];

    public TileEntityPortableNuclearReactor() {
        this.storage.setCapacity(500000.0f);
        this.storage.setMaxExtract(MAX_GENERATE_GJ_PER_TICK - 1.0f);
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public void func_145845_h() {
        if (this.heatGJperTick - 1.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 1.0f, false);
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = 0; i < 4; ++i) {
                this.recharge(this.containingItems[2 + i]);
            }
            if (this.containingItems[0] != null) {
                if (this.containingItems[0].func_77973_b() == Items.field_151131_as) {
                    FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity()) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, 1000), true);
                        this.containingItems[0] = new ItemStack(Items.field_151133_ar);
                    }
                } else if (this.containingItems[0].func_77973_b() == AsteroidsItems.canisterLN2) {
                    int used;
                    int originalDamage = this.containingItems[0].func_77960_j();
                    this.containingItems[0] = originalDamage + (used = this.waterTank.fill(new FluidStack(AsteroidsModule.fluidLiquidNitrogen, 1001 - originalDamage), true)) == 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(AsteroidsItems.canisterLN2, 1, originalDamage + used);
                }
            }
            this.produce();
            this.smeltItem();
            this.heatGJperTick = Math.min(Math.max(this.heatGJperTick, 0.0f), this.getMaxEnergyStoredGC());
        }
    }

    public void smeltItem() {
        if (this.canProcess()) {
            if (this.itemCookTime == 0) {
                if (this.containingItems[1].field_77994_a == 1) {
                    this.containingItems[1] = null;
                } else {
                    this.containingItems[1].func_77979_a(1);
                }
                this.itemCookTime = 1000;
            } else if (this.field_145850_b.field_73012_v.nextInt(10) > 5) {
                --this.itemCookTime;
            }
            if (this.heatTick < 550 && this.ticks % 20 == 0) {
                this.heatTick = this.waterTank.getFluidAmount() <= 0 ? ++this.heatTick : (this.heatTick > 450 ? --this.heatTick : ++this.heatTick);
            }
            if (this.heatTick >= 500) {
                this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, 0.5f, false);
            }
            if (this.waterTank.getFluidAmount() > 0) {
                if (this.waterTank.getFluid().getFluid().getName().contains("nitrogen") && this.ticks % 20 == 0) {
                    this.waterTank.drain(1, true);
                }
                if (this.waterTank.getFluid().getFluid().getName().contains("water") && this.ticks % 2 == 0) {
                    this.waterTank.drain(1, true);
                }
            }
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.5f, 0.3f), MAX_GENERATE_GJ_PER_TICK + (float)(3 * this.heatTick));
        }
    }

    public boolean canProcess() {
        if (this.containingItems[1] == null && this.itemCookTime == 0) {
            if (this.heatGJperTick > 0.0f) {
                this.heatGJperTick = 0.0f;
            }
            return false;
        }
        return !(this.storage.getEnergyStoredGC() >= this.storage.getCapacityGC());
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.heatTick = par1NBTTagCompound.func_74762_e("reactorTemp");
        this.itemCookTime = par1NBTTagCompound.func_74762_e("itemCookTime");
        this.heatGJperTick = par1NBTTagCompound.func_74760_g("generateRate");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("reactorTemp", this.heatTick);
        par1NBTTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        par1NBTTagCompound.func_74776_a("generateRate", this.heatGJperTick);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.PortableNuclearReactor.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() == Items.field_151131_as || itemstack.func_77973_b() == AsteroidsItems.canisterLN2;
            }
            case 1: {
                return itemstack.func_77973_b() == GSItems.Ingots && itemstack.func_77960_j() == 3;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1, 2, 3, 4, 5};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int j) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 1 || slotID == 2 || slotID == 3 || slotID == 4 || slotID == 5;
    }

    public float receiveElectricity(ForgeDirection from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)0));
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)0);
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricalOutputDirectionMain();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if (from.equals((Object)ForgeDirection.UP) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && (liquidName.startsWith("water") || liquidName.startsWith("nitrogen")) && this.waterTank.getFluidAmount() < this.waterTank.getCapacity()) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }
}

