/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.GalaxySpace;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityLiquidSeparator
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank baseTank;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank2;
    private ItemStack[] containingItems;
    private static List<Liquids> liquids = new ArrayList<Liquids>();
    private boolean initialised;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean reverse;

    public TileEntityLiquidSeparator() {
        this(1);
    }

    public TileEntityLiquidSeparator(int tier) {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 7;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.baseTank = new FluidTank(this.tankCapacity);
        this.waterTank1 = new FluidTank(this.tankCapacity);
        this.waterTank2 = new FluidTank(this.tankCapacity);
        this.containingItems = new ItemStack[4];
        this.initialised = false;
        this.initialised = true;
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public boolean containsFluid(FluidStack stack, boolean reverse) {
        block4: {
            if (stack == null) break block4;
            if (!reverse) {
                for (Liquids fluid : liquids) {
                    if (!fluid.input.equals((Object)stack)) continue;
                    return true;
                }
            } else {
                for (Liquids fluid : liquids) {
                    if (!fluid.output1.equals((Object)stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (!this.getReverse()) {
                FluidStack liquid;
                this.checkFluidTankTransfer(1, this.waterTank2);
                this.checkFluidTankTransfer(3, this.waterTank1);
                if (this.containingItems[2] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[2])) != null && (this.baseTank.getFluid() == null || this.baseTank.getFluid().amount + liquid.amount <= this.baseTank.getCapacity())) {
                    this.baseTank.fill(new FluidStack(liquid.getFluid(), liquid.amount), true);
                    if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[2]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[2])) {
                        int amount = this.containingItems[2].field_77994_a;
                        if (amount > 1) {
                            this.baseTank.fill(new FluidStack(liquid.getFluid(), (amount - 1) * 1000), true);
                        }
                        this.containingItems[2] = new ItemStack(Items.field_151133_ar, amount);
                    } else {
                        --this.containingItems[2].field_77994_a;
                        if (this.containingItems[2].field_77994_a == 0) {
                            this.containingItems[2] = null;
                        }
                    }
                }
            } else {
                int amount;
                FluidStack liquid;
                this.checkFluidTankTransfer(2, this.baseTank);
                if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null) {
                    GalaxySpace.debug(liquid.getUnlocalizedName());
                    if (this.waterTank2.getFluid() == null || this.waterTank2.getFluid().amount + liquid.amount <= this.waterTank2.getCapacity()) {
                        this.waterTank2.fill(new FluidStack(liquid.getFluid(), liquid.amount), true);
                        if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                            amount = this.containingItems[1].field_77994_a;
                            if (amount > 1) {
                                this.waterTank2.fill(new FluidStack(liquid.getFluid(), (amount - 1) * 1000), true);
                            }
                            this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                        } else {
                            --this.containingItems[1].field_77994_a;
                            if (this.containingItems[1].field_77994_a == 0) {
                                this.containingItems[1] = null;
                            }
                        }
                    }
                }
                if (this.containingItems[3] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[3])) != null && (this.waterTank1.getFluid() == null || this.waterTank1.getFluid().amount + liquid.amount <= this.waterTank1.getCapacity())) {
                    this.waterTank1.fill(new FluidStack(liquid.getFluid(), liquid.amount), true);
                    if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[3]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[3])) {
                        amount = this.containingItems[3].field_77994_a;
                        if (amount > 1) {
                            this.waterTank1.fill(new FluidStack(liquid.getFluid(), (amount - 1) * 1000), true);
                        }
                        this.containingItems[3] = new ItemStack(Items.field_151133_ar, amount);
                    } else {
                        --this.containingItems[3].field_77994_a;
                        if (this.containingItems[3].field_77994_a == 0) {
                            this.containingItems[3] = null;
                        }
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidStack liquid;
        if (FluidUtil.isValidContainer((ItemStack)this.containingItems[slot]) && (liquid = tank.getFluid()) != null) {
            if (liquid.getFluid().getName().contains("methane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.methaneCanister);
            } else if (liquid.getFluid() == GSFluids.Helium3) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.Helium3Canister);
            } else if (liquid.getFluid() == GSFluids.HeliumHydrogen && !(this.containingItems[slot].func_77973_b() instanceof ItemCanisterGeneric)) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.HeliumHydrogenBucket);
            } else if (liquid.getFluid() == GSFluids.HeliumHydrogen && this.containingItems[slot].func_77973_b() instanceof ItemCanisterGeneric) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.HeliumHydrogenCanister);
            } else if (liquid.getFluid().getName().contains("hydrogen") && liquid.getFluid() != GSFluids.HeliumHydrogen) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.HydrogenCanister);
            } else if (liquid.getFluid().getName().contains("liquidoxygen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.canisterLOX);
            }
        }
    }

    public boolean canProcess() {
        if (!this.getReverse()) {
            if (this.baseTank.getFluidAmount() <= 0) {
                return false;
            }
            if (this.waterTank1.getFluidAmount() >= this.waterTank1.getCapacity() || this.waterTank2.getFluidAmount() >= this.waterTank2.getCapacity()) {
                return false;
            }
            return this.containsFluid(this.baseTank.getFluid(), false);
        }
        if (this.waterTank1.getFluidAmount() <= 0 && this.waterTank2.getFluidAmount() <= 0) {
            return false;
        }
        if (this.baseTank.getFluidAmount() >= this.baseTank.getCapacity()) {
            return false;
        }
        if (this.waterTank1.getFluid() == null || this.waterTank2.getFluid() == null) {
            return false;
        }
        if (FluidRegistry.getFluidName((FluidStack)this.waterTank1.getFluid()) == null || FluidRegistry.getFluidName((FluidStack)this.waterTank2.getFluid()) == null) {
            return false;
        }
        return this.containsFluid(this.waterTank1.getFluid(), true);
    }

    private Liquids getLiquidClass(FluidStack stack, FluidStack stack2, boolean component) {
        for (Liquids l : liquids) {
            if (stack == null) {
                return null;
            }
            if (!(component ? (stack2 != null ? l.getFirstComponent().isFluidEqual(stack) && l.getSecondComponent().isFluidEqual(stack2) || l.getFirstComponent().isFluidEqual(stack2) && l.getSecondComponent().isFluidEqual(stack) : stack2 == null && l.getFirstComponent().isFluidEqual(stack)) : l.getFluid().isFluidEqual(stack))) continue;
            return l;
        }
        return null;
    }

    public void smeltItem() {
        if (this.canProcess()) {
            boolean i = false;
            if (!this.getReverse()) {
                Liquids getRecipe = this.getLiquidClass(this.baseTank.getFluid(), null, false);
                if (getRecipe == null) {
                    return;
                }
                if (getRecipe.getFirstComponent() != null) {
                    this.waterTank2.fill(getRecipe.getFirstComponent().copy(), true);
                    if (getRecipe.getSecondComponent() != null) {
                        this.waterTank1.fill(getRecipe.getSecondComponent().copy(), true);
                    }
                    this.baseTank.drain(getRecipe.getFluid().amount, true);
                }
            } else {
                Liquids getRecipe = this.getLiquidClass(this.waterTank1.getFluid(), this.waterTank2.getFluid(), true);
                if (getRecipe == null) {
                    return;
                }
                if (getRecipe.getFirstComponent() != null && getRecipe.getSecondComponent() != null) {
                    if (this.waterTank1.getFluid().isFluidEqual(getRecipe.getFirstComponent()) && this.waterTank2.getFluid().isFluidEqual(getRecipe.getSecondComponent())) {
                        this.baseTank.fill(getRecipe.getFluid(), true);
                        this.waterTank1.drain(getRecipe.getFirstComponent().amount, true);
                        this.waterTank2.drain(getRecipe.getSecondComponent().amount, true);
                    } else if (this.waterTank2.getFluid().isFluidEqual(getRecipe.getFirstComponent()) && this.waterTank1.getFluid().isFluidEqual(getRecipe.getSecondComponent())) {
                        this.baseTank.fill(getRecipe.getFluid(), true);
                        this.waterTank2.drain(getRecipe.getFirstComponent().amount, true);
                        this.waterTank1.drain(getRecipe.getSecondComponent().amount, true);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.reverse = par1NBTTagCompound.func_74767_n("reverse");
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("baseTank")) {
            this.baseTank.readFromNBT(par1NBTTagCompound.func_74775_l("baseTank"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank1")) {
            this.waterTank1.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank1"));
        }
        if (par1NBTTagCompound.func_74764_b("waterTank2")) {
            this.waterTank2.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank2"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        par1NBTTagCompound.func_74757_a("reverse", this.reverse);
        if (this.baseTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("baseTank", (NBTBase)this.baseTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank1.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank1", (NBTBase)this.waterTank1.writeToNBT(new NBTTagCompound()));
        }
        if (this.waterTank2.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank2", (NBTBase)this.waterTank2.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.LiquidSeparator.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return false;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (!this.getReverse()) {
            String liquidName;
            if (from.equals((Object)ForgeDirection.UP) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
                used = this.baseTank.fill(resource, doFill);
            }
        } else {
            String liquidName;
            int metaside = this.func_145832_p() + 2;
            int side = from.ordinal();
            if (side == metaside && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
                used = this.waterTank2.fill(resource, doFill);
            }
            if (side == (metaside ^ 1) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
                used = this.waterTank1.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (!this.getReverse()) {
            if (side == metaside && resource != null && !resource.getFluid().isGaseous() && resource.isFluidEqual(this.waterTank1.getFluid())) {
                return this.waterTank2.drain(resource.amount, doDrain);
            }
            if (side == (metaside ^ 1) && resource != null && !resource.getFluid().isGaseous() && resource.isFluidEqual(this.waterTank2.getFluid())) {
                return this.waterTank1.drain(resource.amount, doDrain);
            }
        } else if (from.equals((Object)ForgeDirection.UP) && resource != null && !resource.getFluid().isGaseous() && resource.isFluidEqual(this.baseTank.getFluid())) {
            return this.baseTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (!this.getReverse()) {
            if (side == metaside) {
                return this.waterTank2.drain(maxDrain, true);
            }
            if (side == (metaside ^ 1)) {
                return this.waterTank1.drain(maxDrain, true);
            }
        } else if (from.equals((Object)ForgeDirection.UP)) {
            return this.baseTank.drain(maxDrain, true);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.getReverse()) {
            return this.baseTank.getFluid() == null || this.baseTank.getFluidAmount() < this.baseTank.getCapacity();
        }
        return this.waterTank1.getFluid() == null || this.waterTank1.getFluidAmount() < this.waterTank1.getCapacity() || this.waterTank2.getFluid() == null || this.waterTank2.getFluidAmount() < this.waterTank2.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (!this.getReverse()) {
            if (side == (metaside ^ 1)) {
                return this.waterTank1.getFluid() != null && this.waterTank1.getFluidAmount() > 0;
            }
            if (side == metaside) {
                return this.waterTank2.getFluid() != null && this.waterTank2.getFluidAmount() > 0;
            }
        } else if (from.equals((Object)ForgeDirection.UP)) {
            return this.baseTank.getFluid() != null && this.baseTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        if (from == ForgeDirection.UP) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.baseTank)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank1)};
        } else if (from == ForgeDirection.getOrientation((int)(this.func_145832_p() + 2 ^ 1))) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank2)};
        }
        return tankInfo;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public void setReverse(boolean rev) {
        this.reverse = rev;
    }

    public boolean getReverse() {
        return this.reverse;
    }

    static {
        liquids.add(new Liquids(new FluidStack(FluidRegistry.WATER, 10), FluidRegistry.getFluidStack((String)"hydrogen", (int)2), FluidRegistry.getFluidStack((String)"liquidoxygen", (int)1)));
        liquids.add(new Liquids(new FluidStack(GSFluids.LiquidEthaneMethane, 10), FluidRegistry.getFluidStack((String)"methane", (int)5), FluidRegistry.getFluidStack((String)"ethane", (int)1)));
        liquids.add(new Liquids(new FluidStack(GSFluids.Hydrogen2, 10), FluidRegistry.getFluidStack((String)"liquidoxygen", (int)1), FluidRegistry.getFluidStack((String)"deuterium", (int)1)));
        liquids.add(new Liquids(new FluidStack(GSFluids.HeliumHydrogen, 10), new FluidStack(GSFluids.Helium3, 2), FluidRegistry.getFluidStack((String)"hydrogen", (int)8)));
    }

    static class Liquids {
        private FluidStack input;
        private FluidStack output1;
        private FluidStack output2;

        Liquids(FluidStack input, FluidStack component_1, FluidStack component_2) {
            this.input = input;
            this.output1 = component_1;
            this.output2 = component_2;
        }

        public FluidStack getFluid() {
            return this.input;
        }

        public FluidStack getFirstComponent() {
            return this.output1;
        }

        public FluidStack getSecondComponent() {
            return this.output2;
        }
    }
}

