/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityLiquidExtractor
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    int PROCESS_TIME_REQUIRED;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank;
    private ItemStack[] containingItems;
    public final Set<EntityPlayer> playersUsing;
    private boolean initialised;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private int x;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private int z;

    public TileEntityLiquidExtractor() {
        this(1);
    }

    public TileEntityLiquidExtractor(int tier) {
        this.processTimeRequired = this.PROCESS_TIME_REQUIRED = 10;
        this.processTicks = 0;
        this.tankCapacity = 3000;
        this.waterTank = new FluidTank(this.tankCapacity);
        this.containingItems = new ItemStack[4];
        this.playersUsing = new HashSet<EntityPlayer>();
        this.initialised = false;
        this.x = -2;
        this.z = -2;
        this.initialised = true;
        if (tier == 1) {
            this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
            return;
        }
        this.setTier2();
    }

    private void setTier2() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 60.0f);
        this.processTimeRequired = 100;
        this.setTierGC(2);
    }

    public void func_145845_h() {
        if (!this.initialised) {
            int metadata = this.func_145832_p();
            Block b = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (b == GCBlocks.machineBase) {
                this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, GCBlocks.machineTiered, 4, 2);
            } else if (metadata >= 8) {
                this.setTier2();
            }
            this.initialised = true;
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            this.checkFluidTankTransfer(1, this.waterTank);
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.tierGC == 2) {
                        this.processTimeRequired = 200 / (1 + this.poweredByTierGC);
                    }
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else if (--this.processTicks <= 0) {
                        this.smeltItem();
                        this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    private void checkFluidTankTransfer(int slot, FluidTank tank) {
        FluidStack liquid;
        if (FluidUtil.isValidContainer((ItemStack)this.containingItems[slot]) && (liquid = tank.getFluid()) != null) {
            if (liquid.getFluid().getName().contains("methane")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.methaneCanister);
            } else if (liquid.getFluid() == GSFluids.Helium3) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.Helium3Canister);
            } else if (liquid.getFluid() == GSFluids.HeliumHydrogen) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.HeliumHydrogenBucket);
            } else if (liquid.getFluid().getName().contains("hydrogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GSItems.HydrogenCanister);
            } else if (liquid.getFluid().getName().contains("liquidoxygen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.canisterLOX);
            } else if (liquid.getFluid().getName().contains("oil")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GCItems.oilCanister);
            } else if (liquid.getFluid().getName().contains("fuel")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)GCItems.fuelCanister);
            } else if (liquid.getFluid().getName().contains("nirtogen")) {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)AsteroidsItems.canisterLN2);
            } else {
                FluidUtil.tryFillContainer((FluidTank)tank, (FluidStack)liquid, (ItemStack[])this.containingItems, (int)slot, (Item)Items.field_151133_ar);
            }
        }
    }

    public boolean canProcess() {
        return this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public void smeltItem() {
        if (this.canProcess()) {
            Block block = this.field_145850_b.func_147439_a(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
            if (meta == 0) {
                if (block == Blocks.field_150355_j || block == Blocks.field_150432_aD) {
                    this.waterTank.fill(new FluidStack(this.containingItems[2] != null && this.containingItems[2] == new ItemStack(GSItems.BasicItems, 1, 3) ? GSFluids.Hydrogen2 : FluidRegistry.WATER, block == Blocks.field_150432_aD ? 20 : (this.containingItems[2] != null ? 100 : 1000)), true);
                    if (block != Blocks.field_150432_aD && this.waterTank.getFluid().isFluidEqual(new FluidStack(FluidRegistry.lookupFluidForBlock((Block)block), 0))) {
                        this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                    }
                }
                if (block == Blocks.field_150353_l) {
                    this.waterTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                    this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                }
                if (block instanceof IFluidBlock) {
                    IFluidBlock fluid = (IFluidBlock)block;
                    this.waterTank.fill(new FluidStack(fluid.getFluid(), 1000), true);
                    this.field_145850_b.func_147468_f(this.field_145851_c + this.x, this.field_145848_d - 1, this.field_145849_e + this.z);
                }
            }
            if (this.x < 2) {
                ++this.x;
            } else {
                this.x = -2;
                ++this.z;
            }
            if (this.z > 2) {
                this.z = -2;
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (this.storage.getEnergyStoredGC() > 16000.0f) {
            this.setTier2();
            this.initialised = true;
        } else {
            this.initialised = false;
        }
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        this.x = par1NBTTagCompound.func_74762_e("posX");
        this.z = par1NBTTagCompound.func_74762_e("posZ");
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        par1NBTTagCompound.func_74768_a("posX", this.x);
        par1NBTTagCompound.func_74768_a("posZ", this.z);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.LiquidExtractor.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        switch (slotID) {
            case 0: {
                return ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 1;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1) && resource != null && resource.isFluidEqual(this.waterTank.getFluid())) {
            return this.waterTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.waterTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == (metaside ^ 1)) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public int getScaledFuelLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }
}

