/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityHydroponicBase
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 12000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private final int tankCapacity = 3000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(this.tankCapacity);
    private ItemStack[] containingItems = new ItemStack[20];
    public int moduleLevel;
    private static List<SeedData> seeds = new ArrayList<SeedData>();

    public static void addPlant(ItemStack seed, ItemStack product, ItemStack secproduct, int secchance, Block block, int stages, boolean[] rand) {
        SeedData data = new SeedData(seed, product, secproduct, secchance, block, stages, rand);
        seeds.add(data);
    }

    public static List getSeeds() {
        return seeds;
    }

    public static SeedData getData(ItemStack seed) {
        for (SeedData data : seeds) {
            if (!seed.func_77969_a(data.getSeed())) continue;
            return data;
        }
        return null;
    }

    public TileEntityHydroponicBase() {
        this.storage.setCapacity(25000.0f);
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 60.0f : 45.0f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        this.checkBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            boolean isWater;
            FluidStack liquid;
            if (this.containingItems[1] != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[1])) != null && (isWater = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("water")) && (this.waterTank.getFluid() == null || this.waterTank.getFluid().amount + liquid.amount <= this.waterTank.getCapacity())) {
                this.waterTank.fill(new FluidStack(FluidRegistry.WATER, liquid.amount), true);
                if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[1]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[1])) {
                    int amount = this.containingItems[1].field_77994_a;
                    if (amount > 1) {
                        this.waterTank.fill(new FluidStack(FluidRegistry.WATER, (amount - 1) * 1000), true);
                    }
                    this.containingItems[1] = new ItemStack(Items.field_151133_ar, amount);
                } else {
                    --this.containingItems[1].field_77994_a;
                    if (this.containingItems[1].field_77994_a == 0) {
                        this.containingItems[1] = null;
                    }
                }
            }
            if (this.canProcess()) {
                if (this.hasEnoughEnergyToRun) {
                    if (this.processTicks == 0) {
                        this.processTicks = this.processTimeRequired;
                    } else {
                        if (--this.processTicks <= 0) {
                            this.smeltItem();
                            int n = this.processTicks = this.canProcess() ? this.processTimeRequired : 0;
                        }
                        if (this.processTicks % 50 == 0) {
                            this.waterTank.drain(1, true);
                        }
                        if (this.containingItems[8] != null && (this.containingItems[8].func_77973_b() == Items.field_151100_aR && this.containingItems[8].func_77960_j() == 15 || this.containingItems[8].func_77973_b() == GSItems.BasicItems && this.containingItems[8].func_77960_j() == 5) && this.processTicks % 100 == 0) {
                            this.processTicks -= 2000;
                            if (this.containingItems[8].field_77994_a > 1) {
                                --this.containingItems[8].field_77994_a;
                            } else {
                                this.containingItems[8] = null;
                            }
                        }
                    }
                } else if (this.processTicks > 0 && this.processTicks < this.processTimeRequired && this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    ++this.processTicks;
                }
            } else {
                this.processTicks = 0;
            }
        }
    }

    public void checkBlock(World world, int x, int y, int z) {
        int i;
        boolean[] check = new boolean[4];
        int i2 = 0;
        while (world.func_147438_o(x, y + i2 + 1, z) instanceof TileEntityHydroponicFarm) {
            check[i2] = true;
            ++i2;
        }
        int k = 0;
        for (i = 0; i < 3; ++i) {
            if (!check[i]) continue;
            ++k;
        }
        this.setModuleLevel(k);
        for (i = 1; i < 4; ++i) {
            if (!(world.func_147438_o(x, y + i, z) instanceof TileEntityHydroponicFarm)) continue;
            TileEntityHydroponicFarm farm = (TileEntityHydroponicFarm)world.func_147438_o(x, y + i, z);
            if (farm != null) {
                if (this.containingItems[i * 2] != null) {
                    SeedData data = this.getSeedData(this.containingItems[i * 2]);
                    if (data != null) {
                        int scale = this.processTicks > 0 ? (int)((double)this.processTicks / (double)this.processTimeRequired * (double)data.getStages()) : data.getStages();
                        farm.setPlant(data.getBlock());
                        farm.setMetaPlant(data.getStages() - scale);
                        farm.func_70296_d();
                    } else {
                        farm.setPlant(null);
                        farm.setMetaPlant(0);
                        farm.func_70296_d();
                    }
                } else {
                    farm.setPlant(null);
                    farm.setMetaPlant(0);
                    farm.func_70296_d();
                }
            }
            if (i <= this.getModuleLevel() || this.containingItems[i * 2] == null) continue;
            this.containingItems[i * 2] = null;
        }
    }

    public boolean canProcess() {
        if (this.waterTank.getFluidAmount() < 10 * this.getModuleLevel()) {
            return false;
        }
        for (int i = 1; i <= this.getModuleLevel(); ++i) {
            if (this.containingItems[i * 2 + 1] != null && this.containingItems[i * 2 + 1].field_77994_a >= 64) {
                return false;
            }
            if (this.containingItems[i * 2] != null && this.containingItems[i * 2].func_77973_b() != Items.field_151014_N && this.containingItems[i * 2 + 1] != null && !this.containingItems[i * 2 + 1].func_77969_a(this.containingItems[i * 2])) {
                return false;
            }
            if (this.containingItems[i * 2] == null) {
                return false;
            }
            ItemStack stack = this.containingItems[i * 2];
            SeedData data = this.getSeedData(stack);
            if (data == null) {
                return false;
            }
            if (this.containingItems[i * 2 + 1] == null || this.containingItems[i * 2 + 1].func_77973_b() == data.getProduct(false).func_77973_b()) continue;
            return false;
        }
        return true;
    }

    public void smeltItem() {
        for (int i = 1; i < 4; ++i) {
            if (this.containingItems[i * 2] == null) continue;
            Random rand = new Random();
            SeedData seed = this.getSeedData(this.containingItems[i * 2]);
            if (seed == null || !this.containingItems[i * 2].func_77969_a(seed.getSeed())) continue;
            if (this.containingItems[i * 2 + 1] == null) {
                ItemStack stack = seed.getProduct(false).func_77946_l();
                stack.field_77994_a = 1 + (seed.hasRandCount[0] ? rand.nextInt(3) : 0);
                this.containingItems[i * 2 + 1] = stack;
            } else {
                this.containingItems[i * 2 + 1].field_77994_a = this.containingItems[i * 2 + 1].field_77994_a + (1 + (seed.hasRandCount[0] ? rand.nextInt(3) : 0));
            }
            if (this.containingItems[i * 2].field_77994_a > 1) {
                --this.containingItems[i * 2].field_77994_a;
                continue;
            }
            this.containingItems[i * 2] = null;
        }
    }

    private SeedData getSeedData(ItemStack stack) {
        for (SeedData seeds : TileEntityHydroponicBase.seeds) {
            if (!seeds.getSeed().func_77969_a(stack)) continue;
            return seeds;
        }
        return null;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.HydroponicBase.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemElectricBase;
            }
            case 1: {
                return stack.func_77973_b() == Items.field_151131_as;
            }
            case 2: 
            case 4: 
            case 6: {
                return stack.func_77973_b() == Items.field_151014_N || stack.func_77973_b() == Items.field_151172_bF || stack.func_77973_b() == Items.field_151174_bG;
            }
            case 8: {
                return stack.func_77973_b() == Items.field_151100_aR && stack.func_77960_j() == 15 || stack.func_77973_b() == GSItems.BasicItems && stack.func_77960_j() == 5;
            }
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int side) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int side) {
        return slotID == 1 || slotID == 3 || slotID == 5 || slotID == 7;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int side;
        int used = 0;
        int metaside = this.func_145832_p() + 2;
        if (7 - (metaside ^ (metaside > 3 ? 0 : 1)) == ((side = from.ordinal()) ^ 1) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null && liquidName.startsWith("water")) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public int func_70302_i_() {
        return this.getContainingItems().length;
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean shouldUseEnergy() {
        return this.canProcess();
    }

    public int getScaledFluidLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.moduleLevel = par1NBTTagCompound.func_74762_e("moduleTier");
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        par1NBTTagCompound.func_74768_a("moduleTier", this.moduleLevel);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int getModuleLevel() {
        return this.moduleLevel;
    }

    public void setModuleLevel(int newTier) {
        this.moduleLevel = newTier;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.DOWN;
    }

    public ItemStack getItemForFarm(int slot) {
        return this.containingItems[slot];
    }

    static class SeedData {
        private ItemStack seed;
        private ItemStack product;
        private ItemStack secondproduct;
        private Block block;
        private int stages;
        private int secondchance;
        private boolean[] hasRandCount = new boolean[2];

        public SeedData(ItemStack seed, ItemStack product, ItemStack secondproduct, int secondchance, Block block, int stages, boolean[] rand) {
            this.seed = seed;
            this.product = product;
            this.secondproduct = secondproduct;
            this.secondchance = secondchance;
            this.block = block;
            this.stages = stages;
            this.hasRandCount = rand;
        }

        public ItemStack getSeed() {
            return this.seed;
        }

        public ItemStack getProduct(boolean second) {
            if (second) {
                return this.secondproduct;
            }
            return this.product;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getStages() {
            return this.stages;
        }

        public boolean[] hasRandCount() {
            return this.hasRandCount;
        }
    }
}

