/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import galaxyspace.api.BodiesHelper;
import galaxyspace.api.tile.ITileEffects;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.IAntiGrav;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityGravitationModule
extends TileBaseElectricBlockWithInventory
implements ITileEffects {
    private ItemStack[] containingItems = new ItemStack[2];
    public static HashSet<BlockVec3Dim> loadedTiles = new HashSet();
    public boolean shouldRenderEffects = false;
    private boolean initialised = false;
    public static boolean check = false;
    protected int radius = 4;
    private AxisAlignedBB aabb;

    public TileEntityGravitationModule() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 45.0f);
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.add(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            loadedTiles.remove(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        }
        super.func_145843_s();
    }

    public void onChunkUnload() {
        loadedTiles.remove(new BlockVec3Dim(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g));
        super.onChunkUnload();
    }

    public Packet func_145844_m() {
        NBTTagCompound data = new NBTTagCompound();
        this.func_145841_b(data);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 2, data);
    }

    public void onDataPacket(NetworkManager netManager, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.canProcess()) {
            this.smeltItem();
        }
    }

    public boolean canProcess() {
        return !this.getDisabled(0) && this.hasEnoughEnergyToRun;
    }

    public void smeltItem() {
        this.aabb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.getGravityRadius()), (double)(this.field_145848_d - 4), (double)(this.field_145849_e - this.getGravityRadius()), (double)(this.field_145851_c + this.getGravityRadius()), (double)(this.field_145848_d + 16), (double)(this.field_145849_e + this.getGravityRadius()));
        if (this.field_145850_b.field_73011_w instanceof IGalacticraftWorldProvider) {
            double g = this.field_145850_b.field_73011_w instanceof IZeroGDimension ? 0.2 : (1.0 - (double)((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).getGravity()) / (double)0.08f;
            List list = this.field_145850_b.func_72872_a(Entity.class, this.aabb);
            for (Entity e : list) {
                if (!this.field_145850_b.field_72995_K) {
                    if (e instanceof IAntiGrav) continue;
                    Entity entity = e;
                    entity.field_70143_R = (float)((double)entity.field_70143_R - g * 10.0);
                    if (!(entity.field_70143_R < 0.0f)) continue;
                    entity.field_70143_R = 0.0f;
                    continue;
                }
                if (!(e instanceof EntityPlayer)) continue;
                EntityPlayer p = (EntityPlayer)e;
                if (p.field_71075_bZ.field_75100_b || p.field_71071_by.func_70440_f(0) != null && p.field_71071_by.func_70440_f(0).func_77973_b() instanceof IArmorGravity && ((IArmorGravity)p.field_71071_by.func_70440_f(0).func_77973_b()).gravityOverrideIfLow(p) > 0) continue;
                p.field_70181_x = p.field_70181_x - (((IGalacticraftWorldProvider)this.field_145850_b.field_73011_w).getGravity() > BodiesHelper.calculateGravity(8.8f) ? g / 200.0 : g / 500.0);
            }
            check = true;
            if (this.shouldRenderEffects && this.field_145850_b.field_72995_K) {
                for (int yy = -4; yy < 16; ++yy) {
                    for (int ix = -this.getGravityRadius(); ix <= this.getGravityRadius() + 1; ++ix) {
                        if (ix != -this.getGravityRadius() && ix != this.getGravityRadius() + 1 && yy != 15 && yy != -4) continue;
                        this.field_145850_b.func_72869_a("magicCrit", (double)((float)(this.field_145851_c + ix) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145848_d + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145849_e - this.getGravityRadius()) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                        this.field_145850_b.func_72869_a("magicCrit", (double)((float)(this.field_145851_c + ix) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145848_d + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145849_e + this.getGravityRadius() + 1) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                    }
                    for (int iz = -this.getGravityRadius(); iz <= this.getGravityRadius() + 1; ++iz) {
                        if (iz != -this.getGravityRadius() && iz != this.getGravityRadius() + 1 && yy != 15 && yy != -4) continue;
                        this.field_145850_b.func_72869_a("magicCrit", (double)((float)(this.field_145851_c - this.getGravityRadius()) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145848_d + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145849_e + iz) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                        this.field_145850_b.func_72869_a("magicCrit", (double)((float)(this.field_145851_c + this.getGravityRadius() + 1) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145848_d + yy) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), (double)((float)(this.field_145849_e + iz) + this.field_145850_b.field_73012_v.nextFloat() - 0.5f), 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("gravityradius")) {
            int grav = par1NBTTagCompound.func_74762_e("gravityradius");
            this.setGravityRadius(grav == 0 ? 1 : grav);
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("gravityradius", this.radius > 16 ? 16 : this.radius);
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.GravitationModule_4.name");
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return true;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 0));
    }

    @Override
    public void setEffectsVisible(boolean shouldRender) {
        this.shouldRenderEffects = shouldRender;
    }

    @Override
    public boolean getEffectsVisible() {
        return this.shouldRenderEffects;
    }

    public void setGravityRadius(int radius) {
        this.radius = radius;
    }

    public int getGravityRadius() {
        return this.radius;
    }

    public boolean inGravityZone(World world, EntityPlayer player) {
        return player.field_70165_t > (double)(this.field_145851_c - this.getGravityRadius()) && player.field_70163_u > (double)(this.field_145848_d - 4) && player.field_70161_v > (double)(this.field_145849_e - this.getGravityRadius()) && player.field_70165_t < (double)(this.field_145851_c + this.getGravityRadius()) && player.field_70163_u < (double)(this.field_145848_d + 16) && player.field_70161_v < (double)(this.field_145849_e + this.getGravityRadius());
    }
}

