/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.configs.GSConfigEnergy;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFuelGenerator
extends TileBaseUniversalElectricalSource
implements IFluidHandler,
IInventory,
ISidedInventory,
IPacketReceiver,
IConnector {
    public static final float MAX_GENERATE_GJ_PER_TICK = 81.0f * GSConfigEnergy.coefficientFuelGenerator;
    public static final float MIN_GENERATE_GJ_PER_TICK = 1.0f;
    private static final float BASE_ACCELERATION = 0.3f;
    private final int tankCapacity = 4000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank fuelTank = new FluidTank(this.tankCapacity);
    public float prevGenerateWatts = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public float heatGJperTick = 0.0f;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int itemCookTime = 0;
    private ItemStack[] containingItems = new ItemStack[1];

    public TileEntityFuelGenerator() {
        this.storage.setMaxExtract(MAX_GENERATE_GJ_PER_TICK - 1.0f);
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getFluidAmount() * i / this.fuelTank.getCapacity();
    }

    public void func_145845_h() {
        if (this.heatGJperTick - 1.0f > 0.0f) {
            this.receiveEnergyGC(null, this.heatGJperTick - 1.0f, false);
        }
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.containingItems[0] != null) {
                FluidStack liquid;
                if (this.containingItems[0].func_77973_b() == Items.field_151129_at) {
                    if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() == GalacticraftCore.fluidFuel) {
                        return;
                    }
                    liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity()) {
                        this.fuelTank.fill(new FluidStack(FluidRegistry.LAVA, 1000), true);
                        this.containingItems[0] = new ItemStack(Items.field_151133_ar);
                    }
                }
                if (this.containingItems[0].func_77973_b() == GCItems.bucketFuel) {
                    if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() == FluidRegistry.LAVA) {
                        return;
                    }
                    liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity()) {
                        this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, 1000), true);
                        this.containingItems[0] = new ItemStack(Items.field_151133_ar);
                    }
                }
                if (this.containingItems[0].func_77973_b() == GCItems.fuelCanister) {
                    int used;
                    int originalDamage = this.containingItems[0].func_77960_j();
                    this.containingItems[0] = originalDamage + (used = this.fuelTank.fill(new FluidStack(GalacticraftCore.fluidFuel, 1001 - originalDamage), true)) == 1001 ? new ItemStack(GCItems.oilCanister, 1, 1001) : new ItemStack(GCItems.fuelCanister, 1, originalDamage + used);
                } else {
                    liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)this.containingItems[0]);
                    if (liquid != null) {
                        boolean isFuel = FluidUtil.testFuel((String)FluidRegistry.getFluidName((FluidStack)liquid));
                        boolean isLava = FluidRegistry.getFluidName((FluidStack)liquid).startsWith("lava");
                        if ((isFuel || isLava) && (this.fuelTank.getFluid() == null || this.fuelTank.getFluid().amount + liquid.amount <= this.fuelTank.getCapacity())) {
                            if (this.fuelTank.getFluid() != null && this.fuelTank.getFluid().getFluid() == (!isLava ? GalacticraftCore.fluidFuel : FluidRegistry.LAVA)) {
                                return;
                            }
                            this.fuelTank.fill(new FluidStack(isLava ? FluidRegistry.LAVA : GalacticraftCore.fluidFuel, liquid.amount), true);
                            if (FluidContainerRegistry.isBucket((ItemStack)this.containingItems[0]) && FluidContainerRegistry.isFilledContainer((ItemStack)this.containingItems[0])) {
                                int amount = this.containingItems[0].field_77994_a;
                                if (amount > 1) {
                                    this.fuelTank.fill(new FluidStack(isLava ? FluidRegistry.LAVA : GalacticraftCore.fluidFuel, (amount - 1) * 1000), true);
                                }
                                this.containingItems[0] = new ItemStack(Items.field_151133_ar, amount);
                            } else {
                                --this.containingItems[0].field_77994_a;
                                if (this.containingItems[0].field_77994_a == 0) {
                                    this.containingItems[0] = null;
                                }
                            }
                        }
                    }
                }
            }
            this.produce();
            this.smeltItem();
            this.heatGJperTick = Math.min(Math.max(this.heatGJperTick, 0.0f), this.getMaxEnergyStoredGC());
        }
    }

    public void smeltItem() {
        if (this.canProcess()) {
            int lavaAmount = this.fuelTank.getFluidAmount();
            int fuelSpace = this.fuelTank.getCapacity() - this.fuelTank.getFluidAmount();
            int amountToDrain = Math.min(Math.min(lavaAmount, fuelSpace), 1);
            if (this.fuelTank.getFluid().getFluid() == FluidRegistry.LAVA && this.ticks % 10 == 0) {
                this.fuelTank.drain(2, true);
            } else if (this.ticks % 100 == 0) {
                this.fuelTank.drain(1, true);
            }
            this.heatGJperTick = Math.min(this.heatGJperTick + Math.max(this.heatGJperTick * 0.005f, 0.3f), MAX_GENERATE_GJ_PER_TICK);
        }
    }

    public boolean canProcess() {
        if (this.fuelTank.getFluidAmount() <= 0) {
            this.heatGJperTick = 0.0f;
            return false;
        }
        return !(this.storage.getEnergyStoredGC() >= this.storage.getCapacityGC());
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.itemCookTime = par1NBTTagCompound.func_74762_e("itemCookTime");
        this.heatGJperTick = par1NBTTagCompound.func_74762_e("generateRateInt");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        if (par1NBTTagCompound.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(par1NBTTagCompound.func_74775_l("fuelTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("itemCookTime", this.itemCookTime);
        par1NBTTagCompound.func_74776_a("generateRate", this.heatGJperTick);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        if (this.fuelTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.FuelGenerator.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return itemstack.func_77973_b() == GCItems.bucketFuel || itemstack.func_77973_b() == GCItems.fuelCanister || itemstack.func_77973_b() == Items.field_151129_at;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int j) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 0;
    }

    public float receiveElectricity(ForgeDirection from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)));
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() + 2));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || direction.equals((Object)ForgeDirection.UNKNOWN) || type != NetworkType.POWER) {
            return false;
        }
        return direction == this.getElectricalOutputDirectionMain();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (from.equals((Object)ForgeDirection.getOrientation((int)(this.func_145832_p() + 2)).getOpposite())) {
            String liquidName = FluidRegistry.getFluidName((FluidStack)resource);
            if (liquidName != null && liquidName.startsWith("fuel")) {
                used = this.fuelTank.fill(resource, doFill);
            }
            if (liquidName != null && liquidName.startsWith("biofuel")) {
                used = this.fuelTank.fill(resource, doFill);
            }
            if (liquidName != null && liquidName.startsWith("lava")) {
                used = this.fuelTank.fill(resource, doFill);
            }
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fuelTank.getFluid() == null || this.fuelTank.getFluidAmount() < this.fuelTank.getCapacity();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.fuelTank)};
    }
}

