/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.registers.blocks.GSBlocks;
import io.netty.buffer.ByteBuf;
import java.util.List;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityFluidTank
extends TileEntityAdvanced
implements IFluidHandler,
ISidedInventory {
    public static final int tankCapacity = 60000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(60000);

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            TileEntityFluidTank fluidDown;
            TileEntityFluidTank fluidUp;
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == GSBlocks.FluidTank && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) == 1 && this.func_145832_p() == 1 && (fluidUp = (TileEntityFluidTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) != null && this.waterTank.getFluidAmount() >= this.waterTank.getCapacity()) {
                if (this.waterTank.getFluid() != null) {
                    fluidUp.fill(ForgeDirection.DOWN, new FluidStack(this.waterTank.getFluid().getFluid(), 1000), true);
                }
                this.waterTank.drain(1000, true);
            }
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == GSBlocks.FluidTank && this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == 0 && this.func_145832_p() == 0 && (fluidDown = (TileEntityFluidTank)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e)) != null && fluidDown.waterTank.getFluidAmount() < fluidDown.waterTank.getCapacity()) {
                if (this.waterTank.getFluid() != null) {
                    fluidDown.fill(ForgeDirection.UP, new FluidStack(this.waterTank.getFluid().getFluid(), 1000), true);
                }
                this.waterTank.drain(1000, true);
            }
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int par1) {
        return null;
    }

    public ItemStack func_70298_a(int par1, int par2) {
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.FluidTank.name");
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        return false;
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int j) {
        return this.func_94041_b(slotID, itemstack);
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int j) {
        return slotID == 0;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.func_145832_p() == 0 && from.equals((Object)ForgeDirection.DOWN) || this.func_145832_p() == 1 && from.equals((Object)ForgeDirection.UP)) {
            return this.waterTank.getFluid() != null && this.waterTank.getFluidAmount() > 0;
        }
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        if ((this.func_145832_p() == 0 && from.equals((Object)ForgeDirection.UP) || this.func_145832_p() == 1 && from.equals((Object)ForgeDirection.DOWN)) && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.func_145832_p() == 0 && from.equals((Object)ForgeDirection.DOWN) || this.func_145832_p() == 1 && from.equals((Object)ForgeDirection.UP)) {
            return this.waterTank.drain(resource.amount, true);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.func_145832_p() == 0 && from.equals((Object)ForgeDirection.DOWN) || this.func_145832_p() == 1 && from.equals((Object)ForgeDirection.UP)) {
            return this.waterTank.drain(maxDrain, true);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }

    public double getPacketRange() {
        return 64.0;
    }

    public int getPacketCooldown() {
        return 3;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public void addExtraNetworkedData(List<Object> networkedList) {
        if (this.waterTank.getFluid() != null) {
            networkedList.add(1);
            networkedList.add(this.waterTank.getInfo().fluid.getFluidID());
            networkedList.add(this.waterTank.getFluidAmount());
        } else {
            networkedList.add(0);
        }
    }

    public void readExtraNetworkedData(ByteBuf dataStream) {
        if (this.field_145850_b.field_72995_K && dataStream.readInt() == 1) {
            this.waterTank.setCapacity(60000);
            this.waterTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
        }
    }
}

