/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.tile;

import cpw.mods.fml.relauncher.Side;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlockWithInventory;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileEntityCargoFluidLoader
extends TileBaseElectricBlockWithInventory
implements IFluidHandler,
ISidedInventory,
ILandingPadAttachable {
    public static final int tankCapacity = 10000;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public FluidTank waterTank = new FluidTank(10000);
    private ItemStack[] containingItems = new ItemStack[1];
    public boolean outOfItems;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetFull;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean targetNoInventory;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean noTarget;
    public ICargoEntity attachedFuelable;

    public TileEntityCargoFluidLoader() {
        this.storage.setMaxExtract(45.0f);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.ticks % 100 == 0) {
                this.checkForCargoEntity();
            }
            if (this.attachedFuelable != null) {
                this.noTarget = false;
                ItemStack stack = this.removeCargo((boolean)false).resultStack;
                if (stack != null) {
                    this.outOfItems = false;
                    ICargoEntity.EnumCargoLoadingState state = this.attachedFuelable.addCargo(stack, false);
                    this.targetFull = state == ICargoEntity.EnumCargoLoadingState.FULL;
                    this.targetNoInventory = state == ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
                    boolean bl = this.noTarget = state == ICargoEntity.EnumCargoLoadingState.NOTARGET;
                    if (this.ticks % 15 == 0 && state == ICargoEntity.EnumCargoLoadingState.SUCCESS && !this.disabled && this.hasEnoughEnergyToRun) {
                        this.attachedFuelable.addCargo(this.removeCargo((boolean)true).resultStack, true);
                    }
                } else {
                    this.outOfItems = true;
                }
            } else {
                this.noTarget = true;
            }
        }
    }

    public void checkForCargoEntity() {
        boolean foundFuelable = false;
        for (ForgeDirection dir : ForgeDirection.values()) {
            if (dir == ForgeDirection.UNKNOWN) continue;
            TileEntity pad = new BlockVec3((TileEntity)this).getTileEntityOnSide(this.field_145850_b, dir);
            if (pad != null && pad instanceof TileEntityMulti) {
                TileEntity mainTile = ((TileEntityMulti)pad).getMainBlockTile();
                if (!(mainTile instanceof ICargoEntity)) continue;
                this.attachedFuelable = (ICargoEntity)mainTile;
                foundFuelable = true;
                break;
            }
            if (pad == null || !(pad instanceof ICargoEntity)) continue;
            this.attachedFuelable = (ICargoEntity)pad;
            foundFuelable = true;
            break;
        }
        if (!foundFuelable) {
            this.attachedFuelable = null;
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.containingItems = this.readStandardItemsFromNBT(par1NBTTagCompound);
        if (par1NBTTagCompound.func_74764_b("waterTank")) {
            this.waterTank.readFromNBT(par1NBTTagCompound.func_74775_l("waterTank"));
        }
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        super.func_145841_b(par1NBTTagCompound);
        this.writeStandardItemsToNBT(par1NBTTagCompound);
        if (this.waterTank.getFluid() != null) {
            par1NBTTagCompound.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        }
    }

    protected ItemStack[] getContainingItems() {
        return this.containingItems;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"container.cargofluidloader.name");
    }

    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side != this.func_145832_p() + 2) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = new int[]{};
        }
        return nArray;
    }

    public boolean func_102007_a(int slotID, ItemStack itemstack, int side) {
        if (side != this.func_145832_p() + 2 && slotID == 0) {
            return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return ItemElectricBase.isElectricItem((Item)itemstack.func_77973_b());
        }
        return true;
    }

    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        if (this.waterTank.getFluidAmount() > 0 && doRemove) {
            this.func_70296_d();
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, null);
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, null);
    }

    public boolean canAttachToLandingPad(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public int getScaledWaterLevel(int i) {
        return this.waterTank.getFluidAmount() * i / this.waterTank.getCapacity();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        String liquidName;
        int used = 0;
        int metaside = this.func_145832_p() + 2;
        int side = from.ordinal();
        if (side == metaside && (liquidName = FluidRegistry.getFluidName((FluidStack)resource)) != null) {
            used = this.waterTank.fill(resource, doFill);
        }
        return used;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.waterTank.getFluid() == null || this.waterTank.getFluidAmount() < this.waterTank.getCapacity();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.waterTank)};
    }
}

