/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.recipe;

import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.GalaxySpace;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.SolarSystem.moons.moon.recipe.AlienRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.AssemberRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.RecyclerRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.RocketAssemblyRecipes;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import ic2.core.Ic2Items;
import micdoodle8.mods.galacticraft.api.recipe.CircuitFabricatorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.RecipeUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class CraftingRecipesOverworld {
    private static String plateIron = GSConfigCore.enablePlateOreDict ? "plateIron" : "compressedIron";
    private static String plateSteel = GSConfigCore.enablePlateOreDict ? "plateSteel" : "compressedSteel";
    private static String plateBronze = GSConfigCore.enablePlateOreDict ? "plateBronze" : "compressedBronze";
    private static String plateTitanium = GSConfigCore.enablePlateOreDict ? "plateTitanium" : "compressedTitanium";
    private static String plateAluminum = GSConfigCore.enablePlateOreDict ? "plateAluminum" : "compressedAluminum";
    private static String plateTin = GSConfigCore.enablePlateOreDict ? "plateTin" : "compressedTin";

    public static void loadRecipes() {
        CraftingRecipesOverworld.addBlockRecipes();
        CraftingRecipesOverworld.addItemRecipes();
        CraftingRecipesOverworld.addBlockSmelting();
        CraftingRecipesOverworld.addCompressor();
        CraftingRecipesOverworld.addAssembly();
        CraftingRecipesOverworld.addRocketAssembly();
        CraftingRecipesOverworld.addRecycler();
        CraftingRecipesOverworld.addCircuitFabricator();
        CraftingRecipesOverworld.addOtherRecipes();
        CraftingRecipesOverworld.parseRecipes();
    }

    private static void addBlockRecipes() {
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.Ores, 1, 4), (Object[])new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), "sapphire"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DecoMetalsBlock, 4, 0), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DecoMetalsBlock, 4, 1), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateMagnesium", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DecoMetalsBlock, 4, 2), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateNickel", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.DecoMetalsBlock, 4, 3), (Object[])new Object[]{"   ", " X ", " Y ", Character.valueOf('X'), "plateCopper", Character.valueOf('Y'), Blocks.field_150348_b});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FutureGlass, 8, 0), (Object[])new Object[]{"XXX", "XWX", "XXX", Character.valueOf('W'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('X'), Blocks.field_150359_w});
        for (int var2 = 0; var2 < 16; ++var2) {
            RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FutureGlasses, 8, var2), (Object[])new Object[]{"XXX", "XWX", "XXX", Character.valueOf('X'), new ItemStack(GSBlocks.FutureGlass, 1, 0), Character.valueOf('W'), new ItemStack(Items.field_151100_aR, 1, var2)});
        }
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.SolarWindPanel, 1, 0), (Object[])new Object[]{"XYX", "XZX", "VWV", Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('W'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 2), Character.valueOf('Z'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FuelGenerator, 1, 0), (Object[])new Object[]{"WYW", "WZW", "XXX", Character.valueOf('W'), new ItemStack(GCItems.canister, 1, 1), Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(Blocks.field_150410_aZ, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.AssemblyMachine, 1, 0), (Object[])new Object[]{"VWV", "XYX", "ZWC", Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 9), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 13), Character.valueOf('Y'), new ItemStack(Blocks.field_150462_ai, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase, 1, 12), Character.valueOf('C'), new ItemStack(GCBlocks.machineBase2, 1, 4)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ConverterSurface, 1, 0), (Object[])new Object[]{"XVX", "XCX", "WZW", Character.valueOf('X'), "ingotDesh", Character.valueOf('V'), new ItemStack(AsteroidsItems.basicItem, 1, 8), Character.valueOf('C'), new ItemStack(MarsBlocks.machine, 1, 0), Character.valueOf('W'), plateSteel, Character.valueOf('Z'), new ItemStack(MarsItems.marsItemBasic, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.RocketAssembly, 1, 0), (Object[])new Object[]{"VWV", "XYZ", "BNB", Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 14), Character.valueOf('W'), new ItemStack(GCBlocks.nasaWorkbench, 1, 0), Character.valueOf('X'), new ItemStack(GCBlocks.machineBase2, 1, 0), Character.valueOf('Y'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.machineBase2, 1, 4), Character.valueOf('B'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('N'), GSBlocks.AssemblyMachine});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MachineFrames, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), plateSteel, Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 13), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(Blocks.field_150451_bX, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.MachineFrames, 1, 2), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), "plateMagnesium", Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('V'), new ItemStack(GSBlocks.MachineFrames, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.StorageModuleT3, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XYX", Character.valueOf('X'), new ItemStack(GSItems.Ingots, 1, 1), Character.valueOf('Y'), new ItemStack(GCBlocks.machineTiered, 1, 8), Character.valueOf('W'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('V'), new ItemStack(GSBlocks.MachineFrames, 1, 2)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.OxStorageModuleT2, 1, 0), (Object[])new Object[]{"XYX", "WVW", "XZX", Character.valueOf('X'), new ItemStack(GCBlocks.machineBase2, 1, 8), Character.valueOf('Y'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('W'), new ItemStack(GCBlocks.oxygenPipe, 1, 0), Character.valueOf('V'), new ItemStack(GSBlocks.MachineFrames, 1, 2), Character.valueOf('Z'), new ItemStack(GSItems.BasicItems, 1, 7)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.SolarPanel, 1, 0), (Object[])new Object[]{"XYX", "WVW", "CZC", Character.valueOf('X'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.basicItem, 1, 1), Character.valueOf('W'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('V'), new ItemStack(GSBlocks.MachineFrames, 1, 2), Character.valueOf('Z'), new ItemStack(GCBlocks.solarPanel, 1, 4), Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.GravitationModule, 1, 0), (Object[])new Object[]{"XYX", "WVW", "CZC", Character.valueOf('X'), new ItemStack(GSItems.CompressedPlates, 1, 4), Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 10), Character.valueOf('W'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('V'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('Z'), new ItemStack(GSBlocks.MachineFrames, 1, 2), Character.valueOf('C'), new ItemStack(GCItems.basicItem, 1, 14)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.WindTurbine, 1, 0), (Object[])new Object[]{"XYX", "MVM", "CZC", Character.valueOf('X'), "ingotAluminum", Character.valueOf('Y'), new ItemStack(GCItems.oxygenFan, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('M'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Z'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('C'), new ItemStack(GCItems.meteoricIronIngot, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.Recycler, 1, 0), (Object[])new Object[]{"XYX", "MZM", "CVC", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), new ItemStack(GSBlocks.FluidTank, 1, 0), Character.valueOf('V'), new ItemStack(GCBlocks.machineTiered, 1, 4), Character.valueOf('C'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Z'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('M'), new ItemStack(GSItems.BasicItems, 1, 7)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.FluidTank, 1, 0), (Object[])new Object[]{"XZX", "MZM", "XZX", Character.valueOf('X'), plateSteel, Character.valueOf('Z'), new ItemStack(GSBlocks.FutureGlass, 1, 0), Character.valueOf('M'), new ItemStack(GCItems.flagPole, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.LiquidExtractor, 1, 0), (Object[])new Object[]{"XZX", "MCM", "VBV", Character.valueOf('X'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('Z'), new ItemStack(GSBlocks.FluidTank, 1, 0), Character.valueOf('M'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('C'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('V'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('B'), new ItemStack(GCBlocks.oxygenPipe, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.LiquidSeparator, 1, 0), (Object[])new Object[]{"XZX", "ZCZ", "VBV", Character.valueOf('X'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('Z'), new ItemStack(GSBlocks.FluidTank, 1, 0), Character.valueOf('C'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('V'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('B'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.AdvFuelLoader, 1, 0), (Object[])new Object[]{"XZX", "ACA", "VBV", Character.valueOf('X'), new ItemStack(GSItems.HeavyDutyPlates, 1, 0), Character.valueOf('Z'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('C'), new ItemStack(GSBlocks.MachineFrames, 1, 2), Character.valueOf('B'), new ItemStack(GCItems.oilCanister, 1, GCItems.oilCanister.func_77612_l()), Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('A'), new ItemStack(MarsBlocks.hydrogenPipe, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.HydroponicBase, 1, 0), (Object[])new Object[]{"ABC", "DED", "DFD", Character.valueOf('A'), new ItemStack(GCItems.basicItem, 1, 20), Character.valueOf('B'), new ItemStack(GSBlocks.FluidTank, 1, 0), Character.valueOf('C'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('D'), plateSteel, Character.valueOf('E'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('F'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.HydroponicFarm, 1, 0), (Object[])new Object[]{"XXX", "XCX", "VBV", Character.valueOf('X'), new ItemStack(Blocks.field_150359_w, 1, 0), Character.valueOf('B'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('C'), new ItemStack(Blocks.field_150346_d, 1, 0), Character.valueOf('V'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('A'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.RadiationStabiliser, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "XBX", Character.valueOf('X'), new ItemStack(GSItems.BasicItems, 1, 4), Character.valueOf('B'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('C'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GCBlocks.basicBlock, 1, 9)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.ModificationTable, 1, 0), (Object[])new Object[]{"XYX", "ZCZ", "VBV", Character.valueOf('V'), plateBronze, Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 14), Character.valueOf('B'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('C'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('Z'), new ItemStack(Items.field_151137_ax, 1, 0), Character.valueOf('Y'), "plateCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSBlocks.OxygenFiller, 1, 0), (Object[])new Object[]{"XYX", "ZZZ", "VBV", Character.valueOf('V'), plateBronze, Character.valueOf('X'), plateAluminum, Character.valueOf('B'), new ItemStack(GSBlocks.MachineFrames, 1, 0), Character.valueOf('Z'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.oxygenConcentrator, 1, 0)});
    }

    private static void addItemRecipes() {
        int var3;
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltHelmet, 1), (Object[])new Object[]{"XXX", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltPlate, 1), (Object[])new Object[]{"X X", "XXX", "XXX", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltLeg, 1), (Object[])new Object[]{"XXX", "X X", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltBoots, 1), (Object[])new Object[]{"X X", "X X", Character.valueOf('X'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltSword, 1), (Object[])new Object[]{" X ", " X ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltAxe, 1), (Object[])new Object[]{"XX ", "XY ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltPickaxe, 1), (Object[])new Object[]{"XXX", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltShovel, 1), (Object[])new Object[]{" X ", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.CobaltHoe, 1), (Object[])new Object[]{"XX ", " Y ", " Y ", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), "stickWood"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ThermalPaddingTier2, 1, 0), (Object[])new Object[]{"XXX", "XYX", Character.valueOf('X'), GSItems.ThermalClothTier2, Character.valueOf('Y'), new ItemStack(AsteroidsItems.thermalPadding, 1, 0)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ThermalPaddingTier2, 1, 1), (Object[])new Object[]{"X X", "XYX", "XXX", Character.valueOf('X'), GSItems.ThermalClothTier2, Character.valueOf('Y'), new ItemStack(AsteroidsItems.thermalPadding, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ThermalPaddingTier2, 1, 2), (Object[])new Object[]{"XXX", "XYX", "X X", Character.valueOf('X'), GSItems.ThermalClothTier2, Character.valueOf('Y'), new ItemStack(AsteroidsItems.thermalPadding, 1, 2)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ThermalPaddingTier2, 1, 3), (Object[])new Object[]{"X X", "XYX", Character.valueOf('X'), GSItems.ThermalClothTier2, Character.valueOf('Y'), new ItemStack(AsteroidsItems.thermalPadding, 1, 3)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ThermalClothTier2, 4), (Object[])new Object[]{"XZX", "ZYZ", "XZX", Character.valueOf('X'), Blocks.field_150325_L, Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 6), Character.valueOf('Z'), "ingotCobalt"});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 3), (Object[])new Object[]{"XZX", "CYC", "BBB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(MarsItems.marsItemBasic, 1, 6), Character.valueOf('Z'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(GSItems.Ingots, 1, 0), Character.valueOf('B'), plateSteel});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 3, 11), (Object[])new Object[]{"XXX", "CYC", "XXX", Character.valueOf('X'), plateIron, Character.valueOf('C'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('Y'), Items.field_151117_aB});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 14), (Object[])new Object[]{"XZX", "CYC", "BBB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 13), Character.valueOf('Z'), Items.field_151137_ax, Character.valueOf('C'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('B'), plateSteel});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 15), (Object[])new Object[]{"XZX", "CYC", "BBB", Character.valueOf('X'), new ItemStack(GCBlocks.aluminumWire, 1, 1), Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 10), Character.valueOf('Z'), new ItemStack(GSItems.BasicItems, 1, 7), Character.valueOf('C'), new ItemStack(Items.field_151043_k, 1, 0), Character.valueOf('B'), plateSteel});
        int var2 = 100;
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.JetPack, 1, 100), (Object[])new Object[]{"ABA", "CDC", "EFE", Character.valueOf('A'), MarsBlocks.hydrogenPipe, Character.valueOf('B'), new ItemStack(GCItems.battery, 1, var2), Character.valueOf('C'), "compressedMeteoricIron", Character.valueOf('D'), GCItems.steelChestplate, Character.valueOf('E'), new ItemStack(GCItems.fuelCanister, 1, 1), Character.valueOf('F'), new ItemStack(GCBlocks.aluminumWire, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.PlasmaSword, 1), (Object[])new Object[]{" X ", " X ", "ZVZ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.battery, 1, var2)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.PlasmaAxe, 1), (Object[])new Object[]{"XX ", "XY ", "ZVZ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.battery, 1, var2), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.PlasmaPickaxe, 1), (Object[])new Object[]{"XXX", " Y ", "ZVZ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.battery, 1, var2), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.PlasmaShovel, 1), (Object[])new Object[]{" X ", " Y ", "ZVZ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.battery, 1, var2), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.PlasmaHoe, 1), (Object[])new Object[]{"XX ", " Y ", "ZVZ", Character.valueOf('X'), "plateCobalt", Character.valueOf('Z'), new ItemStack(GCBlocks.aluminumWire, 1, 0), Character.valueOf('V'), new ItemStack(GCItems.battery, 1, var2), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.AdvancedBattery, 1, GSItems.AdvancedBattery.func_77612_l()), (Object[])new Object[]{" T ", "TRT", "TCT", Character.valueOf('T'), "plateNickel", Character.valueOf('R'), new ItemStack(GCItems.battery, 1, GCItems.battery.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ModernBattery, 1, GSItems.ModernBattery.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), plateTitanium, Character.valueOf('R'), new ItemStack(GSItems.AdvancedBattery, 1, GSItems.AdvancedBattery.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 9)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.ExtraBattery, 1, GSItems.ExtraBattery.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), new ItemStack(GSItems.HeavyDutyPlates, 1, 0), Character.valueOf('R'), new ItemStack(GSItems.ModernBattery, 1, GSItems.ModernBattery.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 9)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.UltraBattery, 1, GSItems.UltraBattery.func_77612_l()), (Object[])new Object[]{"RTR", "TYT", "TCT", Character.valueOf('T'), new ItemStack(GSItems.HeavyDutyPlates, 1, 0), Character.valueOf('R'), new ItemStack(GSItems.ExtraBattery, 1, GSItems.ExtraBattery.func_77612_l()), Character.valueOf('C'), Items.field_151137_ax, Character.valueOf('Y'), new ItemStack(GSItems.BasicItems, 1, 10)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.QuantBow, 1), (Object[])new Object[]{" XY", "XTY", " XY", Character.valueOf('X'), "ingotCobalt", Character.valueOf('Y'), Items.field_151007_F, Character.valueOf('T'), Items.field_151072_bj});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 1), (Object[])new Object[]{"X  ", "YX ", "VZX", Character.valueOf('Y'), plateSteel, Character.valueOf('X'), GCItems.flagPole, Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 1), Character.valueOf('Z'), plateIron});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 2), (Object[])new Object[]{"YXY", "XYX", "YXY", Character.valueOf('X'), new ItemStack(GSItems.BasicItems, 1, 1), Character.valueOf('Y'), GCItems.flagPole});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.RocketModules, 1, 0), (Object[])new Object[]{"ZXX", "XYV", "BNB", Character.valueOf('Z'), new ItemStack(GCItems.basicItem, 1, 19), Character.valueOf('X'), new ItemStack(GCItems.basicItem, 1, 9), Character.valueOf('Y'), new ItemStack(GCItems.partBuggy, 1, 1), Character.valueOf('V'), new ItemStack(GCItems.basicItem, 1, 6), Character.valueOf('B'), GCItems.flagPole, Character.valueOf('N'), new ItemStack(GCItems.rocketEngine, 1, 0)});
        for (var3 = 0; var3 < 16; ++var3) {
            RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.RocketModules, 1, 1), (Object[])new Object[]{"ZXZ", "YVY", "ZYZ", Character.valueOf('Z'), new ItemStack(Items.field_151007_F, 1, 0), Character.valueOf('X'), new ItemStack(GCItems.parachute, 1, var3), Character.valueOf('Y'), GCItems.canvas, Character.valueOf('V'), new ItemStack(GSItems.RocketModules, 1, 0)});
        }
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.RocketModules, 1, 2), (Object[])new Object[]{"ZXZ", "YWY", "ZZZ", Character.valueOf('Z'), plateSteel, Character.valueOf('X'), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), Character.valueOf('Y'), new ItemStack(GCItems.flagPole, 1, 0), Character.valueOf('W'), new ItemStack(GCItems.partBuggy, 1, 1)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OxygenTankTier4, 1, GSItems.OxygenTankTier4.func_77612_l()), (Object[])new Object[]{"XYX", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(Blocks.field_150325_L, 1, 11), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GCItems.oxTankHeavy, 1, GCItems.oxTankHeavy.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OxygenTankTier5, 1, GSItems.OxygenTankTier5.func_77612_l()), (Object[])new Object[]{"XYX", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GSItems.OxygenTankTier4, 1, GSItems.OxygenTankTier4.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6)});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OxygenTankTier6, 1, GSItems.OxygenTankTier6.func_77612_l()), (Object[])new Object[]{"XYA", "ZCZ", "ZZZ", Character.valueOf('X'), new ItemStack(GCItems.oxygenVent, 1, 0), Character.valueOf('Y'), GCBlocks.oxygenPipe, Character.valueOf('C'), new ItemStack(GSItems.OxygenTankTier5, 1, GSItems.OxygenTankTier5.func_77612_l()), Character.valueOf('Z'), new ItemStack(AsteroidsItems.basicItem, 1, 6), Character.valueOf('A'), GCItems.oxygenConcentrator});
        RecipeUtil.addRecipe((ItemStack)new ItemStack(GSItems.OxygenCanister, 1, GSItems.OxygenCanister.func_77612_l()), (Object[])new Object[]{"ZAZ", "ZBZ", "ZCZ", Character.valueOf('Z'), plateTin, Character.valueOf('A'), new ItemStack(GCItems.oxygenConcentrator, 1, 0), Character.valueOf('B'), new ItemStack(GCItems.canister, 1, 0), Character.valueOf('C'), new ItemStack(Blocks.field_150325_L, 1, 5)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 9, 6), (Object[])new Object[]{new ItemStack(GSBlocks.Ores, 1, 4)});
        for (var3 = 0; var3 < 2; ++var3) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(GSBlocks.DungeonGlowstones, 1, var3), (Object[])new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(GSItems.GlowstoneDusts, 1, var3)});
        }
    }

    private static void addBlockSmelting() {
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSBlocks.Ores, 1, 0), (ItemStack)new ItemStack(GSItems.Ingots, 1, 0), (float)1.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSBlocks.Ores, 1, 1), (ItemStack)new ItemStack(GSItems.Ingots, 1, 2), (float)1.0f);
        GameRegistry.addSmelting((Item)GSItems.IceBucket, (ItemStack)new ItemStack(Items.field_151131_as), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(GSItems.BasicItems, 1, 8), (ItemStack)new ItemStack(Items.field_151042_j, 2), (float)1.0f);
    }

    private static void addCompressor() {
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.CompressedPlates, 1, 0), (Object[])new Object[]{"ingotCobalt", "ingotCobalt"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.CompressedPlates, 1, 1), (Object[])new Object[]{"ingotMagnesium", "ingotMagnesium"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.CompressedPlates, 1, 2), (Object[])new Object[]{"ingotNickel", "ingotNickel"});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.CompressedPlates, 1, 3), (Object[])new Object[]{Blocks.field_150402_ci});
        CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 19), (Object[])new Object[]{plateIron, plateTitanium, plateIron, plateIron, "uranium", plateIron, plateIron, plateTitanium, plateIron});
        if (CompatibilityManager.isIc2Loaded()) {
            CompressorRecipes.addShapelessRecipe((ItemStack)new ItemStack(GSItems.BasicItems, 1, 19), (Object[])new Object[]{plateIron, plateTitanium, plateIron, plateIron, Ic2Items.UranFuel, plateIron, plateIron, plateTitanium, plateIron});
        }
    }

    private static void addCircuitFabricator() {
        ItemStack modernWafers = new ItemStack(GSItems.BasicItems, 1, 7);
        CircuitFabricatorRecipes.addRecipe((ItemStack)modernWafers, (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151045_i), new ItemStack(GSItems.BasicItems, 1, 6), new ItemStack(GSItems.BasicItems, 1, 6), new ItemStack(Items.field_151137_ax), new ItemStack(GCItems.basicItem, 1, 14)});
    }

    private static void addAssembly() {
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.CompressedPlates, 1, 4), "plateBronze", "plateCoal", "plateAluminum");
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.BasicItems, 1, 0), plateSteel, plateSteel, plateSteel, plateSteel, Blocks.field_150410_aZ, plateSteel, plateSteel, plateSteel, plateSteel);
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.RocketModules, 1, 3), new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GSItems.BasicItems, 1, 0), new ItemStack(GSItems.CompressedPlates, 1, 4));
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.SpacesuitHelmet, 1), new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, new ItemStack((Block)Blocks.field_150397_co, 1, 1), plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), GCItems.oxygenConcentrator, new ItemStack(GSItems.CompressedPlates, 1, 4));
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.SpacesuitPlate, 1), plateSteel, "ingotNickel", plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GCItems.steelChestplate, 1, 0), new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel);
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.SpacesuitLeg, 1), new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, "ingotNickel", plateSteel, plateSteel, "ingotNickel", plateSteel);
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.SpacesuitBoots, 1), plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, plateSteel, new ItemStack(GSItems.CompressedPlates, 1, 4), plateSteel, "ingotNickel", new ItemStack(GSItems.CompressedPlates, 1, 4), "ingotNickel");
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.HeavyDutyPlates, 1, 0), "plateMagnesium", new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(AsteroidsItems.basicItem, 1, 0));
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.HeavyDutyPlates, 1, 1), "plateCobalt", new ItemStack(GSItems.HeavyDutyPlates, 1, 0), "plateNickel", new ItemStack(GSItems.BasicItems, 1, 4));
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSItems.HeavyDutyPlates, 1, 2), new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GSItems.HeavyDutyPlates, 1, 1), new ItemStack(GSItems.BasicItems, 1, 10));
        AssemberRecipes.instance.addShapelessRecipe(new ItemStack(GSBlocks.AdvLandingPad, 5, 0), "compressedTitanium", "compressedTitanium", "compressedTitanium", new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GSItems.CompressedPlates, 1, 4), new ItemStack(GCBlocks.basicBlock, 1, 12), new ItemStack(GCBlocks.basicBlock, 1, 12), new ItemStack(GCBlocks.basicBlock, 1, 12));
    }

    private static void addRocketAssembly() {
        CraftingRecipesOverworld.addRocketRecipe(AsteroidsItems.tier3Rocket, GSItems.RocketParts, 0);
        CraftingRecipesOverworld.addRocketRecipe(GSItems.Tier4Rocket, GSItems.RocketParts, 5);
        CraftingRecipesOverworld.addRocketRecipe(GSItems.Tier5Rocket, GSItems.RocketParts, 10);
        CraftingRecipesOverworld.addRocketRecipe(GSItems.Tier6Rocket, GSItems.RocketParts, 15);
    }

    private static void addRecycler() {
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GCBlocks.blockMoon, 1, 4), new ItemStack(GSItems.BasicItems, 1, 6), 25, null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GCBlocks.blockMoon, 1, 5), new ItemStack(GCBlocks.blockMoon, 1, 3), new FluidStack(GSFluids.Helium3, 10));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BasicItems, 1, 4), new ItemStack(GSItems.BasicItems, 6, 5), null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(MarsBlocks.marsBlock, 20, 5), new ItemStack(GSItems.BasicItems, 1, 8), null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(MarsBlocks.marsBlock, 1, 4), new ItemStack(Blocks.field_150347_e, 1, 0), null);
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSItems.BasicItems, 1, 9), new ItemStack(Items.field_151016_H, 1, 0), new FluidStack(GSFluids.SulfurAcid, 5));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(Blocks.field_150403_cj, 1), null, new FluidStack(FluidRegistry.WATER, 100));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.SurfaceIce, 1), null, new FluidStack(FluidRegistry.WATER, 100));
        RecyclerRecipes.recycling().addNewRecipe(new ItemStack(GSBlocks.Ores, 1, 3), new ItemStack(GSItems.BasicItems, 1, 16), null);
    }

    private static void addRocketRecipe(Item rocket, Item parts, int metafirstparts) {
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 0), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 1), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 2), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
        RocketAssemblyRecipes.addShapelessRecipe(new ItemStack(rocket, 1, 3), new ItemStack(parts, 1, metafirstparts), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 1), new ItemStack(parts, 1, metafirstparts + 2), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 3), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack(parts, 1, metafirstparts + 4), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0), new ItemStack((Block)Blocks.field_150486_ae, 1, 0));
    }

    private static void addOtherRecipes() {
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151014_N), 100, Blocks.field_150464_aj, 7, new boolean[]{false, true});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF), null, 100, Blocks.field_150459_bM, 3, new boolean[]{true, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151170_bI), 2, Blocks.field_150469_bN, 3, new boolean[]{true, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151081_bc), new ItemStack(Blocks.field_150440_ba), null, 100, Blocks.field_150394_bc, 1, new boolean[]{false, false});
        TileEntityHydroponicBase.addPlant(new ItemStack(Items.field_151080_bb), new ItemStack(Blocks.field_150423_aK), null, 100, Blocks.field_150393_bb, 3, new boolean[]{false, false});
    }

    public static void parseRecipes() {
        String[] config = GSConfigCore.tradeIDs;
        if (config != null) {
            for (String recipe : config) {
                String[] info = recipe.split(";");
                if (info.length == 2 || info.length == 3) {
                    ItemStack first = CraftingRecipesOverworld.parseStack(info[0]);
                    if (first != null) {
                        ItemStack result = CraftingRecipesOverworld.parseStack(info[info.length == 3 ? 2 : 1]);
                        if (result != null) {
                            ItemStack second = null;
                            if (info.length == 3) {
                                second = CraftingRecipesOverworld.parseStack(info[1]);
                            }
                            if (second != null) {
                                AlienRecipes.getInstance().addRecipe(result, first, second);
                                continue;
                            }
                            AlienRecipes.getInstance().addRecipe(result, first, null);
                            continue;
                        }
                        throw new RuntimeException("[GalaxySpace] Error Alien trace recipe! Result not found!");
                    }
                    throw new RuntimeException("[GalaxySpace] Error Alien trace recipe! First component not found!");
                }
                throw new RuntimeException("[GalaxySpace] Error Alien trace recipe! Inncorect format!");
            }
        }
    }

    public static ItemStack parseStack(String input) {
        if (input != null) {
            Item item = null;
            int count = 1;
            int meta = Short.MAX_VALUE;
            String[] stackInfo = input.split("-");
            if (stackInfo.length == 2) {
                String[] itemInfo = stackInfo[0].split(":");
                item = GameRegistry.findItem((String)(itemInfo.length == 1 ? "minecraft" : itemInfo[0]), (String)itemInfo[itemInfo.length == 1 ? 0 : 1]);
                if (item != null) {
                    String[] metaSize = stackInfo[1].split(":");
                    try {
                        count = Integer.valueOf(metaSize[0]);
                    }
                    catch (Exception e) {
                        count = 1;
                        GalaxySpace.debug("[GalaxySpace] Error Alien trace recipe! Inncorect count format!");
                    }
                    if (metaSize.length == 2) {
                        try {
                            meta = Integer.valueOf(metaSize[1]);
                        }
                        catch (Exception e) {
                            meta = Short.MAX_VALUE;
                            GalaxySpace.debug("[GalaxySpace] Error Alien trace recipe! Inncorect metadata format!");
                        }
                    }
                    if (count < 1) {
                        count = 1;
                    }
                    if (meta < 0) {
                        meta = Short.MAX_VALUE;
                    }
                    return new ItemStack(item, count, meta);
                }
                throw new RuntimeException("[GalaxySpace] Error Alien trace recipe! Item " + item + " not found!");
            }
            throw new RuntimeException("[GalaxySpace] Error Alien trace recipe! Inncorect format!");
        }
        return null;
    }
}

