/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import galaxyspace.GalaxySpace;
import galaxyspace.core.client.nei.NEIGalaxySpaceConfig;
import galaxyspace.core.registers.blocks.GSBlocks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RocketAssemblyRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation assemblymachineTexture = new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/rocket_assembly.png");
    public static int ticksPassed;
    private int alternate = 0;

    public String getRecipeId() {
        return "galaxyspace.rocketassembly";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalaxySpaceConfig.getRocketAssemblyRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)assemblymachineTexture);
        GuiDraw.drawTexturedModalRect((int)-20, (int)25, (int)0, (int)32, (int)237, (int)101);
        this.drawTex(114, 60);
        this.drawTex(74, 60);
        this.drawTex(42, 60);
        this.drawTex(7, 60);
        this.drawTex(7, 31);
        this.drawTex(7, 89);
        this.drawTex(36, 89);
        this.drawTex(36, 31);
        GL11.glColor4f((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)59, (int)33, (int)206, (int)231, (int)Math.min(ticksPassed % 70, 53), (int)6);
    }

    private void drawTex(int x, int y) {
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)206, (int)203, (int)20, (int)20);
        GuiDraw.drawTexturedModalRect((int)x, (int)y, (int)225, (int)203, (int)20, (int)20);
    }

    public void onUpdate() {
        ticksPassed += 1 + this.alternate;
        this.alternate = 1 - this.alternate;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new RocketAssemblyRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new RocketAssemblyRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!pstack.contains(ingredient)) continue;
                this.arecipes.add(new RocketAssemblyRecipe(irecipe));
                continue block0;
            }
        }
    }

    public ArrayList<PositionedStack> getIngredientStacks(int recipe) {
        return (ArrayList)((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredients();
    }

    public PositionedStack getResultStack(int recipe) {
        if (ticksPassed % 70 >= 53) {
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    public String getRecipeName() {
        return GSBlocks.RocketAssembly.func_149732_F();
    }

    public String getGuiTexture() {
        return GalaxySpace.ASSET_PREFIX + "textures/gui/rocket_assembly.png";
    }

    public void drawForeground(int recipe) {
    }

    public class RocketAssemblyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return (ArrayList)this.getCycledIngredients(RocketAssemblyRecipeHandler.this.cycleticks / 20, this.input);
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public RocketAssemblyRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)RocketAssemblyRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public RocketAssemblyRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(new ArrayList<PositionedStack>((Collection)recipe.getKey()), recipe.getValue().copy());
        }
    }
}

