/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import galaxyspace.GalaxySpace;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.RecyclerRecipes;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RecyclerRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation guiTexture = new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/base_gui.png");
    public static int ticksPassed;
    private int alternate = 0;
    static boolean hasLiquid;
    private FluidStack fluidresult = null;
    private boolean hasRand = false;
    private int chanceRand = 0;
    int yoffset = -11;

    public String getRecipeId() {
        return "galaxyspace.recycler";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int i) {
        String name;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)guiTexture);
        GuiDraw.drawTexturedModalRect((int)0, (int)(0 + this.yoffset), (int)0, (int)0, (int)189, (int)88);
        GuiDraw.drawTexturedModalRect((int)15, (int)(36 + this.yoffset), (int)192, (int)26, (int)20, (int)20);
        GuiDraw.drawTexturedModalRect((int)125, (int)(45 + this.yoffset), (int)192, (int)26, (int)20, (int)20);
        GuiDraw.drawTexturedModalRect((int)148, (int)(19 + this.yoffset), (int)192, (int)26, (int)20, (int)20);
        GuiDraw.drawTexturedModalRect((int)148, (int)(41 + this.yoffset), (int)192, (int)66, (int)20, (int)42);
        if (this.fluidresult != null) {
            if (ticksPassed % 70 >= 53) {
                GSUtils.drawFluid(new FluidStack(this.fluidresult, 1), 150, 43 + this.yoffset, 16, 38, 1);
            }
            name = new FluidStack(this.fluidresult, 1).getLocalizedName() + ": " + this.fluidresult.amount + " mB";
            GuiDraw.fontRenderer.func_78276_b(name, 120 - name.length() * 3, 73 + this.yoffset, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        }
        if (this.hasRand) {
            name = "Chance: " + this.chanceRand + "%";
            GuiDraw.fontRenderer.func_78276_b(name, 120 - name.length() * 3, 25 + this.yoffset, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)0));
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)guiTexture);
        GuiDraw.drawTexturedModalRect((int)148, (int)(41 + this.yoffset), (int)212, (int)66, (int)20, (int)42);
        GuiDraw.drawTexturedModalRect((int)75, (int)(36 + this.yoffset), (int)230, (int)60, (int)24, (int)26);
        GuiDraw.drawTexturedModalRect((int)104, (int)(44 + this.yoffset), (int)212, (int)108, (int)16, (int)17);
        GuiDraw.drawTexturedModalRect((int)40, (int)(43 + this.yoffset), (int)203, (int)131, (int)24, (int)4);
        GuiDraw.drawTexturedModalRect((int)64, (int)(43 + this.yoffset), (int)203, (int)131, (int)11, (int)4);
        GuiDraw.drawTexturedModalRect((int)72, (int)(66 + this.yoffset), (int)203, (int)131, (int)24, (int)4);
        GuiDraw.drawTexturedModalRect((int)72, (int)(46 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(49 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(51 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(54 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(57 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(60 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)72, (int)(63 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)101, (int)(50 + this.yoffset), (int)203, (int)114, (int)3, (int)4);
        GuiDraw.drawTexturedModalRect((int)96, (int)(66 + this.yoffset), (int)203, (int)131, (int)3, (int)4);
        GuiDraw.drawTexturedModalRect((int)96, (int)(63 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)96, (int)(60 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)96, (int)(57 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)96, (int)(54 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)96, (int)(51 + this.yoffset), (int)203, (int)131, (int)3, (int)3);
        GuiDraw.drawTexturedModalRect((int)99, (int)(51 + this.yoffset), (int)203, (int)131, (int)6, (int)4);
        if (ticksPassed % 70 >= 53) {
            GuiDraw.drawTexturedModalRect((int)104, (int)(44 + this.yoffset), (int)212, (int)124, (int)16, (int)17);
            GuiDraw.drawTexturedModalRect((int)75, (int)(39 + this.yoffset), (int)230, (int)86, (int)24, (int)24);
        }
    }

    public void onUpdate() {
        ticksPassed += 1 + this.alternate;
        this.alternate = 1 - this.alternate;
        super.onUpdate();
    }

    public void loadTransferRects() {
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            List<RecyclerRecipes.RecycleRecipe> recipes = RecyclerRecipes.recycling().getRecipes();
            for (RecyclerRecipes.RecycleRecipe recipe : recipes) {
                this.arecipes.add(new RecyclerRecipe(recipe.getInput(), recipe.getOutput()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List<RecyclerRecipes.RecycleRecipe> recipes = RecyclerRecipes.recycling().getRecipes();
        for (RecyclerRecipes.RecycleRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getOutput(), (ItemStack)result)) continue;
            this.arecipes.add(new RecyclerRecipe(recipe.getInput(), recipe.getOutput()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<RecyclerRecipes.RecycleRecipe> recipes = RecyclerRecipes.recycling().getRecipes();
        for (RecyclerRecipes.RecycleRecipe recipe : recipes) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getInput(), (ItemStack)ingredient)) continue;
            RecyclerRecipe arecipe = new RecyclerRecipe(recipe.getInput(), recipe.getOutput());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.input), ingredient);
            this.arecipes.add(arecipe);
            break;
        }
    }

    public PositionedStack getResultStack(int recipe) {
        PositionedStack input = ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getIngredient();
        hasLiquid = false;
        List<RecyclerRecipes.RecycleRecipe> recyclerecipes = RecyclerRecipes.recycling().getRecipes();
        RecyclerRecipes.RecycleRecipe rec_recipe = null;
        for (RecyclerRecipes.RecycleRecipe recipes : recyclerecipes) {
            if (!recipes.getInput().func_77969_a(input.item)) continue;
            rec_recipe = recipes;
            break;
        }
        if (rec_recipe != null && ticksPassed % 70 >= 53) {
            if (rec_recipe.hasChance()) {
                this.hasRand = rec_recipe.hasChance();
                this.chanceRand = rec_recipe.getChance();
            } else {
                this.hasRand = false;
            }
            if (rec_recipe.getFluidStack() != null) {
                this.fluidresult = rec_recipe.getFluidStack();
                hasLiquid = true;
            } else {
                hasLiquid = false;
            }
            return ((TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipe)).getResult();
        }
        return null;
    }

    public String getRecipeName() {
        return EnumColor.WHITE + GCCoreUtil.translate((String)(GSBlocks.Recycler.func_149739_a() + ".name"));
    }

    public String getGuiTexture() {
        return GalaxySpace.ASSET_PREFIX + "textures/gui/rocket_assembly.png";
    }

    public void drawForeground(int recipe) {
    }

    static {
        hasLiquid = false;
    }

    public class RecyclerRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack input;
        public PositionedStack output;

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public RecyclerRecipe(ItemStack ingred, ItemStack result) {
            super((TemplateRecipeHandler)RecyclerRecipeHandler.this);
            this.input = new PositionedStack((Object)ingred, 17, 38 + RecyclerRecipeHandler.this.yoffset);
            if (result != null) {
                this.output = new PositionedStack((Object)result, 127, 47 + RecyclerRecipeHandler.this.yoffset);
            }
        }
    }
}

