/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.items.armor;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IItemPressurized;
import galaxyspace.api.item.IItemRadiation;
import galaxyspace.api.item.IJetpack;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.core.client.models.ModelOBJArmor;
import galaxyspace.core.prefab.items.ItemElectricArmor;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemSpaceSuitModel;
import java.util.List;
import micdoodle8.mods.galacticraft.api.item.IArmorGravity;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.core.client.gui.overlay.OverlaySensorGlasses;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import org.lwjgl.input.Keyboard;
import thaumcraft.api.IGoggles;
import thaumcraft.api.IVisDiscountGear;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.nodes.IRevealer;

@Optional.InterfaceList(value={@Optional.Interface(iface="thaumcraft.api.IGoggles", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.nodes.IRevealer", modid="Thaumcraft"), @Optional.Interface(iface="thaumcraft.api.IVisDiscountGear", modid="Thaumcraft")})
public class ItemSpaceArmors
extends ItemElectricArmor
implements IModificationItem,
IJetpack,
IArmorGravity,
IItemPressurized,
IItemRadiation,
ISpecialArmor,
IRevealer,
IGoggles,
IVisDiscountGear {
    private int tier = 1;
    public static String mod_count = "modification_count";
    public static boolean[] pressedKey = new boolean[3];
    public static String[] suit_buttons = new String[]{"helmet_button", "chest_button", "legs_button", "boots_button"};
    private boolean[] key_handler = new boolean[4];
    boolean test = false;
    public float transferMax = 200.0f;
    private float jumpCharge;

    public ItemSpaceArmors(ItemArmor.ArmorMaterial material, int proxyIndex, int armorIndex, String assetSuffix) {
        super(material, proxyIndex, armorIndex, assetSuffix);
        this.func_111206_d(GalaxySpace.ASSET_PREFIX + ":armors/" + assetSuffix);
        this.setNoRepair();
    }

    public CreativeTabs func_77640_w() {
        return GSCreativeTabs.GSArmorTab;
    }

    @Override
    public boolean canFly(ItemStack stack, EntityPlayer player) {
        return stack.func_77942_o() && stack.field_77990_d.func_74767_n("jetpack") && stack.func_77978_p().func_74767_n(suit_buttons[1]) && stack.func_77960_j() < stack.func_77958_k();
    }

    public void needText(EntityPlayer player, String text) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)("gui.message." + text))));
    }

    public void installText(EntityPlayer player, String text) {
        player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)("gui.message.install." + text))));
    }

    public int getArmorType(ItemStack stack) {
        int i = EntityLiving.func_82159_b((ItemStack)stack) - 1;
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (this.getArmorType(stack) == 3 && stack.field_77990_d.func_74767_n("sensor") && this.getElectricityStored(stack) > 2.0f && stack.func_77978_p().func_74767_n(suit_buttons[0])) {
            OverlaySensorGlasses.renderSensorGlassesMain((ItemStack)stack, (EntityPlayer)player, (ScaledResolution)resolution, (float)partialTicks, (boolean)hasScreen, (int)mouseX, (int)mouseY);
            OverlaySensorGlasses.renderSensorGlassesValueableBlocks((ItemStack)stack, (EntityPlayer)player, (ScaledResolution)resolution, (float)partialTicks, (boolean)hasScreen, (int)mouseX, (int)mouseY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack is, int armorSlot) {
        ItemSpaceSuitModel armorModel = armorSlot == 1 && is.func_77942_o() && is.field_77990_d.func_74767_n("jetpack") ? new ItemSpaceSuitModel(5) : new ItemSpaceSuitModel(armorSlot);
        if (is.func_77973_b() instanceof ItemSpaceArmors) {
            armorModel = ItemSpaceArmors.fillingArmorModel(armorModel, entityLiving);
            if (this.func_82816_b_(is) && armorModel instanceof ModelOBJArmor) {
                ((ModelOBJArmor)armorModel).color = this.func_82814_b(is);
            }
        }
        return armorModel;
    }

    public static ModelBiped fillingArmorModel(ModelBiped model, EntityLivingBase entityLiving) {
        if (model == null) {
            return model;
        }
        model.field_78124_i.field_78806_j = false;
        model.field_78123_h.field_78806_j = false;
        model.field_78113_g.field_78806_j = false;
        model.field_78112_f.field_78806_j = false;
        model.field_78115_e.field_78806_j = false;
        model.field_78114_d.field_78806_j = false;
        model.field_78116_c.field_78806_j = false;
        model.field_78117_n = entityLiving.func_70093_af();
        model.field_78093_q = entityLiving.func_70115_ae();
        model.field_78091_s = entityLiving.func_70631_g_();
        ItemStack held_item = entityLiving.func_71124_b(0);
        if (held_item != null) {
            EntityPlayer player;
            model.field_78120_m = 1;
            if (entityLiving instanceof EntityPlayer && (player = (EntityPlayer)entityLiving).func_71052_bv() > 0) {
                EnumAction enumaction = held_item.func_77975_n();
                if (enumaction == EnumAction.bow) {
                    model.field_78118_o = true;
                } else if (enumaction == EnumAction.block) {
                    model.field_78120_m = 3;
                }
            }
        } else {
            model.field_78120_m = 0;
        }
        if (entityLiving instanceof EntitySkeleton) {
            model.field_78118_o = ((EntitySkeleton)entityLiving).func_82202_m() == 1;
        }
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer player, List par2List, boolean b) {
        par2List.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(GCCoreUtil.translate((String)"gui.spacesuit.desc"), 350));
        if (this.getArmorType(par1ItemStack) == 3) {
            par2List.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(EnumChatFormatting.DARK_GREEN + GCCoreUtil.translate((String)"gui.spacesuit_helmet.desc"), 250));
        }
        String color = "";
        float joules = this.getElectricityStored(par1ItemStack);
        color = joules <= this.getMaxElectricityStored(par1ItemStack) / 3.0f ? color + EnumChatFormatting.DARK_RED : (joules > this.getMaxElectricityStored(par1ItemStack) * 2.0f / 3.0f ? color + EnumChatFormatting.DARK_GREEN : color + EnumChatFormatting.GOLD);
        par2List.add("");
        par2List.add(EnumChatFormatting.DARK_GREEN + GCCoreUtil.translate((String)"gui.module.caninstall"));
        par2List.add(EnumChatFormatting.GRAY + GCCoreUtil.translate((String)"gui.module.available_modules") + " " + par1ItemStack.func_77978_p().func_74762_e(mod_count));
        par2List.add("");
        par2List.add(EnumChatFormatting.AQUA + GCCoreUtil.translate((String)"gui.module.list"));
        if (Keyboard.isKeyDown((int)FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151463_i())) {
            for (ItemModule s : GSUtils.getListModule()) {
                if (s.getEquipmentSlot() != -1 && s.getEquipmentSlot() != this.field_77881_a || !par1ItemStack.func_77978_p().func_74764_b(s.getName())) continue;
                par2List.addAll(FMLClientHandler.instance().getClient().field_71466_p.func_78271_c(this.check(par1ItemStack, s.getName()) + GCCoreUtil.translate((String)("gui.module." + s.getName())), 150));
            }
        } else {
            par2List.add(EnumChatFormatting.DARK_AQUA + GCCoreUtil.translateWithFormat((String)"itemDesc.shift.name", (Object[])new Object[]{GameSettings.func_74298_c((int)FMLClientHandler.instance().getClient().field_71474_y.field_74311_E.func_151463_i())}));
        }
        par2List.add("");
        par2List.add(color + EnergyDisplayHelper.getEnergyDisplayS((float)joules) + "/" + EnergyDisplayHelper.getEnergyDisplayS((float)this.getMaxElectricityStored(par1ItemStack)));
    }

    private String check(ItemStack stack, String nbt) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74767_n(nbt)) {
            return EnumChatFormatting.DARK_GREEN + "-";
        }
        return EnumChatFormatting.DARK_RED + "-";
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.setElectricity(itemStack, 0.0f);
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (!stack.func_77978_p().func_74764_b(mod_count)) {
            stack.func_77978_p().func_74768_a(mod_count, 1 + this.tier);
        }
        switch (this.getArmorType(stack)) {
            case 3: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[0])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[0], false);
                break;
            }
            case 2: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[1])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[1], false);
                break;
            }
            case 1: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[2])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[2], false);
                break;
            }
            case 0: {
                if (stack.func_77978_p().func_74764_b(suit_buttons[3])) break;
                stack.func_77978_p().func_74757_a(suit_buttons[3], false);
                break;
            }
        }
    }

    private void pressed() {
        Minecraft mc = Minecraft.func_71410_x();
        ItemSpaceArmors.pressedKey[0] = mc.field_71474_y.field_74314_A.func_151470_d();
        ItemSpaceArmors.pressedKey[1] = mc.field_71474_y.field_74351_w.func_151470_d();
        ItemSpaceArmors.pressedKey[2] = mc.field_71474_y.field_74311_E.func_151470_d();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            this.pressed();
        }
        if (itemStack.func_77942_o()) {
            for (ItemModule modules : GSUtils.getListModule()) {
                if (this.getArmorType(itemStack) != 3 - modules.getEquipmentSlot() || !itemStack.func_77978_p().func_74767_n(modules.getName())) continue;
                modules.onUpdate(world, player, itemStack, itemStack.func_77978_p().func_74767_n(suit_buttons[3 - this.getArmorType(itemStack)]));
                if (!itemStack.func_77978_p().func_74767_n(suit_buttons[3 - this.getArmorType(itemStack)]) || modules.getDischargeCount() <= 0 || !(this.getElectricityStored(itemStack) >= (float)modules.getDischargeCount()) || player.field_70173_aa % 20 != 0) continue;
                this.discharge(itemStack, modules.getDischargeCount(), true);
            }
            if (this.getArmorType(itemStack) == 0 && itemStack.func_77978_p().func_74767_n(suit_buttons[3])) {
                if (pressedKey[0]) {
                    if (itemStack.field_77990_d.func_74767_n("jump") && this.getElectricityStored(itemStack) >= 5.0f) {
                        if (player.field_70122_E) {
                            this.jumpCharge = 1.0f;
                        }
                        if (player.field_70181_x >= 0.0 && this.jumpCharge > 0.0f && !player.func_70090_H()) {
                            player.field_70143_R = 0.3f;
                            this.discharge(itemStack, 5.0f, true);
                            player.field_70181_x += (double)(this.jumpCharge * 0.25f);
                            this.jumpCharge = (float)((double)this.jumpCharge * 0.4);
                        }
                    } else if (this.jumpCharge < 1.0f) {
                        this.jumpCharge = 0.0f;
                    }
                }
            }
        }
    }

    @Override
    public float getMaxElectricityStored(ItemStack stack) {
        boolean energy = stack.func_77942_o() && stack.func_77978_p().func_74764_b("energy");
        switch (this.getArmorType(stack)) {
            case 0: {
                return energy ? 100000.0f : 25000.0f;
            }
            case 1: {
                return energy ? 150000.0f : 50000.0f;
            }
            case 2: {
                return energy ? 250000.0f : 75000.0f;
            }
            case 3: {
                return energy ? 50000.0f : 20000.0f;
            }
        }
        return 10000.0f;
    }

    public int gravityOverrideIfLow(EntityPlayer player) {
        if (player.func_82169_q(0) != null && !player.func_82169_q(0).func_77942_o()) {
            player.func_82169_q((int)0).field_77990_d = new NBTTagCompound();
        }
        return player.func_82169_q(0) != null && player.func_82169_q((int)0).field_77990_d.func_74767_n("gravity") && this.getElectricityStored(player.func_82169_q(0)) > 0.0f ? 100 : 0;
    }

    public int gravityOverrideIfHigh(EntityPlayer p) {
        return 0;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.15, 25);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.field_77879_b;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        this.discharge(stack, 5.0f, true);
    }

    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(new ItemStack(par1, 1, par1.func_77612_l()));
    }

    @Override
    public void consumeFuel(ItemStack stack, int fuel) {
        stack.func_77964_b(stack.func_77960_j() + 1);
    }

    @Override
    public void decrementFuel(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemElectric) {
            ((IItemElectric)stack.func_77973_b()).discharge(stack, 1.0f, true);
        }
    }

    @Override
    public int getFuel(ItemStack stack) {
        return stack.func_77978_p().func_74762_e("jetpack:fuel");
    }

    @Override
    public boolean isActivated(ItemStack stack) {
        return stack.func_77978_p().func_74767_n("jetpack:activated");
    }

    @Override
    public void switchState(ItemStack stack, boolean state) {
        if (stack != null) {
            stack.func_77978_p().func_74757_a("jetpack:activated", state);
        }
    }

    @Override
    public int getFireStreams(ItemStack stack) {
        return 2;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showNodes(ItemStack stack, EntityLivingBase arg1) {
        return this.field_77881_a == 0 && stack.func_77942_o() && stack.field_77990_d.func_74764_b("thaumvision");
    }

    @Optional.Method(modid="Thaumcraft")
    public boolean showIngamePopups(ItemStack stack, EntityLivingBase arg1) {
        return this.field_77881_a == 0 && stack.func_77942_o() && stack.field_77990_d.func_74764_b("thaumvision");
    }

    @Optional.Method(modid="Thaumcraft")
    public int getVisDiscount(ItemStack stack, EntityPlayer entityPlayer, Aspect aspect) {
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("thaumvision")) {
            return 20;
        }
        return 0;
    }

    @Override
    public GSUtils.Module_Type getType(ItemStack stack) {
        return GSUtils.Module_Type.SPACESUIT;
    }

    @Override
    public int getModificationCount(ItemStack stack) {
        return 2;
    }
}

