/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.overworld.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.systems.SolarSystem.planets.overworld.inventory.ContainerGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementCheckbox;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementTextBox;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGravitationModule
extends GuiContainerGC
implements GuiElementTextBox.ITextBoxCallback,
GuiElementCheckbox.ICheckBoxCallback {
    private static final ResourceLocation electricFurnaceTexture = new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/base_gui.png");
    private GuiElementInfoRegion electricInfoRegion = new GuiElementInfoRegion(0, 0, 56, 9, null, 0, 0, (GuiContainerGC)this);
    private GuiElementCheckbox checkboxRenderEffects;
    private TileEntityGravitationModule tileEntity;
    protected List<GuiElementTextBox> inputFieldList = new ArrayList<GuiElementTextBox>();
    private GuiButton disableButton;
    private GuiElementTextBox strengthField;
    public final int BTN_ENABLE = 6;
    public final int FIELD_STRENGTH = 10;
    private int radius;

    public GuiGravitationModule(InventoryPlayer par1InventoryPlayer, TileEntityGravitationModule tileEntity) {
        super((Container)new ContainerGravitationModule(par1InventoryPlayer, tileEntity));
        this.tileEntity = tileEntity;
        this.field_147000_g = 205;
        this.radius = tileEntity.getGravityRadius();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.electricInfoRegion.tooltipStrings = new ArrayList();
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 17;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 102;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 76, (this.field_146295_m - this.field_147000_g) / 2 + 101, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        batterySlotDesc = new ArrayList();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.module_pressure.desc"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 6, (this.field_146295_m - this.field_147000_g) / 2 + 20, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.field_146292_n.clear();
        int var5 = (this.field_146294_l - this.field_146999_f) / 2;
        int var6 = (this.field_146295_m - this.field_147000_g) / 2;
        this.disableButton = new GuiButton(6, var5 + 110, var6 + 63, 50, 20, GCCoreUtil.translate((String)"gui.button.disable.name"));
        this.checkboxRenderEffects = new GuiElementCheckbox(0, (GuiElementCheckbox.ICheckBoxCallback)this, var5 + 14, var6 + 65, EnumColor.WHITE + GCCoreUtil.translate((String)"gui.message.effectVisible.name"));
        this.field_146292_n.add(this.checkboxRenderEffects);
        this.field_146292_n.add(this.disableButton);
        this.strengthField = new GuiElementTextBox(10, (GuiElementTextBox.ITextBoxCallback)this, var5 + 110, var6 + 41, 38, 18, "0", true, 2, true);
        this.addInputField(this.strengthField);
    }

    protected void func_146979_b(int par1, int par2) {
        this.field_146289_q.func_78276_b(EnumColor.WHITE + this.tileEntity.func_145825_b(), 86 - this.field_146289_q.func_78256_a(this.tileEntity.func_145825_b()) / 2, 1, 0x404040);
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"gui.gravity.radius.name"), 30, 46, 0x404040);
        String displayText = "";
        displayText = EnumColor.RED + GCCoreUtil.translate((String)"gui.status.disabled.name");
        displayText = this.tileEntity.hasEnoughEnergyToRun && !this.tileEntity.disabled ? EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.status.running.name") : EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.idle.name");
        this.disableButton.field_146126_j = this.tileEntity.disabled ? GCCoreUtil.translate((String)"gui.button.enable.name") : GCCoreUtil.translate((String)"gui.button.disable.name");
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"gui.message.status.name") + ": " + displayText, 100, 104, 0x404040);
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"container.inventory"), 18, this.field_147000_g - 89, 0x404040);
        if (this.field_147002_h.func_75139_a(1).func_75216_d()) {
            this.field_146289_q.func_78276_b(EnumColor.BRIGHT_GREEN + GCCoreUtil.translate((String)"gui.message.active_pressure_shield.name"), 30, 24, 0x404040);
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        this.field_146297_k.field_71446_o.func_110577_a(electricFurnaceTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(containerWidth, containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energyStorage.desc.0"));
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.tileEntity.getEnergyStoredGC(), (float)this.tileEntity.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.checkboxRenderEffects.isSelected = this.tileEntity.shouldRenderEffects;
        this.func_73729_b(containerWidth + 16, containerHeight + 102, 192, 47, 56, 9);
        this.func_73729_b(containerWidth + 4, containerHeight + 102, 192, 56, 11, 10);
        if (this.tileEntity.getEnergyStoredGC() > 0.0f) {
            int scale = this.tileEntity.getScaledElecticalLevel(55);
            this.func_73729_b(containerWidth + 116 - 99, containerHeight + 103, 192, 0, scale, 7);
            this.func_73729_b(containerWidth + 3, containerHeight + 102, 192, 7, 11, 10);
        }
        for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
            int x = this.field_147002_h.func_75139_a((int)i).field_75223_e;
            int y = this.field_147002_h.func_75139_a((int)i).field_75221_f;
            GL11.glPushMatrix();
            switch (i) {
                case 0: {
                    this.func_73729_b(containerWidth + x - 2, containerHeight + y - 2, 213, 26, 20, 21);
                    break;
                }
                default: {
                    this.func_73729_b(containerWidth + x - 2, containerHeight + y - 2, 192, 26, 20, 21);
                }
            }
            GL11.glPopMatrix();
        }
    }

    public void onSelectionChanged(GuiElementCheckbox checkbox, boolean newSelected) {
        this.tileEntity.shouldRenderEffects = newSelected;
        GalaxySpace.packetPipeline.sendToServer(new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_ON_ADVANCED_GUI_CLICKED_INT, 6, this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, newSelected ? 1 : 0));
    }

    protected void sendDataToServer() {
        BlockVec3 pos = new BlockVec3((TileEntity)this.tileEntity);
        int actualStrength = this.radius;
        GalaxySpace.packetPipeline.sendToServer(new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_GRAVITY_RADIUS, pos, actualStrength));
        this.tileEntity.setGravityRadius(actualStrength);
    }

    protected void func_146284_a(GuiButton btn) {
        switch (btn.field_146127_k) {
            case 6: {
                GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e, 0}));
            }
        }
    }

    protected void func_73869_a(char keyChar, int keyID) {
        if (keyID != 1) {
            for (GuiElementTextBox box : this.inputFieldList) {
                if (!box.keyTyped(keyChar, keyID)) continue;
                return;
            }
        }
        super.func_73869_a(keyChar, keyID);
    }

    public boolean canPlayerEdit(GuiElementCheckbox checkbox, EntityPlayer player) {
        return true;
    }

    public boolean getInitiallySelected(GuiElementCheckbox checkbox) {
        return this.tileEntity.shouldRenderEffects;
    }

    public void onIntruderInteraction() {
    }

    protected void addInputField(GuiElementTextBox box) {
        this.field_146292_n.add(box);
        this.inputFieldList.add(box);
    }

    public boolean canPlayerEdit(GuiElementTextBox textBox, EntityPlayer player) {
        return true;
    }

    public void onTextChanged(GuiElementTextBox textBox, String newText) {
        double newValue;
        if (newText == null) {
            return;
        }
        try {
            newValue = Double.parseDouble(newText);
        }
        catch (NumberFormatException wat) {
            return;
        }
        if (newValue < 0.0) {
            return;
        }
        switch (textBox.field_146127_k) {
            case 10: {
                this.radius = (int)newValue;
                break;
            }
            default: {
                return;
            }
        }
        this.sendDataToServer();
    }

    public String getInitialText(GuiElementTextBox textBox) {
        switch (textBox.field_146127_k) {
            case 10: {
                return Integer.toString(this.radius);
            }
        }
        return Integer.toString(textBox.field_146127_k);
    }

    public int getTextColor(GuiElementTextBox textBox) {
        return ColorUtil.to32BitColor((int)255, (int)20, (int)255, (int)20);
    }

    public void onIntruderInteraction(GuiElementTextBox textBox) {
    }
}

