/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.planets.mercury.dimension;

import galaxyspace.core.registers.fluids.GSFluids;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;

public class TeleportTypeMercury
implements ITeleportType {
    public boolean useParachute() {
        return false;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            double x = stats.coordsTeleportedFromX;
            double z = stats.coordsTeleportedFromZ;
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > (double)limit) {
                    z *= (double)limit / x;
                    x = limit;
                } else if (x < (double)(-limit)) {
                    z *= (double)(-limit) / x;
                    x = -limit;
                }
                if (z > (double)limit) {
                    x *= (double)limit / z;
                    z = limit;
                } else if (z < (double)(-limit)) {
                    x *= (double)(-limit) / z;
                    z = -limit;
                }
            }
            return new Vector3(x, ConfigManagerCore.disableLander ? 250.0 : 900.0, z);
        }
        return null;
    }

    public Vector3 getEntitySpawnLocation(WorldServer world, Entity entity) {
        return new Vector3(entity.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, entity.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer world, EntityPlayerMP player, Random rand) {
        return null;
    }

    public void onSpaceDimensionChanged(World newWorld, EntityPlayerMP player, boolean ridingAutoRocket) {
        if (!ridingAutoRocket && player != null && GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLandingBalloons lander = new EntityLandingBalloons(player);
            if (!newWorld.field_72995_K) {
                if (GCPlayerStats.get((EntityPlayerMP)player).rocketType >= 4) {
                    lander.fuelTank.setFluid(new FluidStack(GSFluids.HeliumHydrogen, lander.fuelTank.getFluidAmount()));
                }
                newWorld.func_72838_d((Entity)lander);
            }
            GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown = 10;
        }
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }
}

