/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.triton.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.moons.triton.dimension.ChunkProviderTriton;
import galaxyspace.systems.SolarSystem.moons.triton.dimension.WorldChunkManagerTriton;
import galaxyspace.systems.SolarSystem.moons.triton.dimension.sky.SkyProviderTriton;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderTriton
extends WorldProviderAdvancedSpace
implements IExitHeight,
ISolarLevel,
ITeleportType,
IAdvancedSpace {
    private float[] colorsSunriseSunset = new float[4];

    @Override
    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSizeForMoon();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 9.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.tritonNeptune;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderTriton.class;
    }

    public Vector3 getFogColor() {
        float f = 0.4f - this.getSunBrightness(1.0f);
        return new Vector3((double)(0.40784314f * f), (double)(0.40784314f * f), (double)(0.40784314f * f));
    }

    public Vector3 getSkyColor() {
        return new Vector3(0.0, 0.0, 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float p_76560_1_, float p_76560_2_) {
        return null;
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerTriton.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @Override
    public double getYCoordinateToTeleport() {
        return 800.0;
    }

    public Vector3 getEntitySpawnLocation(WorldServer arg0, Entity arg1) {
        return new Vector3(arg1.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, arg1.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer arg0, EntityPlayerMP arg1, Random arg2) {
        if (ConfigManagerCore.disableLander) {
            double x = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            double z = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            return new Vector3(x, 220.0, z);
        }
        return null;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            double x = stats.coordsTeleportedFromX;
            double z = stats.coordsTeleportedFromZ;
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > (double)limit) {
                    z *= (double)limit / x;
                    x = limit;
                } else if (x < (double)(-limit)) {
                    z *= (double)(-limit) / x;
                    x = -limit;
                }
                if (z > (double)limit) {
                    x *= (double)limit / z;
                    z = limit;
                } else if (z < (double)(-limit)) {
                    x *= (double)(-limit) / z;
                    z = -limit;
                }
            }
            return new Vector3(x, ConfigManagerCore.disableLander ? 250.0 : 900.0, z);
        }
        return null;
    }

    public void onSpaceDimensionChanged(World arg0, EntityPlayerMP player, boolean arg2) {
        if (player != null && GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLandingBalloons lander = new EntityLandingBalloons(player);
            if (!arg0.field_72995_K) {
                arg0.func_72838_d((Entity)lander);
            }
            GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown = 10;
        }
    }

    public boolean useParachute() {
        return ConfigManagerCore.disableLander;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.25f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.2f - f2;
        return f2 * 0.2f;
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSizeForMoon();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    public IRenderHandler getCloudRenderer() {
        return new CloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderTriton());
        }
        return super.getSkyRenderer();
    }
}

