/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.triton.dimension;

import com.google.common.collect.Lists;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.world.gen.ChunkProviderSpaceLakes;
import galaxyspace.core.world.gen.GSBiomeGenBase;
import galaxyspace.systems.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.systems.SolarSystem.moons.triton.world.gen.BiomeDecoratorTriton;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderTriton
extends ChunkProviderSpaceLakes {
    private List<MapGenBaseMeta> worldGenerators;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();

    @Override
    protected List<MapGenBaseMeta> getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        return generators;
    }

    public ChunkProviderTriton(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorTriton();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{GSBiomeGenBase.GSSpace};
    }

    @Override
    public int getCraterProbability() {
        return 900;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 15.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry blaze = new BiomeGenBase.SpawnListEntry(EntityEvolvedColdBlaze.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, blaze};
    }

    @Override
    public double getMountainHeightModifier() {
        return 10.0;
    }

    @Override
    public int getWaterLevel() {
        return 70;
    }

    @Override
    public double getSmallFeatureHeightModifier() {
        return 15.0;
    }

    @Override
    public double getValleyHeightModifier() {
        return 10.0;
    }

    @Override
    public void onChunkProvider(int cX, int cZ, Block[] blocks, byte[] metadata) {
    }

    @Override
    public void onPopulate(IChunkProvider arg0, int chunkX, int chunkZ) {
        int k = chunkX * 16;
        int l = chunkZ * 16;
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l1 = 0; l1 < 16; ++l1) {
                int i2 = this.worldObj.func_72825_h(k + k1, l + l1);
                if (i2 > this.getWaterLevel() - 6 && this.worldObj.field_73012_v.nextInt(10) == 0) {
                    if (this.worldObj.func_147439_a(k1 + k, i2 - 1, l1 + l) != GSBlocks.TritonBlocks || this.worldObj.func_72805_g(k1 + k, i2 - 1, l1 + l) != 0) continue;
                    this.worldObj.func_147465_d(k1 + k, i2 - 1, l1 + l, GSBlocks.TritonBlocks, 2, 3);
                    continue;
                }
                if (i2 >= this.getWaterLevel() - 4 || this.worldObj.func_147439_a(k1 + k, i2 - 1, l1 + l) != GSBlocks.TritonBlocks || this.worldObj.func_72805_g(k1 + k, i2 - 1, l1 + l) != 0) continue;
                this.worldObj.func_147465_d(k1 + k, i2 - 1, l1 + l, GSBlocks.TritonBlocks, 1, 3);
            }
        }
    }

    @Override
    public boolean func_73149_a(int x, int y) {
        return false;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(GSBlocks.TritonBlocks, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(GSBlocks.TritonBlocks, 2);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(GSBlocks.TritonBlocks, 3);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return false;
    }

    @Override
    public boolean canGenerateWaterBlock() {
        return false;
    }

    @Override
    public boolean canGenerateIceBlock() {
        return true;
    }

    @Override
    protected BlockMetaPair getWaterBlock() {
        return null;
    }

    @Override
    protected ChunkProviderSpaceLakes.GenType getGenType() {
        return ChunkProviderSpaceLakes.GenType.GC;
    }
}

