/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.titan.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.api.dimension.IPlanetFog;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.world.worldengine.WE_Biome;
import galaxyspace.core.world.worldengine.WE_ChunkProvider;
import galaxyspace.core.world.worldengine.WE_WorldProvider;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_CaveGen;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_TerrainGenerator;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldChunkManagerTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.sky.CloudProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.sky.SkyProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.world.gen.BiomeDecoratorTitanOre;
import galaxyspace.systems.SolarSystem.moons.titan.world.gen.we.WE_TitanBiome;
import galaxyspace.systems.SolarSystem.moons.titan.world.gen.we.WE_TitanHills;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IExitHeight;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityLander;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderTitan_WE
extends WE_WorldProvider
implements IGalacticraftWorldProvider,
IExitHeight,
ISolarLevel,
ITeleportType,
IAdvancedSpace,
IPlanetFog {
    @Override
    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSizeForMoon();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    public double getHorizon() {
        return 44.0;
    }

    public float getFallDamageModifier() {
        return 0.16f;
    }

    public double getFuelUsageMultiplier() {
        return 0.8;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getSoundVolReductionAmount() {
        return 0.4f;
    }

    public CelestialBody getCelestialBody() {
        return SolarSystemBodies.titanSaturn;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return WE_ChunkProvider.class;
    }

    public Vector3 getFogColor() {
        float f = 1.0f;
        return new Vector3((double)(0.85882354f * f), (double)(0.3019608f * f), (double)(0.35686275f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.1f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.8784314f * f), (double)(0.58431375f * f), (double)(0.16862746f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerTitan.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    public Vector3 getEntitySpawnLocation(WorldServer arg0, Entity arg1) {
        return new Vector3(arg1.field_70165_t, ConfigManagerCore.disableLander ? 250.0 : 900.0, arg1.field_70161_v);
    }

    public Vector3 getParaChestSpawnLocation(WorldServer arg0, EntityPlayerMP arg1, Random arg2) {
        if (ConfigManagerCore.disableLander) {
            double x = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            double z = (arg2.nextDouble() * 2.0 - 1.0) * 5.0;
            return new Vector3(x, 220.0, z);
        }
        return null;
    }

    public Vector3 getPlayerSpawnLocation(WorldServer world, EntityPlayerMP player) {
        if (player != null) {
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            double x = stats.coordsTeleportedFromX;
            double z = stats.coordsTeleportedFromZ;
            int limit = ConfigManagerCore.otherPlanetWorldBorders - 2;
            if (limit > 20) {
                if (x > (double)limit) {
                    z *= (double)limit / x;
                    x = limit;
                } else if (x < (double)(-limit)) {
                    z *= (double)(-limit) / x;
                    x = -limit;
                }
                if (z > (double)limit) {
                    x *= (double)limit / z;
                    z = limit;
                } else if (z < (double)(-limit)) {
                    x *= (double)(-limit) / z;
                    z = -limit;
                }
            }
            return new Vector3(x, ConfigManagerCore.disableLander ? 250.0 : 900.0, z);
        }
        return null;
    }

    public void onSpaceDimensionChanged(World arg0, EntityPlayerMP player, boolean arg2) {
        if (player != null && GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown <= 0) {
            if (player.field_71075_bZ.field_75100_b) {
                player.field_71075_bZ.field_75100_b = false;
            }
            EntityLander lander = new EntityLander(player);
            if (!arg0.field_72995_K) {
                arg0.func_72838_d((Entity)lander);
            }
            GCPlayerStats.get((EntityPlayerMP)player).teleportCooldown = 10;
        }
    }

    public boolean useParachute() {
        return ConfigManagerCore.disableLander;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer(new CloudProviderTitan());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderTitan());
        }
        return super.getSkyRenderer();
    }

    public boolean canRainOrSnow() {
        return false;
    }

    public void setupAdventureSpawn(EntityPlayerMP player) {
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSizeForMoon();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    @Override
    public void genSettings(WE_ChunkProvider cp) {
        cp.createChunkGen_List.clear();
        cp.createChunkGen_InXZ_List.clear();
        cp.createChunkGen_InXYZ_List.clear();
        cp.decorateChunkGen_List.clear();
        WE_Biome.setBiomeMap(cp, 1.2, 4, 800.5, 0.458);
        WE_TerrainGenerator terrainGenerator = new WE_TerrainGenerator();
        terrainGenerator.worldStoneBlock = GSBlocks.TitanBlocks;
        terrainGenerator.worldStoneBlockMeta = (byte)2;
        terrainGenerator.worldSeaGen = true;
        terrainGenerator.worldSeaGenBlock = GSFluids.BlockLiquidMethane;
        terrainGenerator.worldSeaGenMaxY = 64;
        cp.createChunkGen_List.add(terrainGenerator);
        WE_CaveGen cg = new WE_CaveGen();
        cg.replaceBlocksList.clear();
        cg.replaceBlocksMetaList.clear();
        cg.addReplacingBlock(terrainGenerator.worldStoneBlock, terrainGenerator.worldStoneBlockMeta);
        cp.createChunkGen_List.add(cg);
        WE_Biome.addBiomeToGeneration(cp, new WE_TitanHills(cp));
        WE_Biome.addBiomeToGeneration(cp, new WE_TitanBiome(cp));
    }

    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider};
    }

    @Override
    public float getFogDensity(int x, int y, int z) {
        return 0.4f;
    }

    @Override
    public int getFogColor(int x, int y, int z) {
        int R = 0xD60000;
        int G = 38912;
        int B = 44;
        int color = R + G + B;
        return color - 0x1000000;
    }

    @Override
    public BiomeDecoratorSpace getDecorator() {
        return new BiomeDecoratorTitanOre();
    }
}

