/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem.moons.europa.dimension;

import com.google.common.collect.Lists;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.world.gen.ChunkProviderSpaceLakes;
import galaxyspace.core.world.gen.GSBiomeGenBase;
import galaxyspace.core.world.gen.GS_GenBlocks;
import galaxyspace.systems.SolarSystem.moons.europa.world.gen.BiomeDecoratorEuropaOre;
import galaxyspace.systems.SolarSystem.moons.europa.world.gen.MapGenRavineEuropa;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.perlin.NoiseModule;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderEuropa
extends ChunkProviderSpaceLakes {
    private final NoiseModule noiseGen4;
    private static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 128;
    private static final int CHUNK_SIZE_Z = 16;
    private List<MapGenBaseMeta> worldGenerators;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();
    private final MapGenRavineEuropa ravineGenerator = new MapGenRavineEuropa();

    protected List getWorldGenerators() {
        ArrayList generators = Lists.newArrayList();
        generators.add(this.ravineGenerator);
        return generators;
    }

    public ChunkProviderEuropa(World par1World, long seed, boolean mapFeaturesEnabled) {
        super(par1World, seed, mapFeaturesEnabled);
        this.noiseGen4 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        ChunkProviderEuropa.setBlocks(new GS_GenBlocks(this.worldObj.field_73011_w, this.getBiomesForGeneration()[0], this.getGrassBlock(), this.getDirtBlock(), this.getStoneBlock()));
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorEuropaOre();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{GSBiomeGenBase.GSSpace};
    }

    @Override
    public int getCraterProbability() {
        return 30;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 15.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider};
    }

    @Override
    public double getMountainHeightModifier() {
        return 35.0;
    }

    @Override
    public double getSmallFeatureHeightModifier() {
        return 50.0;
    }

    @Override
    public double getValleyHeightModifier() {
        return 5.0;
    }

    @Override
    public void onChunkProvider(int cX, int cZ, Block[] blocks, byte[] metadata) {
    }

    @Override
    public void onPopulate(IChunkProvider arg0, int arg1, int arg2) {
        int k = arg1 * 16;
        int l = arg2 * 16;
        for (int k1 = 0; k1 < 16; ++k1) {
            for (int l1 = 0; l1 < 16; ++l1) {
                int i2 = this.worldObj.func_72825_h(k + k1, l + l1);
                if (i2 > this.getWaterLevel() + 2 || i2 >= this.getWaterLevel() - 5 && i2 < this.getWaterLevel() + 3) {
                    if (this.worldObj.func_147439_a(k1 + k, i2 - 1, l1 + l) != GSBlocks.EuropaBlocks || this.worldObj.func_72805_g(k1 + k, i2 - 1, l1 + l) != 0) continue;
                    this.worldObj.func_147465_d(k1 + k, i2, l1 + l, Blocks.field_150433_aE, 0, 2);
                    this.worldObj.func_147465_d(k1 + k, i2 + 1, l1 + l, Blocks.field_150431_aC, 0, 2);
                    continue;
                }
                if (i2 >= this.getWaterLevel() - 6 || this.worldObj.func_147439_a(k1 + k, i2 - 1, l1 + l) != GSBlocks.EuropaBlocks || this.worldObj.func_72805_g(k1 + k, i2 - 1, l1 + l) != 0) continue;
                this.worldObj.func_147465_d(k1 + k, i2, l1 + l, Blocks.field_150403_cj, 0, 2);
            }
        }
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(GSBlocks.EuropaBlocks, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(Blocks.field_150403_cj, 0);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(Blocks.field_150355_j, 0);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return true;
    }

    @Override
    public int getWaterLevel() {
        return 95;
    }

    @Override
    public boolean canGenerateWaterBlock() {
        return false;
    }

    @Override
    public boolean canGenerateIceBlock() {
        return true;
    }

    @Override
    protected BlockMetaPair getWaterBlock() {
        return new BlockMetaPair(Blocks.field_150432_aD, 1);
    }

    @Override
    protected ChunkProviderSpaceLakes.GenType getGenType() {
        return ChunkProviderSpaceLakes.GenType.GC;
    }

    @Override
    public double getDirtLayerSize() {
        return 40.0;
    }

    @Override
    protected BlockMetaPair getIceBlock() {
        return new BlockMetaPair(GSBlocks.EuropaBlocks, 1);
    }
}

