/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.SolarSystem;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.GalaxySpace;
import galaxyspace.api.BodiesHelper;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.api.dimension.world.OreGenerator;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.moons.callisto.dimension.WorldProviderCallisto;
import galaxyspace.systems.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.systems.SolarSystem.moons.enceladus.recipe.CraftingRecipesEnceladus;
import galaxyspace.systems.SolarSystem.moons.europa.dimension.WorldProviderEuropa;
import galaxyspace.systems.SolarSystem.moons.europa.recipe.CraftingRecipesEuropa;
import galaxyspace.systems.SolarSystem.moons.ganymede.dimension.WorldProviderGanymede;
import galaxyspace.systems.SolarSystem.moons.ganymede.recipe.CraftingRecipesGanymede;
import galaxyspace.systems.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.systems.SolarSystem.moons.io.recipe.CraftingRecipesIo;
import galaxyspace.systems.SolarSystem.moons.miranda.dimension.WorldProviderMiranda;
import galaxyspace.systems.SolarSystem.moons.miranda.recipe.CraftingRecipesMiranda;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan_WE;
import galaxyspace.systems.SolarSystem.moons.triton.dimension.WorldProviderTriton;
import galaxyspace.systems.SolarSystem.moons.triton.recipe.CraftingRecipesTriton;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.TeleportTypeCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.systems.SolarSystem.planets.ceres.recipe.CraftingRecipesCeres;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.systems.SolarSystem.planets.mars.recipes.CraftingRecipesMars;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.TeleportTypeMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.systems.SolarSystem.planets.mercury.recipe.CraftingRecipesMercury;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.CraftingRecipesOverworld;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicBodyRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicBoosterRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicConeRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicEngineRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicFinsRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicOxTankRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicPortableNuclearRecipe;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.schematic.SchematicTier2Recipe;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicBody;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicBooster;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicCone;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicEngine;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicFins;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicOxTank;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicPortableNuclear;
import galaxyspace.systems.SolarSystem.planets.overworld.schematic.SchematicTier2Rocket;
import galaxyspace.systems.SolarSystem.planets.pluto.dimension.WorldProviderPluto;
import galaxyspace.systems.SolarSystem.planets.pluto.recipe.CraftingRecipesPluto;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.TeleportTypeVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.WorldProviderVenus;
import galaxyspace.systems.SolarSystem.planets.venus.recipe.CraftingRecipesVenus;
import galaxyspace.systems.SolarSystem.satellites.TeleportTypeSS;
import galaxyspace.systems.SolarSystem.satellites.mars.dimension.WorldProviderMarsSS;
import galaxyspace.systems.SolarSystem.satellites.mars.recipe.CraftingRecipeMarsSS;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import micdoodle8.mods.galacticraft.planets.asteroids.schematic.SchematicTier3Rocket;
import micdoodle8.mods.galacticraft.planets.mars.MarsModule;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class SolarSystemBodies
implements IBodiesHandler {
    public static Planet testPlanet;
    public static Planet planetMercury;
    public static Planet planetVenus;
    public static Planet planetMars;
    public static Planet planetCeres;
    public static Planet planetJupiter;
    public static Planet planetSaturn;
    public static Planet planetUranus;
    public static Planet planetNeptune;
    public static Planet planetPluto;
    public static Planet planetKuiperBelt;
    public static Planet planetHaumea;
    public static Planet planetMakemake;
    public static Planet planetEris;
    public static Planet planetDeeDee;
    public static Moon phobosMars;
    public static Moon deimosMars;
    public static Moon ioJupiter;
    public static Moon europaJupiter;
    public static Moon ganymedeJupiter;
    public static Moon callistoJupiter;
    public static Moon mimasSaturn;
    public static Moon enceladusSaturn;
    public static Moon tethysSaturn;
    public static Moon dioneSaturn;
    public static Moon rheyaSaturn;
    public static Moon titanSaturn;
    public static Moon iapetusSaturn;
    public static Moon mirandaUranus;
    public static Moon arielUranus;
    public static Moon umbrielUranus;
    public static Moon titaniaUranus;
    public static Moon oberonUranus;
    public static Moon proteusNeptune;
    public static Moon tritonNeptune;
    public static Moon charonPluto;
    public static Satellite marsSpaceStation;
    public static Satellite venusSpaceStation;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
    }

    @Override
    public void init(FMLInitializationEvent event) {
        SolarSystem sol = GalacticraftCore.solarSystemSol;
        sol.setMapPosition(new Vector3(0.0, 0.0, 0.0));
        planetMercury = BodiesHelper.registerPlanet(sol, "mercury", GalaxySpace.ASSET_PREFIX, WorldProviderMercury.class, GSConfigDimensions.dimensionIDMercury, 4, 1.45f, 0.5f, 0.5f, 0.24096386f);
        planetVenus = (Planet)BodiesHelper.registerPlanet(sol, "venus", GalaxySpace.ASSET_PREFIX, WorldProviderVenus.class, GSConfigDimensions.dimensionIDVenus, 4, 2.0f, 1.0f, 0.75f, 0.6152793f).atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.NITROGEN);
        planetCeres = (Planet)BodiesHelper.registerPlanet(sol, "ceres", GalaxySpace.ASSET_PREFIX, WorldProviderCeres.class, GSConfigDimensions.dimensionIDCeres, 3, 2.0f, 0.5f, 1.7f, 15.0f).setRingColorRGB(0.0f, 0.0f, 0.0f);
        planetJupiter = BodiesHelper.registerPlanet(sol, "jupiter", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 1.0f, 2.0f, 11.861994f);
        planetSaturn = BodiesHelper.registerPlanet(sol, "saturn", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.5707964f, 1.0f, 2.25f, 29.463308f);
        planetUranus = BodiesHelper.registerPlanet(sol, "uranus", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 1.0f, 2.5f, 84.06353f);
        planetNeptune = BodiesHelper.registerPlanet(sol, "neptune", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.0f, 1.0f, 2.75f, 164.84119f);
        planetPluto = (Planet)BodiesHelper.registerPlanet(sol, "pluto", GalaxySpace.ASSET_PREFIX, WorldProviderPluto.class, GSConfigDimensions.dimensionIDPluto, 8, 0.1f, 0.5f, 3.0f, 250.0f).atmosphereComponent(IAtmosphericGas.NITROGEN);
        planetKuiperBelt = (Planet)BodiesHelper.registerPlanet(sol, "kuiperbelt", GalaxySpace.ASSET_PREFIX, WorldProviderKuiper.class, GSConfigDimensions.dimensionIDKuiperBelt, 8, 1.5f, 0.5f, 3.25f, 300.0f).setRingColorRGB(1.1f, 0.0f, 0.0f);
        phobosMars = BodiesHelper.registerMoon(GSConfigCore.enableGCMars ? MarsModule.planetMars : planetMars, "phobos", GalaxySpace.ASSET_PREFIX, null, GSConfigDimensions.dimensionIDPhobos, 2, 1.0f, 0.0017f, 8.0f, 100.0f);
        deimosMars = BodiesHelper.registerMoon(GSConfigCore.enableGCMars ? MarsModule.planetMars : planetMars, "deimos", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.0f, 0.0017f, 16.0f, 300.0f);
        ioJupiter = BodiesHelper.registerMoon(planetJupiter, "io", GalaxySpace.ASSET_PREFIX, WorldProviderIo.class, GSConfigDimensions.dimensionIDIo, 3, 1.0f, 0.0017f, 10.0f, 50.0f);
        europaJupiter = BodiesHelper.registerMoon(planetJupiter, "europa", GalaxySpace.ASSET_PREFIX, WorldProviderEuropa.class, GSConfigDimensions.dimensionIDEuropa, 3, 1.0f, 0.0017f, 15.0f, 100.0f);
        ganymedeJupiter = BodiesHelper.registerMoon(planetJupiter, "ganymede", GalaxySpace.ASSET_PREFIX, WorldProviderGanymede.class, GSConfigDimensions.dimensionIDGanymede, 3, 1.0f, 0.0017f, 20.0f, 150.0f);
        callistoJupiter = BodiesHelper.registerMoon(planetJupiter, "callisto", GalaxySpace.ASSET_PREFIX, WorldProviderCallisto.class, GSConfigDimensions.dimensionIDCallisto, 3, 1.0f, 0.0017f, 30.0f, 200.0f);
        mimasSaturn = BodiesHelper.registerMoon(planetSaturn, "mimas", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.5707964f, 0.0017f, 10.0f, 20.0f);
        enceladusSaturn = BodiesHelper.registerMoon(planetSaturn, "enceladus", GalaxySpace.ASSET_PREFIX, WorldProviderEnceladus.class, GSConfigDimensions.dimensionIDEnceladus, 5, 1.0471976f, 0.0017f, 15.0f, 50.0f);
        tethysSaturn = BodiesHelper.registerMoon(planetSaturn, "tethys", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 0.0017f, 20.0f, 120.0f);
        dioneSaturn = BodiesHelper.registerMoon(planetSaturn, "dione", GalaxySpace.ASSET_PREFIX, null, -1, -1, 0.7853982f, 0.0017f, 25.0f, 180.0f);
        rheyaSaturn = BodiesHelper.registerMoon(planetSaturn, "rheya", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.0471976f, 0.0017f, 30.0f, 220.0f);
        titanSaturn = (Moon)BodiesHelper.registerMoon(planetSaturn, "titan", GalaxySpace.ASSET_PREFIX, GSConfigCore.enableWorldEngine ? WorldProviderTitan_WE.class : WorldProviderTitan.class, GSConfigDimensions.dimensionIDTitan, 5, 0.62831855f, 0.0017f, 35.0f, 280.0f).atmosphereComponent(IAtmosphericGas.NITROGEN).atmosphereComponent(IAtmosphericGas.METHANE).atmosphereComponent(IAtmosphericGas.HYDROGEN);
        iapetusSaturn = BodiesHelper.registerMoon(planetSaturn, "iapetus", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 0.0017f, 40.0f, 350.0f);
        mirandaUranus = BodiesHelper.registerMoon(planetUranus, "miranda", GalaxySpace.ASSET_PREFIX, WorldProviderMiranda.class, GSConfigDimensions.dimensionIDMiranda, 6, (float)Math.PI, 0.0017f, 10.0f, 20.0f);
        arielUranus = BodiesHelper.registerMoon(planetUranus, "ariel", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.5707964f, 0.0017f, 15.0f, 50.0f);
        umbrielUranus = BodiesHelper.registerMoon(planetUranus, "umbriel", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.0471976f, 0.0017f, 20.0f, 120.0f);
        titaniaUranus = BodiesHelper.registerMoon(planetUranus, "titania", GalaxySpace.ASSET_PREFIX, null, -1, -1, 0.7853982f, 0.0017f, 25.0f, 180.0f);
        oberonUranus = BodiesHelper.registerMoon(planetUranus, "oberon", GalaxySpace.ASSET_PREFIX, null, -1, -1, 0.62831855f, 0.0017f, 30.0f, 200.0f);
        proteusNeptune = BodiesHelper.registerMoon(planetNeptune, "proteus", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 0.0017f, 10.0f, 50.0f);
        tritonNeptune = (Moon)BodiesHelper.registerMoon(planetNeptune, "triton", GalaxySpace.ASSET_PREFIX, WorldProviderTriton.class, GSConfigDimensions.dimensionIDTriton, 6, 1.5707964f, 0.0017f, 25.0f, -200.0f).atmosphereComponent(IAtmosphericGas.NITROGEN);
        charonPluto = BodiesHelper.registerMoon(planetPluto, "charon", GalaxySpace.ASSET_PREFIX, null, -1, -1, 1.5707964f, 0.0017f, 15.0f, 50.0f);
        venusSpaceStation = new Satellite("spaceStation.venus").setParentBody(planetVenus);
        venusSpaceStation.setRingColorRGB(0.0f, 0.4f, 0.9f);
        venusSpaceStation.setRelativeSize(0.2667f);
        venusSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        venusSpaceStation.setRelativeOrbitTime(20.0f);
        venusSpaceStation.setTierRequired(4);
        venusSpaceStation.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/spaceStation.png"));
        if (GSConfigCore.enableOverworldGeneration) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.Ores, 0, 12, 0, 60, 5, Blocks.field_150348_b, 0, 0), (int)4);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.Ores, 1, 6, 0, 45, 4, Blocks.field_150348_b, 0, 0), (int)4);
            GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(GSBlocks.Ores, 3, 6, 0, 40, 4, Blocks.field_150348_b, 0, 0), (int)4);
        }
        GalacticraftCore.satelliteSpaceStation.setRingColorRGB(0.0f, 0.4f, 0.9f);
        GalacticraftCore.moonMoon.setRingColorRGB(0.0f, 0.4f, 0.9f);
        MarsModule.planetMars.setRingColorRGB(0.0f, 0.4f, 0.9f);
        marsSpaceStation = new Satellite("spaceStation.mars").setParentBody(GSConfigCore.enableGCMars ? MarsModule.planetMars : planetMars);
        marsSpaceStation.setRingColorRGB(0.0f, 0.4f, 0.9f);
        marsSpaceStation.setRelativeSize(0.2667f);
        marsSpaceStation.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(10.0f, 10.0f));
        marsSpaceStation.setRelativeOrbitTime(20.0f);
        marsSpaceStation.setDimensionInfo(GSConfigDimensions.dimensionIDMarsOrbit, GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class);
        marsSpaceStation.setTierRequired(2);
        marsSpaceStation.setBodyIcon(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/spaceStation.png"));
        AsteroidsModule.planetAsteroids.setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance(1.75f, 1.75f));
        SolarSystemBodies.registrycelestial();
        SolarSystemBodies.registryteleport();
        SolarSystemBodies.registryDungeonLoot();
        SolarSystemBodies.registrySchematic();
        SolarSystemBodies.registerRecipesWorkBench();
        GSUtils.registerModules();
    }

    private static void registrySchematic() {
        if (!GSConfigCore.registeredRocket.isEmpty()) {
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicCone());
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBody());
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicEngine());
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicBooster());
            SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicFins());
        }
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicOxTank());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicPortableNuclear());
        for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
            if (!(page instanceof micdoodle8.mods.galacticraft.planets.mars.schematic.SchematicTier2Rocket)) continue;
            SchematicRegistry.schematicRecipes.remove(page);
            break;
        }
        for (ISchematicPage page : SchematicRegistry.schematicRecipes) {
            if (!(page instanceof SchematicTier3Rocket)) continue;
            SchematicRegistry.schematicRecipes.remove(page);
            break;
        }
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicTier2Rocket());
    }

    private static void registerRecipesWorkBench() {
        if (!GSConfigCore.registeredRocket.isEmpty()) {
            SchematicConeRecipe.registerRecipeWorkBench();
            SchematicBodyRecipe.registerRecipeWorkBench();
            SchematicEngineRecipe.registerRecipeWorkBench();
            SchematicBoosterRecipe.registerRecipeWorkBench();
            SchematicFinsRecipe.registerRecipeWorkBench();
        }
        SchematicOxTankRecipe.registerRecipeWorkBench();
        SchematicPortableNuclearRecipe.registerRecipeWorkBench();
        SchematicTier2Recipe.registerRecipeWorkBench();
    }

    private static void registryDungeonLoot() {
        if (!GSConfigCore.registeredRocket.isEmpty()) {
            GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.BasicItems, 1, 12));
        }
        GalacticraftRegistry.addDungeonLoot((int)1, (ItemStack)new ItemStack(GSItems.Schematics, 1, 5));
        GalacticraftRegistry.getDungeonLoot((int)2).clear();
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 1));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(MarsItems.schematic, 1, 2));
        GalacticraftRegistry.addDungeonLoot((int)2, (ItemStack)new ItemStack(GSItems.AncientPickaxe, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.Schematics, 1, 6));
        GalacticraftRegistry.addDungeonLoot((int)4, (ItemStack)new ItemStack(GSItems.AncientSword, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.AncientSword, 1, 0));
        GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.AncientPickaxe, 1, 0));
        if (GSConfigCore.enableGenAncientAmulet) {
            GalacticraftRegistry.addDungeonLoot((int)5, (ItemStack)new ItemStack(GSItems.BasicItems, 1, 17));
        }
    }

    private static void registrycelestial() {
        BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(BodiesHelper.yellow + " " + BodiesHelper.dwarf, 28.088f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)GalacticraftCore.solarSystemSol.getMainStar(), data);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(3.8f), 0, 6.0f, 0.0f, 176000L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)planetMercury, data, GSConfigDimensions.enableMercury);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(8.88f), 92, 12.0f, 1.2f, 182000L, false, false);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)planetVenus, data, GSConfigDimensions.enableVenus);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(10.0f), 1, 1.0f, 1.0f, 24000L, true, false);
        BodiesHelper.registerBody((CelestialBody)GalacticraftCore.planetOverworld, data, false);
        data = new BodiesHelper.BodiesData(null, 0.062f, 0, 0.0f, 0.0f, 192000L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)GalacticraftCore.moonMoon, data, false);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(2.37f), 0, -1.5f, 0.0f, 10000L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)planetCeres, data, GSConfigDimensions.enableCeres);
        data = new BodiesHelper.BodiesData(null, 0.0f, 0, -2.0f, 0.0f, 1L, false, false);
        BodiesHelper.registerBody((CelestialBody)AsteroidsModule.planetAsteroids, data, false);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(8.375f), 100, -5.0f, 10.0f, 9000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetJupiter, data, true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(7.37f), 100, -5.0f, 10.0f, 11000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetSaturn, data, true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(8.61f), 100, -5.0f, 10.0f, 16000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetUranus, data, true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(8.547f), 100, -8.0f, 10.0f, 18000L, false, false);
        BodiesHelper.registerBody((CelestialBody)planetNeptune, data, true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(2.62f), 0, -5.0f, 0.0f, 98000L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)planetPluto, data, GSConfigDimensions.enablePluto);
        data = new BodiesHelper.BodiesData(null, 0.0f, 0, -6.0f, 0.0f, 0L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(AsteroidsItems.grapple, 1, 0));
        data.addItemStack(new ItemStack(Items.field_151007_F, 16, 0));
        BodiesHelper.registerBody((CelestialBody)planetKuiperBelt, data, GSConfigDimensions.enableKuiperBelt);
        data = new BodiesHelper.BodiesData(null, 0.068f, 0, -1.0f, 0.0f, 12000L, false, false);
        BodiesHelper.registerBody((CelestialBody)phobosMars, data, GSConfigDimensions.enablePhobos);
        data = new BodiesHelper.BodiesData(null, 0.064f, 0, -1.0f, 0.0f, 24000L, false, false);
        BodiesHelper.registerBody((CelestialBody)deimosMars, data, GSConfigDimensions.enableDeimos);
        data = new BodiesHelper.BodiesData(null, 0.052f, 0, 2.0f, 0.0f, 42000L, false, true);
        BodiesHelper.registerBody((CelestialBody)ioJupiter, data, GSConfigDimensions.enableIo);
        data = new BodiesHelper.BodiesData(null, 0.062f, 0, -3.0f, 0.0f, 58000L, false, true);
        BodiesHelper.registerBody((CelestialBody)europaJupiter, data, GSConfigDimensions.enableEuropa);
        data = new BodiesHelper.BodiesData(null, 0.057f, 0, -2.0f, 0.0f, 102000L, false, false);
        BodiesHelper.registerBody((CelestialBody)ganymedeJupiter, data, GSConfigDimensions.enableGanymede);
        data = new BodiesHelper.BodiesData(null, 0.054f, 0, -3.0f, 0.0f, 154000L, false, true);
        BodiesHelper.registerBody((CelestialBody)callistoJupiter, data, GSConfigDimensions.enableCallisto);
        data = new BodiesHelper.BodiesData(null, 0.058f, 0, -3.0f, 0.0f, 32000L, false, true);
        BodiesHelper.registerBody((CelestialBody)enceladusSaturn, data, GSConfigDimensions.enableEnceladus);
        data = new BodiesHelper.BodiesData(null, 0.058f, 5, -3.0f, 0.0f, 105500L, false, false);
        BodiesHelper.registerBody((CelestialBody)titanSaturn, data, GSConfigDimensions.enableTitan);
        data = new BodiesHelper.BodiesData(null, 0.057f, 0, -4.0f, 0.0f, 33500L, false, true);
        BodiesHelper.registerBody((CelestialBody)mirandaUranus, data, GSConfigDimensions.enableMiranda);
        data = new BodiesHelper.BodiesData(null, 0.052f, 0, -4.0f, 0.0f, 28500L, false, false);
        BodiesHelper.registerBody((CelestialBody)tritonNeptune, data, GSConfigDimensions.enableTriton);
        BodiesHelper.BodiesData unreachableData = new BodiesHelper.BodiesData(null, 0.0f, 0, 0.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBody((CelestialBody)oberonUranus, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)proteusNeptune, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)mimasSaturn, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)tethysSaturn, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)dioneSaturn, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)rheyaSaturn, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)iapetusSaturn, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)arielUranus, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)umbrielUranus, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)titaniaUranus, unreachableData, GSConfigCore.enableUnreachable);
        BodiesHelper.registerBody((CelestialBody)charonPluto, unreachableData, GSConfigCore.enableUnreachable);
        if (GSConfigDimensions.enableMarsSS) {
            GalaxyRegistry.registerSatellite((Satellite)marsSpaceStation);
        }
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderMercury.class, (ITeleportType)new TeleportTypeMercury());
        GalacticraftRegistry.registerTeleportType(WorldProviderVenus.class, (ITeleportType)new TeleportTypeVenus());
        GalacticraftRegistry.registerTeleportType(WorldProviderCeres.class, (ITeleportType)new TeleportTypeCeres());
        GalacticraftRegistry.registerTeleportType(WorldProviderPluto.class, (ITeleportType)new WorldProviderPluto());
        GalacticraftRegistry.registerTeleportType(WorldProviderKuiper.class, (ITeleportType)new WorldProviderKuiper());
        GalacticraftRegistry.registerTeleportType(WorldProviderIo.class, (ITeleportType)new WorldProviderIo());
        GalacticraftRegistry.registerTeleportType(WorldProviderEuropa.class, (ITeleportType)new WorldProviderEuropa());
        GalacticraftRegistry.registerTeleportType(WorldProviderGanymede.class, (ITeleportType)new WorldProviderGanymede());
        GalacticraftRegistry.registerTeleportType(WorldProviderCallisto.class, (ITeleportType)new WorldProviderCallisto());
        GalacticraftRegistry.registerTeleportType(WorldProviderEnceladus.class, (ITeleportType)new WorldProviderEnceladus());
        GalacticraftRegistry.registerTeleportType(GSConfigCore.enableWorldEngine ? WorldProviderTitan_WE.class : WorldProviderTitan.class, (ITeleportType)new WorldProviderTitan_WE());
        GalacticraftRegistry.registerTeleportType(WorldProviderMiranda.class, (ITeleportType)new WorldProviderMiranda());
        GalacticraftRegistry.registerTeleportType(WorldProviderTriton.class, (ITeleportType)new WorldProviderTriton());
        if (GSConfigDimensions.enableMarsSS) {
            GalacticraftRegistry.registerTeleportType(WorldProviderMarsSS.class, (ITeleportType)new TeleportTypeSS());
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbit, WorldProviderMarsSS.class, (boolean)false, (int)-1040);
            GalacticraftRegistry.registerProvider((int)GSConfigDimensions.dimensionIDMarsOrbitStatic, WorldProviderMarsSS.class, (boolean)true, (int)-1041);
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (GSConfigDimensions.enableMarsSS) {
            CraftingRecipeMarsSS.loadRecipes();
        }
        CraftingRecipesMercury.loadRecipes();
        CraftingRecipesVenus.loadRecipes();
        CraftingRecipesOverworld.loadRecipes();
        CraftingRecipesMars.loadRecipes();
        CraftingRecipesCeres.loadRecipes();
        CraftingRecipesPluto.loadRecipes();
        CraftingRecipesIo.loadRecipes();
        CraftingRecipesEuropa.loadRecipes();
        CraftingRecipesGanymede.loadRecipes();
        CraftingRecipesEnceladus.loadRecipes();
        CraftingRecipesMiranda.loadRecipes();
        CraftingRecipesTriton.loadRecipes();
    }

    static {
        planetJupiter = GalacticraftCore.planetJupiter;
        planetSaturn = GalacticraftCore.planetSaturn;
        planetUranus = GalacticraftCore.planetUranus;
        planetNeptune = GalacticraftCore.planetNeptune;
    }
}

