/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.systems.BarnardsSystem.BarnardsSystemBodies;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension.ChunkProviderBarnardaC;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension.WorldChunkManagerBarnardaC;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension.sky.SkyProviderBarnardaC;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.ISolarLevel;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.util.MathHelper;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.client.IRenderHandler;

public class WorldProviderBarnardaC
extends WorldProviderAdvancedSpace
implements ISolarLevel,
IAdvancedSpace {
    @Override
    public double getSolarEnergyMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }

    @Override
    public boolean canSpaceshipTierPass(int tier) {
        return tier >= this.getCelestialBody().getTierRequirement();
    }

    public double getHorizon() {
        return 4.0;
    }

    public float getFallDamageModifier() {
        return 0.9f;
    }

    public double getFuelUsageMultiplier() {
        return 1.0;
    }

    public double getMeteorFrequency() {
        return 0.0;
    }

    public float getSoundVolReductionAmount() {
        return Float.MAX_VALUE;
    }

    public boolean canRainOrSnow() {
        return true;
    }

    public boolean canBlockFreeze(int x, int y, int z, boolean byWater) {
        return false;
    }

    public CelestialBody getCelestialBody() {
        return BarnardsSystemBodies.barnardaC;
    }

    public Class<? extends IChunkProvider> getChunkProviderClass() {
        return ChunkProviderBarnardaC.class;
    }

    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.98039216f * f), (double)(0.654902f * f), (double)(0.41960785f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.23921569f * f), (double)(0.3372549f * f), (double)(0.6862745f * f));
    }

    public boolean func_76561_g() {
        return true;
    }

    public Class<? extends WorldChunkManager> getWorldChunkManagerClass() {
        return WorldChunkManagerBarnardaC.class;
    }

    public boolean hasSunset() {
        return false;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float par1) {
        float var2 = this.field_76579_a.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76134_b((float)(var2 * (float)Math.PI * 2.0f)) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 0.5f + 0.3f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getSunBrightness(float par1) {
        float f1 = this.field_76579_a.func_72826_c(1.0f);
        float f2 = 1.25f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        f2 = 1.2f - f2;
        return f2 * 0.6f;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        if (super.getCloudRenderer() == null) {
            this.setCloudRenderer((IRenderHandler)new CloudRenderer());
        }
        return super.getCloudRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        if (super.getSkyRenderer() == null) {
            this.setSkyRenderer(new SkyProviderBarnardaC());
        }
        return super.getSkyRenderer();
    }

    @Override
    public double getSolarWindMultiplier() {
        double solarMultiplier = -1.0;
        if (solarMultiplier < 0.0) {
            double s = this.getSolarSize();
            solarMultiplier = s * s * s * ConfigManagerCore.spaceStationEnergyScalar;
        }
        return solarMultiplier;
    }
}

