/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.BarnardsSystem;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import galaxyspace.GalaxySpace;
import galaxyspace.api.BodiesHelper;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.systems.BarnardsSystem.core.configs.BRConfigDimensions;
import galaxyspace.systems.BarnardsSystem.core.registers.blocks.BRBlocks;
import galaxyspace.systems.BarnardsSystem.core.registers.blocks.BRItems;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension.TeleportTypeBarnardaC;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.dimension.WorldProviderBarnardaC_WE;
import galaxyspace.systems.BarnardsSystem.planets.barnardaC.recipes.CraftingRecipesBarnardaC;
import galaxyspace.systems.BarnardsSystem.planets.barnardaE.dimension.TeleportTypeBarnardaE;
import galaxyspace.systems.BarnardsSystem.planets.barnardaE.dimension.WorldProviderBarnardaE_WE;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;

public class BarnardsSystemBodies
implements IBodiesHandler {
    public static SolarSystem BarnardsSystem;
    public static Planet barnardaB;
    public static Planet barnardaC;
    public static Planet barnardaE;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new BRConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/barnards/dimensions.conf"));
        BRBlocks.initialize();
        BRItems.initialize();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        BarnardsSystem = BodiesHelper.registerSolarSystem(GalaxySpace.ASSET_PREFIX, "barnards", BodiesHelper.Galaxies.MILKYWAY, new Vector3(1.0, -2.0, 0.0), "barnarda_a", 1.0f);
        barnardaB = BodiesHelper.registerPlanet(BarnardsSystem, "barnarda_b", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 1.0f, 0.5f, 2.5f);
        barnardaC = (Planet)BodiesHelper.registerPlanet(BarnardsSystem, "barnarda_c", GalaxySpace.ASSET_PREFIX, WorldProviderBarnardaC_WE.class, BRConfigDimensions.dimensionIDBarnardaC, 6, 1.5707964f, 1.0f, 0.75f, 6.5f).setRingColorRGB(0.0f, 1.1f, 0.0f).atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.OXYGEN).atmosphereComponent(IAtmosphericGas.ARGON);
        barnardaE = BodiesHelper.registerPlanet(BarnardsSystem, "barnarda_e", GalaxySpace.ASSET_PREFIX, WorldProviderBarnardaE_WE.class, BRConfigDimensions.dimensionIDBarnardaC - 1, 6, 0.7853982f, 1.0f, 2.3f, 12.5f);
        BarnardsSystemBodies.registrycelestial();
        BarnardsSystemBodies.registryteleport();
    }

    private static void registrycelestial() {
        GalaxyRegistry.registerSolarSystem((SolarSystem)BarnardsSystem);
        BodiesHelper.BodiesData star = new BodiesHelper.BodiesData(BodiesHelper.orange + " " + BodiesHelper.dwarf, 28.088f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)BarnardsSystem.getMainStar(), star);
        BodiesHelper.BodiesData unreachableData = new BodiesHelper.BodiesData(null, 0.0f, 0, 0.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBody((CelestialBody)barnardaB, unreachableData, true);
        BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(8.5f), 1, 0.0f, 1.0f, 36000L, true, false);
        BodiesHelper.registerBody((CelestialBody)barnardaC, data, true);
        data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(4.5f), 6, -2.0f, 0.4f, 68000L, false, false);
        BodiesHelper.registerBody((CelestialBody)barnardaE, data, true);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderBarnardaC_WE.class, (ITeleportType)new TeleportTypeBarnardaC());
        GalacticraftRegistry.registerTeleportType(WorldProviderBarnardaE_WE.class, (ITeleportType)new TeleportTypeBarnardaE());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        CraftingRecipesBarnardaC.loadRecipes();
    }
}

