/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.systems.ACentauriSystem;

import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import galaxyspace.GalaxySpace;
import galaxyspace.api.BodiesHelper;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigCore;
import galaxyspace.systems.ACentauriSystem.core.configs.ACConfigDimensions;
import galaxyspace.systems.ACentauriSystem.core.registers.blocks.ACBlocks;
import galaxyspace.systems.ACentauriSystem.planets.proximaB.dimension.TeleportTypeProximaB;
import galaxyspace.systems.ACentauriSystem.planets.proximaB.dimension.WorldProviderProximaB;
import galaxyspace.systems.ACentauriSystem.planets.proximaB.recipes.CraftingRecipesProximaB;
import java.io.File;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import net.minecraft.item.ItemStack;

public class ACentauriSystemBodies
implements IBodiesHandler {
    public static SolarSystem aCentauriSystem;
    public static SolarSystem ProximaSystem;
    public static Star aCentauri;
    public static Planet centauriB;
    public static Star proxima;
    public static Planet proximaB;

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        new ACConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/core.conf"));
        new ACConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/alpha_centauri/dimensions.conf"));
        if (ACConfigCore.enableAlphaCentauriSystem) {
            ACBlocks.initialize();
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        aCentauriSystem = BodiesHelper.registerSolarSystem(GalaxySpace.ASSET_PREFIX, "acentauri", BodiesHelper.Galaxies.MILKYWAY, new Vector3(1.5, 0.0, 0.0), "centauri_a", 1.3f);
        ProximaSystem = BodiesHelper.registerSolarSystem(GalaxySpace.ASSET_PREFIX, "proxima", BodiesHelper.Galaxies.MILKYWAY, new Vector3((double)1.7f, (double)-0.2f, 0.0), "proxima", 0.8f);
        centauriB = (Planet)BodiesHelper.registerPlanet(aCentauriSystem, "centauri_b", GalaxySpace.ASSET_PREFIX, null, -1, -1, (float)Math.PI, 1.5f, 0.3f, 1000.0f).setRingColorRGB(0.0f, 0.0f, 0.0f);
        proximaB = (Planet)BodiesHelper.registerPlanet(ProximaSystem, "proxima_b", GalaxySpace.ASSET_PREFIX, WorldProviderProximaB.class, ACConfigDimensions.dimensionIDProximaB, 6, (float)Math.PI * 3, 1.2f, 0.25f, 1.1f).setRingColorRGB(0.0f, 0.4f, 0.9f);
        proximaB.atmosphereComponent(IAtmosphericGas.OXYGEN).atmosphereComponent(IAtmosphericGas.CO2).atmosphereComponent(IAtmosphericGas.ARGON).atmosphereComponent(IAtmosphericGas.WATER);
        if (ACConfigCore.enableAlphaCentauriSystem) {
            ACentauriSystemBodies.registrycelestial();
            ACentauriSystemBodies.registryteleport();
        }
    }

    private static void registrycelestial() {
        GalaxyRegistry.registerSolarSystem((SolarSystem)aCentauriSystem);
        GalaxyRegistry.registerSolarSystem((SolarSystem)ProximaSystem);
        BodiesHelper.BodiesData unreachableData = new BodiesHelper.BodiesData(null, 0.0f, 0, 0.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBody((CelestialBody)centauriB, unreachableData, true);
        BodiesHelper.BodiesData data = new BodiesHelper.BodiesData(null, BodiesHelper.calculateGravity(9.4f), 1, 0.1f, 1.0f, 35050L, false, true);
        data.addItemStack(new ItemStack(GSItems.SpacesuitHelmet, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitPlate, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitLeg, 1, Short.MAX_VALUE));
        data.addItemStack(new ItemStack(GSItems.SpacesuitBoots, 1, Short.MAX_VALUE));
        BodiesHelper.registerBody((CelestialBody)proximaB, data, ACConfigDimensions.enableProximaB);
        data = new BodiesHelper.BodiesData(BodiesHelper.yellow + " " + BodiesHelper.dwarf, 20.336f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)aCentauriSystem.getMainStar(), data);
        data = new BodiesHelper.BodiesData(BodiesHelper.orange + " " + BodiesHelper.dwarf, 18.124f, 0, 999.0f, 0.0f, 0L, false, false);
        BodiesHelper.registerBodyWithClass((CelestialBody)ProximaSystem.getMainStar(), data);
    }

    private static void registryteleport() {
        GalacticraftRegistry.registerTeleportType(WorldProviderProximaB.class, (ITeleportType)new TeleportTypeProximaB());
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        CraftingRecipesProximaB.loadRecipes();
    }
}

