/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world.worldengine;

public class WE_PerlinNoise {
    public static double NumberNoise2D(long seed, long x, long y) {
        long n = x + y * 31L + seed * 6L;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (15732L * n ^ 0xC0B4FL) + 1376312589L & Integer.MAX_VALUE) / 1.073741824E9;
    }

    public static double SmoothNoise2D(long seed, long x, long y) {
        double corners = (WE_PerlinNoise.NumberNoise2D(seed, x - 1L, y - 1L) + WE_PerlinNoise.NumberNoise2D(seed, x + 1L, y - 1L) + WE_PerlinNoise.NumberNoise2D(seed, x - 1L, y + 1L) + WE_PerlinNoise.NumberNoise2D(seed, x + 1L, y + 1L)) / 16.0;
        double sides = (WE_PerlinNoise.NumberNoise2D(seed, x - 1L, y) + WE_PerlinNoise.NumberNoise2D(seed, x + 1L, y) + WE_PerlinNoise.NumberNoise2D(seed, x, y - 1L) + WE_PerlinNoise.NumberNoise2D(seed, x, y + 1L)) / 8.0;
        double center = WE_PerlinNoise.NumberNoise2D(seed, x, y) / 4.0;
        return corners + sides + center;
    }

    public static double CosineInterpolate(double a, double b, double x) {
        double f = (1.0 - Math.cos(x * Math.PI)) * 0.5;
        return a * (1.0 - f) + b * f;
    }

    public static double CosineInterpolatedNoise2D(long seed, double x, double y) {
        long lx = (long)x;
        long ly = (long)y;
        double fx = Math.abs(x) - (double)Math.abs(lx);
        double fy = Math.abs(y) - (double)Math.abs(ly);
        double v1 = WE_PerlinNoise.SmoothNoise2D(seed, lx, ly);
        double v2 = WE_PerlinNoise.SmoothNoise2D(seed, Math.abs(x) == x ? lx + 1L : lx - 1L, ly);
        double v3 = WE_PerlinNoise.SmoothNoise2D(seed, lx, Math.abs(y) == y ? ly + 1L : ly - 1L);
        double v4 = WE_PerlinNoise.SmoothNoise2D(seed, Math.abs(x) == x ? lx + 1L : lx - 1L, Math.abs(y) == y ? ly + 1L : ly - 1L);
        double i1 = WE_PerlinNoise.CosineInterpolate(v1, v2, fx);
        double i2 = WE_PerlinNoise.CosineInterpolate(v3, v4, fx);
        return WE_PerlinNoise.CosineInterpolate(i1, i2, fy);
    }

    public static double PerlinNoise2D(long seed, double x, double y, double persistence, int number_of_octaves) {
        double total = 0.0;
        for (int i = 0; i <= number_of_octaves; ++i) {
            double frequency = 1 << i;
            double amplitude = Math.pow(persistence, i);
            total += WE_PerlinNoise.CosineInterpolatedNoise2D(seed, x * frequency, y * frequency) * amplitude;
        }
        return total;
    }
}

