/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world.worldengine;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import galaxyspace.core.world.worldengine.WE_Biome;
import galaxyspace.core.world.worldengine.WE_WorldProvider;
import galaxyspace.core.world.worldengine.additions.WE_ChunkSmartLight;
import galaxyspace.core.world.worldengine.additions.WE_CreateChunkGen;
import galaxyspace.core.world.worldengine.additions.WE_CreateChunkGen_InXYZ;
import galaxyspace.core.world.worldengine.additions.WE_CreateChunkGen_InXZ;
import galaxyspace.core.world.worldengine.additions.WE_GeneratorData;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_CaveGen;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_LakeGen;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_OreGen;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_RavineGen;
import galaxyspace.core.world.worldengine.standardcustomgen.WE_TerrainGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class WE_ChunkProvider
extends ChunkProviderGenerate {
    public World field_73230_p;
    public Random field_73220_k;
    public List<WE_CreateChunkGen> createChunkGen_List = new ArrayList<WE_CreateChunkGen>();
    public List<WE_CreateChunkGen_InXZ> createChunkGen_InXZ_List = new ArrayList<WE_CreateChunkGen_InXZ>();
    public List<WE_CreateChunkGen_InXYZ> createChunkGen_InXYZ_List = new ArrayList<WE_CreateChunkGen_InXYZ>();
    public List<IWorldGenerator> decorateChunkGen_List = new ArrayList<IWorldGenerator>();
    public List<MapGenBaseMeta> worldGenerators = new ArrayList<MapGenBaseMeta>();
    private BiomeDecoratorSpace decorator;
    public List<WE_Biome> biomesList = new ArrayList<WE_Biome>();
    public WE_Biome standardBiomeOnMap;
    public double biomemapPersistence = 1.0;
    public double biomemapScaleX = 1.0;
    public double biomemapScaleY = 1.0;
    public int biomemapNumberOfOctaves = 1;
    public WE_Biome currentbiome;

    public WE_ChunkProvider(WE_WorldProvider wp) {
        super(wp.field_76579_a, wp.getSeed(), wp.field_76579_a.func_72912_H().func_76089_r());
        this.field_73230_p = wp.field_76579_a;
        this.field_73220_k = new Random(wp.getSeed());
        this.createChunkGen_List.add(new WE_TerrainGenerator());
        this.createChunkGen_List.add(new WE_CaveGen());
        this.createChunkGen_List.add(new WE_RavineGen());
        WE_OreGen standardOres = new WE_OreGen();
        standardOres.add(Blocks.field_150352_o, (byte)0, Blocks.field_150348_b, 4, 0, 32, 4, 24, 45, 16);
        standardOres.add(Blocks.field_150366_p, (byte)0, Blocks.field_150348_b, 6, 0, 64, 8, 32, 90, 72);
        standardOres.add(Blocks.field_150365_q, (byte)0, Blocks.field_150348_b, 6, 32, 128, 16, 48, 60, 56);
        standardOres.add(Blocks.field_150369_x, (byte)0, Blocks.field_150348_b, 4, 0, 16, 8, 24, 30, 16);
        standardOres.add(Blocks.field_150482_ag, (byte)0, Blocks.field_150348_b, 3, 0, 16, 4, 24, 45, 16);
        standardOres.add(Blocks.field_150412_bA, (byte)0, Blocks.field_150348_b, 2, 0, 16, 4, 24, 45, 24);
        this.decorateChunkGen_List.add(standardOres);
        WE_LakeGen lavaLakes = new WE_LakeGen();
        lavaLakes.lakeBlock = Blocks.field_150353_l;
        lavaLakes.fGen = false;
        lavaLakes.maxY = 32;
        this.decorateChunkGen_List.add(lavaLakes);
        System.out.println("WorldEngine: -Applying your WorldEngine settings...");
        wp.genSettings(this);
        this.decorator = wp.getDecorator();
        WE_Biome.setChunkProvider(this);
        System.out.println("WorldEngine: -WorldEngine is configured successfully!");
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        int z;
        int x;
        long chunk_X = (long)chunkX * 16L;
        long chunk_Z = (long)chunkZ * 16L;
        WE_Biome.setChunkProvider(this);
        Block[] chunkBlocks = new Block[65536];
        byte[] chunkBlocksMeta = new byte[65536];
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C() * (long)chunkX ^ (long)(3 + chunkZ) ^ 0x758CF9L);
        WE_Biome[][] chunkBiomes = new WE_Biome[16][16];
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                chunkBiomes[x][z] = WE_Biome.getBiomeAt(this, chunk_X + (long)x, chunk_Z + (long)z);
                this.currentbiome = chunkBiomes[x][z];
            }
        }
        for (int i = 0; i < this.createChunkGen_List.size(); ++i) {
            this.createChunkGen_List.get(i).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, 0, 0, 0));
        }
        for (x = 0; x < 16; ++x) {
            for (z = 0; z < 16; ++z) {
                int i;
                for (i = 0; i < this.createChunkGen_InXZ_List.size(); ++i) {
                    this.createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                }
                for (i = 0; i < chunkBiomes[x][z].createChunkGen_InXZ_List.size(); ++i) {
                    chunkBiomes[x][z].createChunkGen_InXZ_List.get(i).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, 0, z));
                }
                for (int y = 255; y >= 0; --y) {
                    int i2;
                    for (i2 = 0; i2 < this.createChunkGen_InXYZ_List.size(); ++i2) {
                        this.createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                    }
                    for (i2 = 0; i2 < chunkBiomes[x][z].createChunkGen_InXYZ_List.size(); ++i2) {
                        chunkBiomes[x][z].createChunkGen_InXYZ_List.get(i2).gen(new WE_GeneratorData(this, chunkBlocks, chunkBlocksMeta, chunk_X, chunk_Z, chunkBiomes, x, y, z));
                    }
                }
            }
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, chunkX, chunkZ, chunkBlocks, chunkBlocksMeta);
        }
        WE_ChunkSmartLight chunk = new WE_ChunkSmartLight(this.field_73230_p, chunkBlocks, chunkBlocksMeta, chunkX, chunkZ);
        chunk.func_76603_b();
        return chunk;
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        BlockFalling.field_149832_M = true;
        boolean flag = false;
        this.field_73220_k.setSeed(this.field_73230_p.func_72905_C() * (long)chunkX + (long)chunkZ ^ 0x248B36L);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.field_73230_p, this.field_73220_k, chunkX, chunkZ, flag));
        long var7 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        long var9 = this.field_73220_k.nextLong() / 2L * 2L + 1L;
        this.field_73220_k.setSeed((long)chunkX * var7 + (long)chunkZ * var9 ^ this.field_73230_p.func_72905_C());
        for (int i = 0; i < this.decorateChunkGen_List.size(); ++i) {
            this.decorateChunkGen_List.get(i).generate(this.field_73220_k, chunkX, chunkZ, this.field_73230_p, (IChunkProvider)this, (IChunkProvider)this);
        }
        WE_Biome b = WE_Biome.getBiomeAt(this, (long)chunkX * 16L + (long)this.field_73220_k.nextInt(16), (long)chunkZ * 16L + (long)this.field_73220_k.nextInt(16));
        for (int i = 0; i < b.decorateChunkGen_List.size(); ++i) {
            b.decorateChunkGen_List.get(i).generate(this.field_73220_k, chunkX, chunkZ, this.field_73230_p, (IChunkProvider)this, (IChunkProvider)this);
        }
        this.decorateWorld(this.field_73230_p, this.field_73220_k, chunkX * 16, chunkZ * 16);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.field_73230_p, this.field_73220_k, chunkX, chunkZ, flag));
        BlockFalling.field_149832_M = false;
    }

    public void decorateWorld(World world, Random rand, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand, x, z);
    }

    protected BiomeDecoratorSpace getBiomeGenerator() {
        return this.decorator;
    }

    public void genSetBlock(Block[] chunkBlocks, byte[] chunkBlocksMeta, int x, int y, int z, Block block, byte meta) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            chunkBlocks[(x * 16 + z) * 256 + y] = block;
            chunkBlocksMeta[(x * 16 + z) * 256 + y] = meta;
        }
    }

    public Block genReturnBlock(Block[] chunkBlocks, int x, int y, int z) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            return chunkBlocks[(x * 16 + z) * 256 + y];
        }
        return null;
    }

    public byte genReturnBlockMeta(byte[] chunkBlocksMeta, int x, int y, int z) {
        if (x >= 0 && x <= 15 && y >= 0 && y <= 255 && z >= 0 && z <= 15) {
            return chunkBlocksMeta[(x * 16 + z) * 256 + y];
        }
        return 0;
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        WE_Biome biome = WE_Biome.getBiomeAt(this, i, k);
        if (biome != null && biome != null) {
            return biome.func_76747_a(par1EnumCreatureType);
        }
        return null;
    }
}

