/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world.gen;

import galaxyspace.core.world.gen.GSBiomeGenBase;
import galaxyspace.core.world.gen.GS_GenBlocks;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.perlin.generator.Gradient;
import micdoodle8.mods.galacticraft.core.world.gen.EnumCraterSize;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public abstract class ChunkProviderSpaceLakes
implements IChunkProvider {
    protected static final int CHUNK_SIZE_X = 16;
    private static final int CHUNK_SIZE_Y = 256;
    protected static final int CHUNK_SIZE_Z = 16;
    private final double TERRAIN_HEIGHT_MOD = this.getHeightModifier();
    private final double SMALL_FEATURE_HEIGHT_MOD = this.getSmallFeatureHeightModifier();
    private final double MOUNTAIN_HEIGHT_MOD = this.getMountainHeightModifier();
    private final double VALLEY_HEIGHT_MOD = this.getValleyHeightModifier();
    private final int CRATER_PROB = this.getCraterProbability();
    private final int MID_HEIGHT = this.getTerrainLevel();
    private static final double MAIN_FEATURE_FILTER_MOD = 4.0;
    private static final double LARGE_FEATURE_FILTER_MOD = 8.0;
    private static final double SMALL_FEATURE_FILTER_MOD = 8.0;
    protected Random rand;
    private BiomeCache myBiomeCache;
    private NoiseGeneratorOctaves noiseGen4;
    public NoiseGeneratorOctaves noiseGen5;
    public NoiseGeneratorOctaves noiseGen6;
    public NoiseGeneratorOctaves mobSpawnerNoise;
    protected World worldObj;
    private double[] stoneNoise;
    private BiomeGenBase[] biomesForGeneration = this.getBiomesForGeneration();
    double[] noise3;
    double[] noise1;
    double[] noise2;
    double[] noise5;
    double[] noise6;
    float[] squareTable;
    private NoiseGeneratorOctaves field_147431_j;
    private NoiseGeneratorOctaves field_147432_k;
    private NoiseGeneratorOctaves field_147429_l;
    private NoiseGeneratorPerlin field_147430_m;
    private double[] terrainCalcs;
    private float[] parabolicField;
    double[] field_147427_d;
    double[] field_147428_e;
    double[] field_147425_f;
    double[] field_147426_g;
    int[][] field_73219_j = new int[32][32];
    private final Gradient noiseGen8;
    private final Gradient gcnoiseGen1;
    private final Gradient gcnoiseGen2;
    private final Gradient gcnoiseGen3;
    private final Gradient gcnoiseGen4;
    private final Gradient gcnoiseGen5;
    private final Gradient gcnoiseGen6;
    private final Gradient gcnoiseGen7;
    public static List<GS_GenBlocks> genBlocks = new ArrayList<GS_GenBlocks>();
    private List<MapGenBaseMeta> worldGenerators;

    public ChunkProviderSpaceLakes(World world, long seed, boolean flag) {
        this.stoneNoise = new double[256];
        this.worldObj = world;
        this.rand = new Random(seed);
        this.noiseGen4 = new NoiseGeneratorOctaves(this.rand, 4);
        this.noiseGen5 = new NoiseGeneratorOctaves(this.rand, 10);
        this.noiseGen6 = new NoiseGeneratorOctaves(this.rand, 16);
        this.noiseGen8 = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.mobSpawnerNoise = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147431_j = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147432_k = new NoiseGeneratorOctaves(this.rand, 16);
        this.field_147429_l = new NoiseGeneratorOctaves(this.rand, 8);
        this.field_147430_m = new NoiseGeneratorPerlin(this.rand, 4);
        this.terrainCalcs = new double[825];
        this.parabolicField = new float[25];
        for (int j = -2; j <= 2; ++j) {
            for (int k = -2; k <= 2; ++k) {
                float f;
                this.parabolicField[j + 2 + (k + 2) * 5] = f = 10.0f / MathHelper.func_76129_c((float)((float)(j * j + k * k) + 0.2f));
            }
        }
        this.gcnoiseGen1 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen2 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen3 = new Gradient(this.rand.nextLong(), 4, 0.25f);
        this.gcnoiseGen4 = new Gradient(this.rand.nextLong(), 2, 0.25f);
        this.gcnoiseGen5 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.gcnoiseGen6 = new Gradient(this.rand.nextLong(), 1, 0.25f);
        this.gcnoiseGen7 = new Gradient(this.rand.nextLong(), 1, 0.25f);
    }

    public Chunk func_73154_d(int x, int z) {
        this.rand.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        Block[] blockStorage = new Block[65536];
        byte[] metaStorage = new byte[65536];
        this.generateTerrain(x, z, blockStorage, metaStorage);
        if (this.getCraterProbability() > 0) {
            this.createCraters(x, z, blockStorage, metaStorage);
        }
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, x * 16, z * 16, 16, 16);
        this.replaceBlocksForBiome(x, z, blockStorage, metaStorage, this.biomesForGeneration);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.worldObj, x, z, blockStorage, metaStorage);
        }
        this.onChunkProvider(x, z, blockStorage, metaStorage);
        Chunk chunk = new Chunk(this.worldObj, blockStorage, metaStorage, x, z);
        byte[] chunkBiomes = chunk.func_76605_m();
        for (int i = 0; i < chunkBiomes.length; ++i) {
            chunkBiomes[i] = (byte)this.biomesForGeneration[i].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void generateTerrain(int chunkX, int chunkZ, Block[] blockStorage, byte[] metaStorage) {
        int seaLevel = this.getWaterLevel();
        metaStorage = new byte[65536];
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, chunkX * 4 - 2, chunkZ * 4 - 2, 10, 10);
        if (this.getGenType() != GenType.GC) {
            this.makeLandPerBiome2(chunkX * 4, 0, chunkZ * 4);
            for (int k = 0; k < 4; ++k) {
                int l = k * 5;
                int i1 = (k + 1) * 5;
                for (int j1 = 0; j1 < 4; ++j1) {
                    int k1 = (l + j1) * 33;
                    int l1 = (l + j1 + 1) * 33;
                    int i2 = (i1 + j1) * 33;
                    int j2 = (i1 + j1 + 1) * 33;
                    for (int k2 = 0; k2 < 32; ++k2) {
                        double d0 = 0.125;
                        double d1 = this.terrainCalcs[k1 + k2];
                        double d2 = this.terrainCalcs[l1 + k2];
                        double d3 = this.terrainCalcs[i2 + k2];
                        double d4 = this.terrainCalcs[j2 + k2];
                        double d5 = (this.terrainCalcs[k1 + k2 + 1] - d1) * d0;
                        double d6 = (this.terrainCalcs[l1 + k2 + 1] - d2) * d0;
                        double d7 = (this.terrainCalcs[i2 + k2 + 1] - d3) * d0;
                        double d8 = (this.terrainCalcs[j2 + k2 + 1] - d4) * d0;
                        for (int l2 = 0; l2 < 8; ++l2) {
                            double d9 = 0.25;
                            double d10 = d1;
                            double d11 = d2;
                            double d12 = (d3 - d1) * d9;
                            double d13 = (d4 - d2) * d9;
                            for (int i3 = 0; i3 < 4; ++i3) {
                                int j3 = i3 + k * 4 << 12 | 0 + j1 * 4 << 8 | k2 * 8 + l2;
                                int short1 = 256;
                                j3 -= short1;
                                double d14 = 0.25;
                                double d16 = (d11 - d10) * d14;
                                double d15 = d10 - d16;
                                for (int k3 = 0; k3 < 4; ++k3) {
                                    double d;
                                    d15 += d16;
                                    blockStorage[j3 += short1] = d > 0.0 ? this.getStoneBlock().getBlock() : (k2 * 8 + l2 < seaLevel && this.canGenerateWaterBlock() ? this.getWaterBlock().getBlock() : null);
                                }
                                d10 += d12;
                                d11 += d13;
                            }
                            d1 += d5;
                            d2 += d6;
                            d3 += d7;
                            d4 += d8;
                        }
                    }
                }
            }
        } else {
            this.makeGCland(chunkX, chunkZ, blockStorage, metaStorage);
        }
    }

    public void makeGCland(int chunkX, int chunkZ, Block[] idArray, byte[] metaArray) {
        this.gcnoiseGen1.setFrequency(0.015f);
        this.gcnoiseGen2.setFrequency(0.01f);
        this.gcnoiseGen3.setFrequency(0.01f);
        this.gcnoiseGen4.setFrequency(0.01f);
        this.gcnoiseGen5.setFrequency(0.01f);
        this.gcnoiseGen6.setFrequency(0.001f);
        this.gcnoiseGen7.setFrequency(0.005f);
        int x = 0;
        while (true) {
            if (x >= 16) break;
            int z = 0;
            while (true) {
                if (z >= 16) break;
                double baseHeight = (double)this.gcnoiseGen1.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.TERRAIN_HEIGHT_MOD;
                double smallHillHeight = (double)this.gcnoiseGen2.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * this.SMALL_FEATURE_HEIGHT_MOD;
                double mountainHeight = Math.abs(this.gcnoiseGen3.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double valleyHeight = Math.abs(this.gcnoiseGen4.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)));
                double featureFilter = (double)this.gcnoiseGen5.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 4.0;
                double largeFilter = (double)this.gcnoiseGen6.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0;
                double smallFilter = (double)this.gcnoiseGen7.getNoise((float)(chunkX * 16 + x), (float)(chunkZ * 16 + z)) * 8.0 - 0.5;
                mountainHeight = this.lerp(smallHillHeight, mountainHeight * this.MOUNTAIN_HEIGHT_MOD, this.fade(this.clamp(mountainHeight * 2.0, 0.0, 1.0)));
                valleyHeight = this.lerp(smallHillHeight, valleyHeight * this.VALLEY_HEIGHT_MOD - this.VALLEY_HEIGHT_MOD + 9.0, this.fade(this.clamp((valleyHeight + 2.0) * 4.0, 0.0, 1.0)));
                double yDev = this.lerp(valleyHeight, mountainHeight, this.fade(largeFilter));
                yDev = this.lerp(smallHillHeight, yDev, smallFilter);
                yDev = this.lerp(baseHeight, yDev, featureFilter);
                BiomeGenBase biomes = this.worldObj.func_72807_a(x + chunkX * 16, z + chunkZ * 16);
                int y = 0;
                while (true) {
                    if (y >= 256) break;
                    if ((double)y < (double)this.MID_HEIGHT + yDev) {
                        if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                            int index = -1;
                            for (GS_GenBlocks genBlock : genBlocks) {
                                ++index;
                                if (this.worldObj.field_73011_w != genBlock.getWorldProvider() || biomes != genBlock.getBiome()) continue;
                                break;
                            }
                            idArray[this.getIndex((int)x, (int)y, (int)z)] = genBlocks.get(index).getStoneBlock().getBlock();
                            metaArray[this.getIndex((int)x, (int)y, (int)z)] = genBlocks.get(index).getStoneBlock().getMetadata();
                        } else {
                            idArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getBlock();
                            metaArray[this.getIndex((int)x, (int)y, (int)z)] = this.getStoneBlock().getMetadata();
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
    }

    private void makeLandPerBiome2(int x, int zero, int z) {
        this.field_147426_g = this.noiseGen6.func_76305_a(this.field_147426_g, x, z, 5, 5, 200.0, 200.0, 0.5);
        this.field_147427_d = this.field_147429_l.func_76304_a(this.field_147427_d, x, zero, z, 5, 33, 5, 8.555150000000001, 4.277575000000001, 8.555150000000001);
        this.field_147428_e = this.field_147431_j.func_76304_a(this.field_147428_e, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        this.field_147425_f = this.field_147432_k.func_76304_a(this.field_147425_f, x, zero, z, 5, 33, 5, 684.412, 684.412, 684.412);
        int terrainIndex = 0;
        int noiseIndex = 0;
        for (int ax = 0; ax < 5; ++ax) {
            for (int az = 0; az < 5; ++az) {
                float totalVariation = 0.0f;
                float totalHeight = 0.0f;
                float totalFactor = 0.0f;
                int two = 2;
                BiomeGenBase biomegenbase = this.biomesForGeneration[ax + 2 + (az + 2) * 10];
                for (int ox = -two; ox <= two; ++ox) {
                    for (int oz = -two; oz <= two; ++oz) {
                        BiomeGenBase biomegenbase1 = this.biomesForGeneration[ax + ox + 2 + (az + oz + 2) * 10];
                        float rootHeight = biomegenbase1.field_76748_D;
                        float heightVariation = biomegenbase1.field_76749_E;
                        float heightFactor = this.parabolicField[ox + 2 + (oz + 2) * 5] / (rootHeight + 2.0f);
                        if (biomegenbase1.field_76748_D > biomegenbase.field_76748_D) {
                            heightFactor /= 2.0f;
                        }
                        totalVariation += heightVariation * heightFactor;
                        totalHeight += rootHeight * heightFactor;
                        totalFactor += heightFactor;
                    }
                }
                totalVariation /= totalFactor;
                totalHeight /= totalFactor;
                totalVariation = totalVariation * 0.9f + 0.1f;
                totalHeight = (totalHeight * 4.0f - 1.0f) / 8.0f;
                double terrainNoise = this.field_147426_g[noiseIndex] / 8000.0;
                if (terrainNoise < 0.0) {
                    terrainNoise = -terrainNoise * 0.3;
                }
                if ((terrainNoise = terrainNoise * 3.0 - 2.0) < 0.0) {
                    if ((terrainNoise /= 2.0) < -1.0) {
                        terrainNoise = -1.0;
                    }
                    terrainNoise /= 1.4;
                    terrainNoise /= 2.0;
                } else {
                    if (terrainNoise > 1.0) {
                        terrainNoise = 1.0;
                    }
                    terrainNoise /= 8.0;
                }
                ++noiseIndex;
                double heightCalc = totalHeight;
                double variationCalc = (double)totalVariation * this.getHeightModifier() / 10.0;
                heightCalc += terrainNoise * 0.2;
                heightCalc = heightCalc * 8.5 / 8.0;
                double d5 = 8.5 + heightCalc * 4.0;
                for (int ay = 0; ay < 33; ++ay) {
                    double d6 = ((double)ay - d5) * 12.0 * 128.0 / 256.0 / variationCalc;
                    if (d6 < 0.0) {
                        d6 *= 4.0;
                    }
                    double d7 = this.field_147428_e[terrainIndex] / 512.0;
                    double d8 = this.field_147425_f[terrainIndex] / 512.0;
                    double d9 = (this.field_147427_d[terrainIndex] / 10.0 + 1.0) / 2.0;
                    double terrainCalc = MathHelper.func_151238_b((double)d7, (double)d8, (double)d9) - d6;
                    if (ay > 29) {
                        double d11 = (float)(ay - 29) / 3.0f;
                        terrainCalc = terrainCalc * (1.0 - d11) + -10.0 * d11;
                    }
                    this.terrainCalcs[terrainIndex] = terrainCalc;
                    ++terrainIndex;
                }
            }
        }
    }

    public void replaceBlocksForBiome(int par1, int par2, Block[] arrayOfIDs, byte[] arrayOfMeta, BiomeGenBase[] par4ArrayOfBiomeGenBase) {
        int var5 = 20;
        float var6 = 0.03125f;
        this.noiseGen8.setFrequency(0.0625f);
        if (this.getGenType() != GenType.END) {
            for (int var8 = 0; var8 < 16; ++var8) {
                for (int var9 = 0; var9 < 16; ++var9) {
                    byte mStone;
                    Block stone;
                    byte var15m;
                    Block var15;
                    byte var14m;
                    Block var14;
                    GSBiomeGenBase biomegenbase = (GSBiomeGenBase)par4ArrayOfBiomeGenBase[var8 + var9 * 16];
                    int var12 = (int)((double)this.noiseGen8.getNoise((float)(par1 * 16 + var8), (float)(par2 * 16 + var9)) / 3.0 + this.getDirtLayerSize() + this.rand.nextDouble() * 0.25);
                    int var13 = -1;
                    if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                        int index = -1;
                        for (GS_GenBlocks genBlock : genBlocks) {
                            ++index;
                            if (this.worldObj.field_73011_w != genBlock.getWorldProvider() || par4ArrayOfBiomeGenBase[var8 + var9 * 16] != genBlock.getBiome()) continue;
                            break;
                        }
                        var14 = genBlocks.get(index).getGrassBlock().getBlock();
                        var14m = genBlocks.get(index).getGrassBlock().getMetadata();
                        var15 = genBlocks.get(index).getDirtBlock().getBlock();
                        var15m = genBlocks.get(index).getDirtBlock().getMetadata();
                        stone = genBlocks.get(index).getStoneBlock().getBlock();
                        mStone = genBlocks.get(index).getStoneBlock().getMetadata();
                    } else {
                        var14 = this.getGrassBlock().getBlock();
                        var14m = this.getGrassBlock().getMetadata();
                        var15 = this.getDirtBlock().getBlock();
                        var15m = this.getDirtBlock().getMetadata();
                        stone = this.getStoneBlock().getBlock();
                        mStone = this.getStoneBlock().getMetadata();
                    }
                    for (int var16 = 255; var16 >= 0; --var16) {
                        int index = this.getIndex(var8, var16, var9);
                        if (this.canGenerateIceBlock() && (var16 == 5 || var16 == 6 + this.rand.nextInt(3))) {
                            arrayOfIDs[index] = this.getIceBlock().getBlock();
                            arrayOfMeta[index] = this.getIceBlock().getMetadata();
                        }
                        if (var16 <= 0 + this.rand.nextInt(5)) {
                            arrayOfIDs[index] = Blocks.field_150357_h;
                            continue;
                        }
                        Block var18 = arrayOfIDs[index];
                        if (Blocks.field_150350_a == var18) {
                            var13 = -1;
                            continue;
                        }
                        if (var18 == stone) {
                            arrayOfMeta[index] = mStone;
                            if (var13 == -1) {
                                if (var12 <= 0) {
                                    var14 = Blocks.field_150350_a;
                                    var14m = 0;
                                    var15 = stone;
                                    var15m = mStone;
                                } else if (var16 >= 36 && var16 <= 21) {
                                    if (this.enableBiomeGenBaseBlock() && !genBlocks.isEmpty()) {
                                        var14 = genBlocks.get(index).getGrassBlock().getBlock();
                                        var14m = genBlocks.get(index).getGrassBlock().getMetadata();
                                        var14 = genBlocks.get(index).getDirtBlock().getBlock();
                                        var14m = genBlocks.get(index).getDirtBlock().getMetadata();
                                    } else {
                                        var14 = this.getGrassBlock().getBlock();
                                        var14m = this.getGrassBlock().getMetadata();
                                        var14 = this.getDirtBlock().getBlock();
                                        var14m = this.getDirtBlock().getMetadata();
                                    }
                                }
                                var13 = var12;
                                arrayOfIDs[index] = var14;
                                arrayOfMeta[index] = var14m;
                                continue;
                            }
                            if (var13 <= 0) continue;
                            --var13;
                            arrayOfIDs[index] = var15;
                            arrayOfMeta[index] = var15m;
                            continue;
                        }
                        if (var16 >= this.getWaterLevel() || this.getGenType() != GenType.GC || !this.canGenerateWaterBlock()) continue;
                        arrayOfIDs[index] = this.getWaterBlock().getBlock();
                        arrayOfMeta[index] = this.getWaterBlock().getMetadata();
                    }
                }
            }
        } else {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    int b0 = 1;
                    int i1 = -1;
                    Block block = Blocks.field_150377_bs;
                    Block block1 = Blocks.field_150377_bs;
                    for (int j1 = 127; j1 >= 0; --j1) {
                        int k1 = (l * 16 + k) * 128 + j1;
                        Block block2 = arrayOfIDs[k1];
                        if (block2 != null && block2.func_149688_o() != Material.field_151579_a) {
                            if (block2 != Blocks.field_150377_bs) continue;
                            if (i1 == -1) {
                                if (b0 <= 0) {
                                    block = null;
                                    block1 = Blocks.field_150377_bs;
                                }
                                i1 = b0;
                                if (j1 >= 0) {
                                    arrayOfIDs[k1] = block;
                                    continue;
                                }
                                arrayOfIDs[k1] = block1;
                                continue;
                            }
                            if (i1 <= 0) continue;
                            --i1;
                            arrayOfIDs[k1] = block1;
                            continue;
                        }
                        i1 = -1;
                    }
                }
            }
        }
    }

    public void createCraters(int chunkX, int chunkZ, Block[] chunkArray, byte[] metaArray) {
        this.gcnoiseGen5.setFrequency(0.015f);
        for (int cx = chunkX - 2; cx <= chunkX + 2; ++cx) {
            block1: for (int cz = chunkZ - 2; cz <= chunkZ + 2; ++cz) {
                int x = 0;
                while (true) {
                    if (x >= 16) continue block1;
                    int z = 0;
                    while (true) {
                        if (z >= 16) break;
                        if (Math.abs(this.randFromPoint(cx * 16 + x, (cz * 16 + z) * 1000)) < (double)(this.gcnoiseGen5.getNoise((float)(cx * 16 + x), (float)(cz * 16 + z)) / (float)this.CRATER_PROB)) {
                            Random random = new Random(cx * 16 + x + (cz * 16 + z) * 5000);
                            EnumCraterSize cSize = EnumCraterSize.sizeArray[random.nextInt(EnumCraterSize.sizeArray.length)];
                            int size = random.nextInt(cSize.MAX_SIZE - cSize.MIN_SIZE) + cSize.MIN_SIZE + 15;
                            this.makeCrater(cx * 16 + x, cz * 16 + z, chunkX * 16, chunkZ * 16, size, chunkArray, metaArray);
                        }
                        ++z;
                    }
                    ++x;
                }
            }
        }
    }

    public void makeCrater(int craterX, int craterZ, int chunkX, int chunkZ, int size, Block[] chunkArray, byte[] metaArray) {
        int x = 0;
        while (true) {
            if (x >= 16) break;
            int z = 0;
            while (true) {
                if (z >= 16) break;
                double xDev = craterX - (chunkX + x);
                double zDev = craterZ - (chunkZ + z);
                if (xDev * xDev + zDev * zDev < (double)(size * size)) {
                    double sqrtY = (xDev /= (double)size) * xDev + (zDev /= (double)size) * zDev;
                    double yDev = sqrtY * sqrtY * 6.0;
                    yDev = 5.0 - yDev;
                    int helper = 0;
                    for (int y = 127; y > 0 && !((double)helper > yDev); --y) {
                        if (chunkArray[this.getIndex(x, y, z)] == null) continue;
                        this.getCraterAdditions(chunkArray, metaArray, x, y, z);
                        chunkArray[this.getIndex((int)x, (int)y, (int)z)] = Blocks.field_150350_a;
                        metaArray[this.getIndex((int)x, (int)y, (int)z)] = 0;
                        ++helper;
                    }
                }
                ++z;
            }
            ++x;
        }
    }

    private double randFromPoint(int x, int z) {
        int n = x + z * 57;
        n = n << 13 ^ n;
        return 1.0 - (double)(n * (n * n * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE) / 1.073741824E9;
    }

    protected int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public Chunk func_73158_c(int x, int z) {
        return this.func_73154_d(x, z);
    }

    public boolean func_73149_a(int x, int z) {
        return true;
    }

    public void func_73153_a(IChunkProvider chunk, int x, int z) {
        BlockFalling.field_149832_M = true;
        int var4 = x * 16;
        int var5 = z * 16;
        BiomeGenBase biomeGen = this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.worldObj.func_72807_a(var4 + 16, var5 + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long var7 = this.rand.nextLong() / 2L * 2L + 1L;
        long var9 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)x * var7 + (long)z * var9 ^ this.worldObj.func_72905_C());
        biomeGen.func_76728_a(this.worldObj, this.rand, var4, var5);
        this.decoratePlanet(this.worldObj, this.rand, var4, var5);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biomeGen, (int)(var4 + 8), (int)(var5 + 8), (int)16, (int)16, (Random)this.rand);
        this.onPopulate(chunk, x, z);
        BlockFalling.field_149832_M = false;
    }

    public void decoratePlanet(World world, Random rand, int x, int z) {
        this.getBiomeGenerator().decorate(world, rand, x, z);
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int i, int j, int k) {
        if (par1EnumCreatureType == EnumCreatureType.monster) {
            ArrayList<BiomeGenBase.SpawnListEntry> monsters = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry monster : this.getMonsters()) {
                monsters.add(monster);
            }
            return monsters;
        }
        if (par1EnumCreatureType == EnumCreatureType.creature) {
            ArrayList<BiomeGenBase.SpawnListEntry> creatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry creature : this.getCreatures()) {
                creatures.add(creature);
            }
            return creatures;
        }
        if (par1EnumCreatureType == EnumCreatureType.waterCreature) {
            ArrayList<BiomeGenBase.SpawnListEntry> watercreatures = new ArrayList<BiomeGenBase.SpawnListEntry>();
            for (BiomeGenBase.SpawnListEntry watercreature : this.getWaterCreatures()) {
                watercreatures.add(watercreature);
            }
            return watercreatures;
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int x, int z) {
    }

    public boolean func_73156_b() {
        return false;
    }

    public void func_104112_b() {
    }

    public ChunkPosition func_147416_a(World world, String string, int x, int y, int z) {
        return null;
    }

    public static void setBlocks(GS_GenBlocks array) {
        genBlocks.add(array);
    }

    protected double lerp(double d1, double d2, double t) {
        if (t < 0.0) {
            return d1;
        }
        if (t > 1.0) {
            return d2;
        }
        return d1 + (d2 - d1) * t;
    }

    protected double fade(double n) {
        return n * n * n * (n * (n * 6.0 - 15.0) + 10.0);
    }

    protected double clamp(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    protected abstract BiomeDecoratorSpace getBiomeGenerator();

    protected abstract BiomeGenBase[] getBiomesForGeneration();

    public abstract void onChunkProvider(int var1, int var2, Block[] var3, byte[] var4);

    public abstract void onPopulate(IChunkProvider var1, int var2, int var3);

    protected abstract BiomeGenBase.SpawnListEntry[] getMonsters();

    protected abstract BiomeGenBase.SpawnListEntry[] getCreatures();

    protected abstract BiomeGenBase.SpawnListEntry[] getWaterCreatures();

    protected abstract List<MapGenBaseMeta> getWorldGenerators();

    public abstract double getHeightModifier();

    public abstract double getSmallFeatureHeightModifier();

    public abstract double getMountainHeightModifier();

    public abstract double getValleyHeightModifier();

    public abstract int getWaterLevel();

    public abstract boolean canGenerateWaterBlock();

    public abstract boolean canGenerateIceBlock();

    public abstract int getCraterProbability();

    protected abstract BlockMetaPair getWaterBlock();

    protected abstract BlockMetaPair getGrassBlock();

    protected abstract BlockMetaPair getDirtBlock();

    protected abstract BlockMetaPair getStoneBlock();

    protected abstract boolean enableBiomeGenBaseBlock();

    protected abstract GenType getGenType();

    public int getCraterSize() {
        return 0;
    }

    public int getTerrainLevel() {
        return this.getWaterLevel();
    }

    public double getDirtLayerSize() {
        return 3.0;
    }

    protected BlockMetaPair getIceBlock() {
        return new BlockMetaPair(Blocks.field_150403_cj, 0);
    }

    public void getCraterAdditions(Block[] chunkArray, byte[] metaArray, int x, int y, int z) {
    }

    public static enum GenType {
        GC,
        VANILLA,
        END;

    }
}

