/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.util.astronomy;

import galaxyspace.api.BodiesHelper;
import galaxyspace.api.dimension.IAdvancedSpace;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.IChildBody;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.world.WorldProvider;

public class AstronomyUtil {
    public static String classPlanet(CelestialBody body, WorldProvider dim) {
        BodiesHelper.BodiesData data = BodiesHelper.data.get(body);
        if (body.getReachable() && body != GalacticraftCore.planetOverworld) {
            float temp = 0.0f;
            try {
                temp = ((IGalacticraftWorldProvider)dim).getThermalLevelModifier();
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean breath = false;
            try {
                breath = ((IGalacticraftWorldProvider)dim).hasBreathableAtmosphere();
            }
            catch (Exception exception) {
                // empty catch block
            }
            String type = "";
            if (temp >= 2.0f) {
                type = BodiesHelper.hot;
            }
            if (temp >= 1.0f && (double)temp < 2.0) {
                type = BodiesHelper.warm;
            }
            if (temp > -1.0f && temp < 1.0f) {
                type = BodiesHelper.comfort;
            }
            if ((double)temp > -2.0 && temp <= -1.0f) {
                type = BodiesHelper.cool;
            }
            if (temp <= -2.0f) {
                type = BodiesHelper.cold;
            }
            if (!breath && body.atmosphere.isEmpty()) {
                if ((double)((WorldProviderSpace)dim).getDayLength() == 0.0 || dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.ASTEROID) {
                    return BodiesHelper.asteroid;
                }
                return type + " " + BodiesHelper.selena;
            }
            if (breath) {
                return type + " " + BodiesHelper.terra;
            }
            if (!breath && (double)temp > -5.0 && dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.TITAN) {
                type = temp > 3.0f ? BodiesHelper.hot : (temp < -3.0f ? BodiesHelper.icy : BodiesHelper.comfort);
                return type + " " + BodiesHelper.titan;
            }
            if (dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.OCEANIDE) {
                return BodiesHelper.oceanide;
            }
            if (dim instanceof IAdvancedSpace && ((IAdvancedSpace)dim).getClassBody() == IAdvancedSpace.ClassBody.GASGIANT) {
                return BodiesHelper.gasgiant;
            }
            if (temp < -3.0f) {
                return BodiesHelper.iceworld;
            }
            return type + " " + BodiesHelper.desert;
        }
        if (body == GalacticraftCore.planetOverworld) {
            return BodiesHelper.comfort + " " + BodiesHelper.terra;
        }
        if (data != null && data.getClassPlanet() != null) {
            return data.getClassPlanet();
        }
        return GCCoreUtil.translate((String)"gui.message.unknown");
    }

    public static boolean isEqualGalaxy(CelestialBody start, CelestialBody end) {
        if (start instanceof Planet) {
            Planet s = (Planet)start;
            if (end instanceof IChildBody) {
                IChildBody e = (IChildBody)end;
                return s.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(e.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName());
            }
            Planet e = (Planet)end;
            return s.getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(e.getParentSolarSystem().getUnlocalizedParentGalaxyName());
        }
        if (start instanceof IChildBody) {
            IChildBody s = (IChildBody)start;
            if (end instanceof Planet) {
                Planet e = (Planet)end;
                return s.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(e.getParentSolarSystem().getUnlocalizedParentGalaxyName());
            }
            IChildBody e = (IChildBody)end;
            return s.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName().equals(e.getParentPlanet().getParentSolarSystem().getUnlocalizedParentGalaxyName());
        }
        return false;
    }

    public static class PathsSolarSystems {
        public SolarSystem start;
        public SolarSystem end;

        public PathsSolarSystems(SolarSystem s1, SolarSystem s2) {
            this.start = s1;
            this.end = s2;
        }

        public SolarSystem getStartSystem() {
            return this.start;
        }

        public SolarSystem getEndSystem() {
            return this.end;
        }
    }
}

