/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.proxy;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import galaxyspace.GalaxySpace;
import galaxyspace.core.client.GSKeyHandlerClient;
import galaxyspace.core.client.particles.JPParticles;
import galaxyspace.core.client.render.entity.RenderEntryPod;
import galaxyspace.core.client.render.entity.RenderIceSpike;
import galaxyspace.core.client.render.item.ItemRenderBow;
import galaxyspace.core.client.render.item.ItemRenderKey;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.GSClientTickHandler;
import galaxyspace.core.handler.GSColorRingClient;
import galaxyspace.core.handler.GSEffectHandler;
import galaxyspace.core.handler.GSSkyProviderHandler;
import galaxyspace.core.prefab.entity.EntityEntryPod;
import galaxyspace.core.prefab.entity.EntityIceSpike;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.FluidTexturesGS;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSMusicTicker;
import galaxyspace.systems.SolarSystem.moons.enceladus.render.items.ItemRendererEnceladusCrystal;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystall;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.systems.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.systems.SolarSystem.moons.europa.render.entities.RenderEvolvedColdBlaze;
import galaxyspace.systems.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.render.block.BlockRendererIoTreasureChest;
import galaxyspace.systems.SolarSystem.moons.io.render.entities.RenderBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.render.tile.TileEntityIoTreasureChestRenderer;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityIoTreasureChest;
import galaxyspace.systems.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.render.block.BlockRendererCeresTreasureChest;
import galaxyspace.systems.SolarSystem.planets.ceres.render.entities.RenderBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.render.tile.TileEntityCeresTreasureChestRenderer;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityCeresTreasureChest;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityCargoFluidRocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier4Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier5Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier6Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.block.BlockRendererAdvLandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.render.entities.RenderCargoFluidRocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.entities.RenderRockets;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererCargoFluidRocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererFluidTank;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererJetPack;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererThermalPaddingT2;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererThermodynamicReactor;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererTier4Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererTier5Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.item.ItemRendererTier6Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityFluidTankRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityHydroponicFarmRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityPortableNuclearReactorRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntitySolarPanelRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntitySolarWindPanelRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.render.tile.TileEntityWindTurbineRenderer;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFluidTank;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPortableNuclearReactor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntitySolarPanel;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntitySolarWind;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindTurbine;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireBlaze;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireCreeper;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireSkeleton;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireSpider;
import galaxyspace.systems.SolarSystem.planets.venus.render.entities.RenderEvolvedBlaze;
import galaxyspace.systems.SolarSystem.planets.venus.render.entities.RenderEvolvedFireCreeper;
import galaxyspace.systems.SolarSystem.planets.venus.render.entities.RenderEvolvedFireSkeleton;
import galaxyspace.systems.SolarSystem.planets.venus.render.entities.RenderEvolvedFireSpider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.client.render.block.BlockRendererMachine;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityBubbleProviderRenderer;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;

public class ClientProxy
extends CommonProxy {
    public static Map<String, String> GScapeMap = new HashMap<String, String>();
    public static Map<String, ResourceLocation> GScapesMap = Maps.newHashMap();
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public static MusicTicker.MusicType GS_MUSIC;
    private static int ceresMachineRenderID;
    private static int fuelGeneratorRenderID;
    private static int solarWindPanelRenderID;
    private static int convertersurfaceRenderID;
    private static int storagemoduleRenderID;
    private static int oxstoragemoduleRenderID;
    private static int solarPanelRenderID;
    private static int gravitationmoduleRenderID;
    public static int futureLampRenderID;
    private static int windTurbineRenderID;
    private static int advOxygenSealerRenderID;
    private static int advFuelLoaderRenderID;
    private static int rocketAssemblyRenderID;
    private static int recyclerRenderID;
    private static int liquidextractorRenderID;
    private static int portablenuclearreactorRenderID;
    private static int fluidtankRenderID;
    private static int advlandingpadRenderID;
    private static int cargofluidRenderId;
    private static int gydroponicbaseRenderId;
    private static int gydroponicfarmRenderId;
    private static int liquidseparatorRenderID;
    private static int radiationstabiliserRenderID;
    private static int modificationtableRenderID;
    private static int oxygenfillerRenderID;
    private static int ceresTreasureChestRenderID;
    private static int ioTreasureChestRenderID;
    private static int enceladusTreasureChestRenderID;
    private static int proteusTreasureChestRenderID;
    private static int plutoTreasureChestRenderID;
    private static int renderIndexJetpackArmor;
    private static int renderIndexArmor;

    @Override
    public void preload() {
        this.register_event(new GSSkyProviderHandler());
        this.register_event(new GSColorRingClient());
        this.register_event(new GSClientTickHandler());
        this.register_event((Object)new GSKeyHandlerClient());
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleHelmet);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleChest);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleLegs);
        ClientRegistry.registerKeyBinding((KeyBinding)GSKeyHandlerClient.toggleBoots);
        renderIndexJetpackArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Jetpack");
        renderIndexArmor = RenderingRegistry.addNewArmourRendererPrefix((String)"Armor") + RenderingRegistry.getNextAvailableRenderId();
        ClientProxy.setupCapes();
        FluidTexturesGS.init();
    }

    @Override
    public void load() {
        ClientProxy.registerEntityRenderers();
        ClientProxy.registerItemRenderers();
        Class[][] commonTypes = new Class[][]{{MusicTicker.MusicType.class, ResourceLocation.class, Integer.TYPE, Integer.TYPE}};
        GS_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum((Class[][])commonTypes, MusicTicker.MusicType.class, (String)"GS_MUSIC", (Object[])new Object[]{new ResourceLocation(GalaxySpace.ASSET_PREFIX, "galaxyspace.musicSpace"), 1000, 2000});
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCeresTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityCeresTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityIoTreasureChest.class, (TileEntitySpecialRenderer)new TileEntityIoTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarWind.class, (TileEntitySpecialRenderer)new TileEntitySolarWindPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySolarPanel.class, (TileEntitySpecialRenderer)new TileEntitySolarPanelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindTurbine.class, (TileEntitySpecialRenderer)new TileEntityWindTurbineRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityHydroponicFarm.class, (TileEntitySpecialRenderer)new TileEntityHydroponicFarmRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPortableNuclearReactor.class, (TileEntitySpecialRenderer)new TileEntityPortableNuclearReactorRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFluidTank.class, (TileEntitySpecialRenderer)new TileEntityFluidTankRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityRadiationStabiliser.class, (TileEntitySpecialRenderer)new TileEntityBubbleProviderRenderer(0.45f, 0.0f, 0.1f));
    }

    @Override
    public void postload() {
        if (GSConfigCore.enableMusic) {
            try {
                Field ftc = Minecraft.func_71410_x().getClass().getDeclaredField(VersionUtil.getNameDynamic((String)"mcMusicTicker"));
                ftc.setAccessible(true);
                ftc.set(Minecraft.func_71410_x(), (Object)new GSMusicTicker(Minecraft.func_71410_x()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object[] otherInfo) {
        GSEffectHandler.spawnParticle(particleID, position, motion, otherInfo);
    }

    public static void registerEntityRenderers() {
        ceresMachineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(ceresMachineRenderID));
        storagemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(storagemoduleRenderID));
        fuelGeneratorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(fuelGeneratorRenderID));
        solarWindPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarWindPanelRenderID));
        convertersurfaceRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(convertersurfaceRenderID));
        oxstoragemoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(oxstoragemoduleRenderID));
        solarPanelRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(solarPanelRenderID));
        gravitationmoduleRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(gravitationmoduleRenderID));
        windTurbineRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(windTurbineRenderID));
        advOxygenSealerRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(advOxygenSealerRenderID));
        advFuelLoaderRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(advFuelLoaderRenderID));
        rocketAssemblyRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(rocketAssemblyRenderID));
        recyclerRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(recyclerRenderID));
        liquidextractorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(liquidextractorRenderID));
        portablenuclearreactorRenderID = RenderingRegistry.getNextAvailableRenderId();
        fluidtankRenderID = RenderingRegistry.getNextAvailableRenderId();
        advlandingpadRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererAdvLandingPad(advlandingpadRenderID));
        cargofluidRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(cargofluidRenderId));
        gydroponicfarmRenderId = RenderingRegistry.getNextAvailableRenderId();
        liquidseparatorRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(liquidseparatorRenderID));
        gydroponicbaseRenderId = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(gydroponicbaseRenderId));
        radiationstabiliserRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(radiationstabiliserRenderID));
        modificationtableRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(modificationtableRenderID));
        oxygenfillerRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererMachine(oxygenfillerRenderID));
        ceresTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererCeresTreasureChest(ceresTreasureChestRenderID));
        ioTreasureChestRenderID = RenderingRegistry.getNextAvailableRenderId();
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRendererIoTreasureChest(ioTreasureChestRenderID));
        RenderingRegistry.registerEntityRenderingHandler(EntityBossBlaze.class, (Render)new RenderBossBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityBossGhast.class, (Render)new RenderBossGhast());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireBlaze.class, (Render)new RenderEvolvedBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireCreeper.class, (Render)new RenderEvolvedFireCreeper());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSkeleton.class, (Render)new RenderEvolvedFireSkeleton());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedFireSpider.class, (Render)new RenderEvolvedFireSpider());
        RenderingRegistry.registerEntityRenderingHandler(EntityEvolvedColdBlaze.class, (Render)new RenderEvolvedColdBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityIceSpike.class, (Render)new RenderIceSpike(2.0f));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBlockCrystallTE.class, (TileEntitySpecialRenderer)new TileEntityBlockCrystall());
    }

    public static void registerItemRenderers() {
        IModelCustom rocketModeltier4 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(GalaxySpace.ASSET_PREFIX, "models/tier4rocket.obj"));
        IModelCustom rocketModeltier5 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(GalaxySpace.ASSET_PREFIX, "models/tier6rocket.obj"));
        IModelCustom rocketModeltier6 = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation(GalaxySpace.ASSET_PREFIX, "models/tier8rocket.obj"));
        IModelCustom cargoRocketModel = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galacticraftmars", "models/cargoRocket.obj"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier4Rocket.class, (Render)new RenderRockets(rocketModeltier4, GalaxySpace.ASSET_PREFIX, "tier4rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier5Rocket.class, (Render)new RenderRockets(rocketModeltier5, GalaxySpace.ASSET_PREFIX, "tier6rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier6Rocket.class, (Render)new RenderRockets(rocketModeltier6, GalaxySpace.ASSET_PREFIX, "tier8rocket"));
        RenderingRegistry.registerEntityRenderingHandler(EntityCargoFluidRocket.class, (Render)new RenderCargoFluidRocket(cargoRocketModel));
        RenderingRegistry.registerEntityRenderingHandler(EntityEntryPod.class, (Render)new RenderEntryPod());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier4Rocket, (IItemRenderer)new ItemRendererTier4Rocket(rocketModeltier4));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier5Rocket, (IItemRenderer)new ItemRendererTier5Rocket(rocketModeltier5));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.Tier6Rocket, (IItemRenderer)new ItemRendererTier6Rocket(rocketModeltier6));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.CargoFluidRocket, (IItemRenderer)new ItemRendererCargoFluidRocket(cargoRocketModel));
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.TierKeys, (IItemRenderer)new ItemRenderKey());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.ThermalPaddingTier2, (IItemRenderer)new ItemRendererThermalPaddingT2());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.JetPack, (IItemRenderer)new ItemRendererJetPack());
        MinecraftForgeClient.registerItemRenderer((Item)GSItems.QuantBow, (IItemRenderer)new ItemRenderBow());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GSBlocks.PortableNuclearReactor), (IItemRenderer)new ItemRendererThermodynamicReactor());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GSBlocks.FluidTank), (IItemRenderer)new ItemRendererFluidTank());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GSBlocks.EnceladusCrystal), (IItemRenderer)new ItemRendererEnceladusCrystal());
        MinecraftForgeClient.registerItemRenderer((Item)Item.func_150898_a((Block)GSBlocks.HydroponicFarm), (IItemRenderer)new ItemRendererHydroponicFarm());
    }

    @Override
    public int getBlockRender(Block block) {
        if (block == GSBlocks.AssemblyMachine) {
            return ceresMachineRenderID;
        }
        if (block == GSBlocks.StorageModuleT3) {
            return storagemoduleRenderID;
        }
        if (block == GSBlocks.FuelGenerator) {
            return fuelGeneratorRenderID;
        }
        if (block == GSBlocks.SolarWindPanel) {
            return solarWindPanelRenderID;
        }
        if (block == GSBlocks.ConverterSurface) {
            return convertersurfaceRenderID;
        }
        if (block == GSBlocks.OxStorageModuleT2) {
            return oxstoragemoduleRenderID;
        }
        if (block == GSBlocks.SolarPanel) {
            return solarPanelRenderID;
        }
        if (block == GSBlocks.GravitationModule) {
            return gravitationmoduleRenderID;
        }
        if (block == GSBlocks.FutureLamp) {
            return futureLampRenderID;
        }
        if (block == GSBlocks.WindTurbine) {
            return windTurbineRenderID;
        }
        if (block == GSBlocks.AdvOxygenSealer) {
            return advOxygenSealerRenderID;
        }
        if (block == GSBlocks.AdvFuelLoader) {
            return advFuelLoaderRenderID;
        }
        if (block == GSBlocks.RocketAssembly) {
            return rocketAssemblyRenderID;
        }
        if (block == GSBlocks.Recycler) {
            return recyclerRenderID;
        }
        if (block == GSBlocks.LiquidExtractor) {
            return liquidextractorRenderID;
        }
        if (block == GSBlocks.PortableNuclearReactor) {
            return portablenuclearreactorRenderID;
        }
        if (block == GSBlocks.FluidTank) {
            return fluidtankRenderID;
        }
        if (block == GSBlocks.AdvLandingPadFull) {
            return advlandingpadRenderID;
        }
        if (block == GSBlocks.CargoFluidLoader) {
            return cargofluidRenderId;
        }
        if (block == GSBlocks.HydroponicBase) {
            return gydroponicbaseRenderId;
        }
        if (block == GSBlocks.HydroponicFarm) {
            return gydroponicfarmRenderId;
        }
        if (block == GSBlocks.LiquidSeparator) {
            return liquidseparatorRenderID;
        }
        if (block == GSBlocks.RadiationStabiliser) {
            return radiationstabiliserRenderID;
        }
        if (block == GSBlocks.ModificationTable) {
            return modificationtableRenderID;
        }
        if (block == GSBlocks.OxygenFiller) {
            return oxygenfillerRenderID;
        }
        if (block == GSBlocks.CeresTChestT4) {
            return ceresTreasureChestRenderID;
        }
        if (block == GSBlocks.IoTChestT5) {
            return ioTreasureChestRenderID;
        }
        return -1;
    }

    @Override
    public int getJetpackArmorRenderIndex() {
        return renderIndexJetpackArmor;
    }

    @Override
    public int getArmorRenderIndex() {
        return renderIndexArmor;
    }

    @Override
    public void register_event(Object obj) {
        FMLCommonHandler.instance().bus().register(obj);
        MinecraftForge.EVENT_BUS.register(obj);
    }

    @Override
    public void showJetpackParticles(World world, EntityLivingBase wearer, int streams) {
        if (streams == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71474_y.field_74362_aa == 0 || mc.field_71474_y.field_74362_aa == 1 && mc.field_71441_e.func_82737_E() % 4L == 0L) {
            Vec3 userPos = Vec3.func_72443_a((double)wearer.field_70165_t, (double)wearer.field_70163_u, (double)wearer.field_70161_v);
            if (!wearer.equals((Object)mc.field_71439_g)) {
                userPos = userPos.func_72441_c(0.0, 1.6, 0.0);
            }
            Random rand = new Random();
            Vec3 vLeft = Vec3.func_72443_a((double)-0.28, (double)-0.95, (double)-0.38);
            vLeft.func_72442_b((float)Math.toRadians(-wearer.field_70761_aq));
            Vec3 vRight = Vec3.func_72443_a((double)0.28, (double)-0.95, (double)-0.38);
            vRight.func_72442_b((float)Math.toRadians(-wearer.field_70761_aq));
            Vec3 vCenter = Vec3.func_72443_a((double)((rand.nextFloat() - 0.5f) * 0.25f), (double)-0.95, (double)-0.38);
            vCenter.func_72442_b((float)Math.toRadians(-wearer.field_70761_aq));
            vLeft = vLeft.func_72441_c(-wearer.field_70159_w * 0.2, -wearer.field_70181_x * 0.2, -wearer.field_70179_y * 0.2);
            vRight = vRight.func_72441_c(-wearer.field_70159_w * 0.2, -wearer.field_70181_x * 0.2, -wearer.field_70179_y * 0.2);
            vCenter = vCenter.func_72441_c(-wearer.field_70159_w * 0.2, -wearer.field_70181_x * 0.2, -wearer.field_70179_y * 0.2);
            Vec3 v = userPos.func_72441_c(vLeft.field_72450_a, vLeft.field_72448_b, vLeft.field_72449_c);
            if (streams == 1) {
                JPParticles.spawnParticle(mc, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
            }
            v = userPos.func_72441_c(vRight.field_72450_a, vRight.field_72448_b, vRight.field_72449_c);
            if (streams == 2) {
                JPParticles.spawnParticle(mc, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
            }
            v = userPos.func_72441_c(vCenter.field_72450_a, vCenter.field_72448_b, vCenter.field_72449_c);
            if (streams == 2) {
                JPParticles.spawnParticle(mc, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, rand.nextDouble() * 0.05 - 0.025, -0.2, rand.nextDouble() * 0.05 - 0.025);
            }
        }
    }

    public static void setupCapes() {
        try {
            ClientProxy.updateCapeList();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Error while setting up Galaxy Space donate capes/skins", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    private static void updateCapeList() {
        int timeout = 10000;
        URL capeListUrl = null;
        try {
            capeListUrl = new URL("https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/master/capes/capes.txt");
        }
        catch (MalformedURLException e) {
            FMLLog.severe((String)"Error getting capes list URL", (Object[])new Object[0]);
            e.printStackTrace();
            return;
        }
        URLConnection connection = null;
        try {
            connection = capeListUrl.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        InputStream stream = null;
        try {
            stream = connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        InputStreamReader streamReader = new InputStreamReader(stream);
        BufferedReader reader = new BufferedReader(streamReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(":")) continue;
                int splitLocation = line.indexOf(":");
                String username = line.substring(0, splitLocation);
                String capeUrl = "https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/master/capes/" + line.substring(splitLocation + 1) + ".png";
                GScapeMap.put(username, capeUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            streamReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

