/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.items;

import galaxyspace.GalaxySpace;
import galaxyspace.core.util.GSCreativeTabs;
import java.util.List;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C07PacketPlayerDigging;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.world.BlockEvent;

public class ItemPickaxeGS
extends ItemPickaxe {
    protected boolean drillMode;
    public static String drill = "drill";
    public int breakRadius;
    public int breakDepth;
    protected IIcon[] icons = new IIcon[2];
    static Material[] materials = new Material[]{Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g};

    public ItemPickaxeGS(String assetName, Item.ToolMaterial material, boolean drillMode) {
        super(material);
        this.func_77655_b(assetName);
        this.func_111206_d(GalaxySpace.ASSET_PREFIX + ":tools/" + assetName);
        this.drillMode = drillMode;
        this.breakRadius = 1;
        this.breakDepth = 0;
        this.setNoRepair();
    }

    public CreativeTabs func_77640_w() {
        return GSCreativeTabs.GSArmorTab;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        if (!world.field_72995_K && this.drillMode) {
            if (!stack.field_77990_d.func_74767_n(drill)) {
                stack.field_77990_d.func_74757_a(drill, true);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_GREEN + StatCollector.func_74838_a((String)"gui.pickaxe.drillmodeon")));
            } else {
                stack.field_77990_d.func_74757_a(drill, false);
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.pickaxe.drillmodeoff")));
            }
        }
        return stack;
    }

    public boolean isEffective(Block block, int meta) {
        if (this.getHarvestType().equals(block.getHarvestTool(meta))) {
            return true;
        }
        return this.isEffective(block.func_149688_o());
    }

    public boolean isEffective(Material material) {
        for (Material m : this.getEffectiveMaterials()) {
            if (m != material) continue;
            return true;
        }
        return false;
    }

    protected String getHarvestType() {
        return "pickaxe";
    }

    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    public boolean func_150897_b(Block block) {
        return this.isEffective(block.func_149688_o());
    }

    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        Block block = player.field_70170_p.func_147439_a(x, y, z);
        int meta = player.field_70170_p.func_72805_g(x, y, z);
        if (block == null || !this.isEffective(block, meta) || !stack.func_77942_o()) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        if (!stack.func_77978_p().func_74767_n(drill)) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        MovingObjectPosition mop = ItemPickaxeGS.raytraceFromEntity(player.field_70170_p, (Entity)player, false, 4.5);
        if (mop == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int sideHit = mop.field_72310_e;
        int xRange = this.breakRadius;
        int yRange = this.breakRadius;
        int zRange = this.breakDepth;
        switch (sideHit) {
            case 0: 
            case 1: {
                yRange = this.breakDepth;
                zRange = this.breakRadius;
                break;
            }
            case 2: 
            case 3: {
                xRange = this.breakRadius;
                zRange = this.breakDepth;
                break;
            }
            case 4: 
            case 5: {
                xRange = this.breakDepth;
                zRange = this.breakRadius;
            }
        }
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    if (xPos == x && yPos == y && zPos == z || super.onBlockStartBreak(stack, xPos, yPos, zPos, player)) continue;
                    this.breakExtraBlock(player.field_70170_p, xPos, yPos, zPos, sideHit, player, x, y, z);
                }
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_77964_b(stack.func_77960_j() + 1);
        }
        return super.onBlockStartBreak(stack, x, y, z, player);
    }

    public static MovingObjectPosition raytraceFromEntity(World world, Entity player, boolean par3, double range) {
        float f = 1.0f;
        float f1 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float f2 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f;
        if (!world.field_72995_K && player instanceof EntityPlayer) {
            d1 += 1.62;
        }
        double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 vec3 = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        double d3 = range;
        if (player instanceof EntityPlayerMP) {
            d3 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 vec31 = vec3.func_72441_c((double)f7 * d3, (double)f6 * d3, (double)f8 * d3);
        return world.func_147447_a(vec3, vec31, par3, !par3, par3);
    }

    protected void breakExtraBlock(World world, int x, int y, int z, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        if (!ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)player.func_71045_bC())) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        player.func_71045_bC().func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
            Minecraft.func_71410_x().func_147114_u().func_147297_a((Packet)new C07PacketPlayerDigging(2, x, y, z, Minecraft.func_71410_x().field_71476_x.field_72310_e));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List par2List, boolean b) {
        if (this.drillMode) {
            if (stack.field_77990_d != null && stack.field_77990_d.func_74767_n(drill)) {
                par2List.add(EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.pickaxe.drillmodeon"));
            } else {
                par2List.add(EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.pickaxe.drillmodeoff"));
            }
        }
    }
}

