/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.prefab.items;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import mekanism.api.energy.IEnergizedItem;
import micdoodle8.mods.galacticraft.api.item.IItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2;
import micdoodle8.mods.galacticraft.core.energy.item.ElectricItemManagerIC2_1710;
import micdoodle8.mods.galacticraft.core.items.ItemBatteryInfinite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;

@Optional.InterfaceList(value={@Optional.Interface(modid="CoFHAPI", iface="cofh.api.energy.IEnergyContainerItem"), @Optional.Interface(modid="Mekanism", iface="mekanism.api.energy.IEnergizedItem"), @Optional.Interface(modid="IC2", iface="ic2.api.item.IElectricItem"), @Optional.Interface(modid="IC2", iface="ic2.api.item.ISpecialElectricItem")})
public abstract class ItemElectricArmor
extends ItemArmor
implements IItemElectricBase,
IEnergyContainerItem,
IElectricItem,
ISpecialElectricItem,
IEnergizedItem {
    private static Object itemManagerIC2;
    public float transferMax = 200.0f;
    private DefaultArtifactVersion mcVersion = null;

    public ItemElectricArmor(ItemArmor.ArmorMaterial material, int renderIndex, int armorIndex, String assetSuffix) {
        super(material, renderIndex, armorIndex);
        this.func_77655_b(assetSuffix);
        this.func_77625_d(1);
        this.func_77656_e(100);
        this.setNoRepair();
        this.mcVersion = new DefaultArtifactVersion((String)FMLInjectionData.data()[4]);
        if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
            itemManagerIC2 = VersionParser.parseRange((String)"[1.7.2]").containsVersion((ArtifactVersion)this.mcVersion) ? new ElectricItemManagerIC2() : new ElectricItemManagerIC2_1710();
        }
    }

    public float recharge(ItemStack itemStack, float energy, boolean doRecharge) {
        float rejectedElectricity = Math.max(this.getElectricityStored(itemStack) + energy - this.getMaxElectricityStored(itemStack), 0.0f);
        float energyToReceive = energy - rejectedElectricity;
        if (energyToReceive > this.transferMax) {
            rejectedElectricity += energyToReceive - this.transferMax;
            energyToReceive = this.transferMax;
        }
        if (doRecharge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) + energyToReceive);
        }
        return energyToReceive;
    }

    public float discharge(ItemStack itemStack, float energy, boolean doDischarge) {
        float energyToTransfer = Math.min(Math.min(this.getElectricityStored(itemStack), energy), this.transferMax);
        if (doDischarge) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - energyToTransfer);
        }
        return energyToTransfer;
    }

    public float getElectricityStored(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float energyStored = 0.0f;
        if (itemStack.func_77978_p().func_74764_b("electricity")) {
            NBTBase obj = itemStack.func_77978_p().func_74781_a("electricity");
            if (obj instanceof NBTTagDouble) {
                energyStored = ((NBTTagDouble)obj).func_150288_h();
            } else if (obj instanceof NBTTagFloat) {
                energyStored = ((NBTTagFloat)obj).func_150288_h();
            }
        }
        itemStack.func_77964_b((int)(100.0f - energyStored / this.getMaxElectricityStored(itemStack) * 100.0f));
        return energyStored;
    }

    public abstract float getMaxElectricityStored(ItemStack var1);

    public void setElectricity(ItemStack itemStack, float joules) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        float electricityStored = Math.max(Math.min(joules, this.getMaxElectricityStored(itemStack)), 0.0f);
        itemStack.func_77978_p().func_74776_a("electricity", electricityStored);
        itemStack.func_77964_b((int)(100.0f - electricityStored / this.getMaxElectricityStored(itemStack) * 100.0f));
    }

    public float getTransfer(ItemStack itemStack) {
        return Math.min(this.transferMax, this.getMaxElectricityStored(itemStack) - this.getElectricityStored(itemStack));
    }

    public int getTierGC(ItemStack itemStack) {
        return 1;
    }

    @Optional.Method(modid="CoFHAPI")
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return (int)(this.recharge(container, (float)maxReceive * EnergyConfigHandler.RF_RATIO, !simulate) / EnergyConfigHandler.RF_RATIO);
    }

    @Optional.Method(modid="CoFHAPI")
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        return (int)(this.discharge(container, (float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getEnergyStored(ItemStack container) {
        return (int)(this.getElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Optional.Method(modid="CoFHAPI")
    public int getMaxEnergyStored(ItemStack container) {
        return (int)(this.getMaxElectricityStored(container) * EnergyConfigHandler.TO_RF_RATIO);
    }

    @Optional.Method(modid="Mekanism")
    public double getEnergy(ItemStack itemStack) {
        return this.getElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Optional.Method(modid="Mekanism")
    public void setEnergy(ItemStack itemStack, double amount) {
        this.setElectricity(itemStack, (float)amount * EnergyConfigHandler.MEKANISM_RATIO);
    }

    @Optional.Method(modid="Mekanism")
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getMaxElectricityStored(itemStack) * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Optional.Method(modid="Mekanism")
    public double getMaxTransfer(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_MEKANISM_RATIO;
    }

    @Optional.Method(modid="Mekanism")
    public boolean canReceive(ItemStack itemStack) {
        return itemStack != null && !(itemStack.func_77973_b() instanceof ItemBatteryInfinite);
    }

    @Optional.Method(modid="Mekanism")
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemstack) {
        return (IElectricItemManager)itemManagerIC2;
    }

    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return itemStack.func_77973_b();
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return 1;
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return this.transferMax * EnergyConfigHandler.TO_IC2_RATIO;
    }

    public float getMaxTransferGC(ItemStack itemStack) {
        return this.transferMax;
    }
}

