/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.network.packet;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.api.item.IModificationItem;
import galaxyspace.api.tile.ITileEffects;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.prefab.items.modules.ItemModule;
import galaxyspace.core.util.GSUtils;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceArmors;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.NetworkUtil;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;

public class GSPacketSimple
extends Packet
implements IPacket {
    private GSEnumSimplePacket type;
    private List<Object> data;
    private static String spamCheckString;

    public GSPacketSimple() {
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, Object ... data) {
        this(packetType, Arrays.asList(data));
    }

    public GSPacketSimple(GSEnumSimplePacket packetType, List<Object> data) {
        if (packetType.getDecodeClasses().length != data.size()) {
            new RuntimeException().printStackTrace();
        }
        this.type = packetType;
        this.data = data;
    }

    public void encodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        buffer.writeInt(this.type.ordinal());
        try {
            NetworkUtil.encodeData((ByteBuf)buffer, this.data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer) {
        this.type = GSEnumSimplePacket.values()[buffer.readInt()];
        try {
            if (this.type.getDecodeClasses().length > 0) {
                this.data = NetworkUtil.decodeData((Class[])this.type.getDecodeClasses(), (ByteBuf)buffer);
            }
            if (buffer.readableBytes() > 0) {
                GCLog.severe((String)("Galacticraft packet length problem for packet type " + this.type.toString()));
            }
        }
        catch (Exception e) {
            System.err.println("[Galacticraft] Error handling simple packet type: " + this.type.toString() + " " + buffer.toString());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        EntityClientPlayerMP playerBaseClient = null;
        GCPlayerStatsClient stats = null;
        if (player instanceof EntityClientPlayerMP) {
            playerBaseClient = (EntityClientPlayerMP)player;
            stats = GCPlayerStatsClient.get((EntityPlayerSP)playerBaseClient);
        }
        switch (this.type) {
            case C_UPDATE_DIMENSION_LIST: {
                if (!String.valueOf(this.data.get(0)).equals(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName())) break;
                String dimensionList = (String)this.data.get(1);
                if (ConfigManagerCore.enableDebug) {
                    if (!dimensionList.equals(spamCheckString)) {
                        GCLog.info((String)("DEBUG info: " + dimensionList));
                        spamCheckString = new String(dimensionList);
                    }
                }
                String[] destinations = dimensionList.split("\\?");
                ArrayList possibleCelestialBodies = Lists.newArrayList();
                HashMap spaceStationData = Maps.newHashMap();
                for (String str : destinations) {
                    CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForName((String)str);
                    if (celestialBody == null && str.contains("$")) {
                        String[] values = str.split("\\$");
                        int homePlanetID = Integer.parseInt(values[4]);
                        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
                            if (satellite.getParentPlanet().getDimensionID() != homePlanetID) continue;
                            celestialBody = satellite;
                            break;
                        }
                        if (!spaceStationData.containsKey(homePlanetID)) {
                            spaceStationData.put(homePlanetID, new HashMap());
                        }
                        ((Map)spaceStationData.get(homePlanetID)).put(values[1], new GuiCelestialSelection.StationDataGUI(values[2], Integer.valueOf(Integer.parseInt(values[3]))));
                    }
                    if (celestialBody == null) continue;
                    possibleCelestialBodies.add(celestialBody);
                }
                if (FMLClientHandler.instance().getClient().field_71441_e == null) break;
                if (!(FMLClientHandler.instance().getClient().field_71462_r instanceof GSGuiCelestialSelection)) {
                    GalaxySpace.debug(this.data + "");
                    Integer[] ints = new Integer[]{(Integer)this.data.get(2), (Integer)this.data.get(3)};
                    GSGuiCelestialSelection gui = new GSGuiCelestialSelection(false, possibleCelestialBodies, ints);
                    gui.spaceStationMap = spaceStationData;
                    FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)gui);
                    break;
                }
                ((GSGuiCelestialSelection)FMLClientHandler.instance().getClient().field_71462_r).spaceStationMap = spaceStationData;
                break;
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
        EntityPlayerMP playerBase = PlayerUtil.getPlayerBaseServerFromPlayer((EntityPlayer)player, (boolean)false);
        if (playerBase == null) {
            return;
        }
        GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)playerBase);
        switch (this.type) {
            case S_UPDATE_NBT_ITEM_ON_GUI: {
                ItemStack[] copied;
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                String tag = (String)this.data.get(1);
                boolean turn = false;
                boolean consumed = false;
                TileEntity tileEntity = pos.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityModificationTable)) break;
                ItemStack[] stack = ((TileEntityModificationTable)tileEntity).func_70301_a(0);
                boolean check = true;
                ItemModule get_module = null;
                if (stack.func_77973_b() instanceof IModificationItem) {
                    for (ItemModule module : GSUtils.getListModule()) {
                        if (!module.getName().equals(tag)) continue;
                        get_module = module;
                        break;
                    }
                }
                if (get_module == null) break;
                if (get_module.getForrbidenModules() != null) {
                    ItemModule[] itemModuleArray = get_module.getForrbidenModules();
                    int module = itemModuleArray.length;
                    for (int i = 0; i < module; ++i) {
                        ItemModule forb_module = itemModuleArray[i];
                        if (!stack.func_77978_p().func_74764_b(forb_module.getName())) continue;
                        check = false;
                        break;
                    }
                }
                if (!stack.func_77978_p().func_74764_b(tag) || !stack.func_77978_p().func_74767_n(tag)) {
                    turn = true;
                } else if (stack.func_77978_p().func_74764_b(tag)) {
                    turn = false;
                }
                if (turn) {
                    if (!check || stack.func_77978_p().func_74762_e(ItemSpaceArmors.mod_count) <= 0) break;
                    for (Object con : get_module.getItemsForModule()) {
                        consumed = GSEventHandler.consumeItemStack((EntityPlayer)playerBase, (IInventory)playerBase.field_71071_by, con);
                    }
                    if (!consumed && !playerBase.field_71075_bZ.field_75098_d) break;
                    copied = stack;
                    copied.func_77978_p().func_74757_a(tag, true);
                    copied.func_77978_p().func_74768_a(ItemSpaceArmors.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceArmors.mod_count) - 1);
                    ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                    tileEntity.func_70296_d();
                    playerBase.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                    break;
                }
                if (!playerBase.field_71075_bZ.field_75098_d) {
                    for (Object con : get_module.getItemsForModule()) {
                        playerBase.field_71071_by.func_70441_a(con);
                    }
                }
                copied = stack;
                copied.func_77978_p().func_82580_o(tag);
                copied.func_77978_p().func_74768_a(ItemSpaceArmors.mod_count, copied.func_77978_p().func_74762_e(ItemSpaceArmors.mod_count) + 1);
                ((TileEntityModificationTable)tileEntity).func_70299_a(0, (ItemStack)copied);
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                break;
            }
            case S_UPDATE_NBT_ITEM_IN_ARMOR: {
                Integer armor_slot = (Integer)this.data.get(0);
                String tag = (String)this.data.get(1);
                ItemStack armor = playerBase.field_71071_by.field_70460_b[armor_slot];
                if (armor == null || !(armor.func_77973_b() instanceof ItemSpaceArmors)) break;
                ItemStack copied = armor;
                copied.func_77978_p().func_74757_a(tag, !copied.func_77978_p().func_74767_n(tag));
                playerBase.field_71071_by.field_70460_b[armor_slot.intValue()] = copied;
                break;
            }
            case S_CHANGE_FLIGHT_STATE: {
                Boolean state = (Boolean)this.data.get(0);
                GSEventHandler.enableFlight(player, state);
                break;
            }
            case S_GRAVITY_RADIUS: {
                BlockVec3 pos = (BlockVec3)this.data.get(0);
                Integer strength = (Integer)this.data.get(1);
                TileEntity tileEntity = pos.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityGravitationModule)) break;
                ((TileEntityGravitationModule)tileEntity).setGravityRadius(strength);
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                break;
            }
            case S_REVERSE_SEPATATOR: {
                BlockVec3 posSep = (BlockVec3)this.data.get(0);
                TileEntity tileEntity = posSep.getTileEntity((IBlockAccess)playerBase.field_70170_p);
                if (!(tileEntity instanceof TileEntityLiquidSeparator)) break;
                ((TileEntityLiquidSeparator)tileEntity).setReverse(!((TileEntityLiquidSeparator)tileEntity).getReverse());
                tileEntity.func_70296_d();
                playerBase.field_70170_p.func_147471_g(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
                break;
            }
            case S_ON_ADVANCED_GUI_CLICKED_INT: {
                TileEntity tile1 = player.field_70170_p.func_147438_o(((Integer)this.data.get(1)).intValue(), ((Integer)this.data.get(2)).intValue(), ((Integer)this.data.get(3)).intValue());
                switch ((Integer)this.data.get(0)) {
                    case 6: {
                        if (!(tile1 instanceof ITileEffects)) break;
                        ITileEffects distributor = (ITileEffects)tile1;
                        distributor.setEffectsVisible((Integer)this.data.get(4) == 1);
                    }
                }
                break;
            }
            case S_TELEPORT_ENTITY: {
                try {
                    WorldProvider provider = WorldUtil.getProviderForNameServer((String)((String)this.data.get(0)));
                    Integer dim = provider.field_76574_g;
                    GCLog.info((String)("Found matching world (" + dim.toString() + ") for name: " + (String)this.data.get(0)));
                    if (playerBase.field_70170_p instanceof WorldServer) {
                        WorldServer world = (WorldServer)playerBase.field_70170_p;
                        WorldUtil.transferEntityToDimension((Entity)playerBase, (int)dim, (WorldServer)world);
                    }
                    stats.teleportCooldown = 10;
                    stats.fuelLevel = (Integer)this.data.get(1);
                    GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_CLOSE_GUI, new Object[0]), playerBase);
                }
                catch (Exception e) {
                    GCLog.severe((String)("Error occurred when attempting to transfer entity to dimension: " + (String)this.data.get(0)));
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public void func_148837_a(PacketBuffer var1) {
        this.decodeInto(null, (ByteBuf)var1);
    }

    public void func_148840_b(PacketBuffer var1) {
        this.encodeInto(null, (ByteBuf)var1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_148833_a(INetHandler var1) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.handleClientSide((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity());
        }
    }

    public static enum GSEnumSimplePacket {
        S_GRAVITY_RADIUS(Side.SERVER, BlockVec3.class, Integer.class),
        S_REVERSE_SEPATATOR(Side.SERVER, BlockVec3.class),
        S_ON_ADVANCED_GUI_CLICKED_INT(Side.SERVER, Integer.class, Integer.class, Integer.class, Integer.class, Integer.class),
        S_CHANGE_FLIGHT_STATE(Side.SERVER, Boolean.class),
        S_TELEPORT_ENTITY(Side.SERVER, String.class, Integer.class),
        S_UPDATE_NBT_ITEM_ON_GUI(Side.SERVER, BlockVec3.class, String.class),
        S_UPDATE_NBT_ITEM_IN_ARMOR(Side.SERVER, Integer.class, String.class),
        C_UPDATE_DIMENSION_LIST(Side.CLIENT, String.class, String.class, Integer[].class);

        private Side targetSide;
        private Class<?>[] decodeAs;

        private GSEnumSimplePacket(Side targetSide, Class<?> ... decodeAs) {
            this.targetSide = targetSide;
            this.decodeAs = decodeAs;
        }

        public Side getTargetSide() {
            return this.targetSide;
        }

        public Class<?>[] getDecodeClasses() {
            return this.decodeAs;
        }
    }
}

