/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.minetweaker.handlers;

import galaxyspace.core.integration.minetweaker.GSMinetweakerConfig;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.RecyclerRecipes;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.galaxyspace.Recycler")
public class MTHandler_Recycler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack ingredient, int chance) {
        MineTweakerAPI.apply((IUndoableAction)new Add(GSMinetweakerConfig.getStack(output), GSMinetweakerConfig.getStack(ingredient), chance, null));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack ingredient, int chance, ILiquidStack liquid) {
        MineTweakerAPI.apply((IUndoableAction)new Add(GSMinetweakerConfig.getStack(output), GSMinetweakerConfig.getStack(ingredient), chance, GSMinetweakerConfig.getFluidStack(liquid)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(GSMinetweakerConfig.getStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<ItemStack> removed = new ArrayList<ItemStack>();

        public Remove(ItemStack stack) {
            this.output = stack;
        }

        public void apply() {
            RecyclerRecipes.recycling().removeRecipe(this.output);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return String.format("Removing all recipes for %s", this.output.func_77977_a());
        }

        public String describeUndo() {
            return String.format("Re-adding previously removed recipes for %s", this.output.func_77977_a());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private ItemStack result;
        private ItemStack stack;
        private int chance;
        private FluidStack fluidstack;

        public Add(ItemStack stack, ItemStack objects, int chance, FluidStack fluid) {
            this.result = stack;
            this.stack = objects;
            this.chance = chance;
            this.fluidstack = fluid;
        }

        public void apply() {
            RecyclerRecipes.recycling().addNewRecipe(this.stack, this.result, this.chance, this.fluidstack);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            RecyclerRecipes.recycling().removeRecipe(this.stack);
        }

        public String describe() {
            return String.format("Adding Universal Recycler recipe for item %s", this.stack.func_82833_r());
        }

        public String describeUndo() {
            return String.format("Removing Universal Recycler recipe for item %s", this.stack.func_82833_r());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

