/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.minetweaker.handlers;

import galaxyspace.core.integration.minetweaker.GSMinetweakerConfig;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.galaxyspace.HydroponicFarm")
public class MTHandler_HydroponicFarm {
    @ZenMethod
    public static void addPlant(IItemStack seed, IItemStack product, IItemStack block, int stages) {
        MineTweakerAPI.apply((IUndoableAction)new Add(GSMinetweakerConfig.getStack(seed), GSMinetweakerConfig.getStack(product), GSMinetweakerConfig.getBlock(block), stages));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack seed) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(GSMinetweakerConfig.getStack(seed)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<ItemStack> removed = new ArrayList<ItemStack>();

        public Remove(ItemStack stack) {
            this.output = stack;
        }

        public void apply() {
            TileEntityHydroponicBase.getSeeds().remove(this.output);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return String.format("Removing all recipes for %s", this.output.func_77977_a());
        }

        public String describeUndo() {
            return String.format("Re-adding previously removed recipes for %s", this.output.func_77977_a());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private ItemStack seed;
        private ItemStack product;
        private Block block;
        private int stages;

        public Add(ItemStack seed, ItemStack result, Block block, int stages) {
            this.seed = seed;
            this.product = result;
            this.block = block;
            this.stages = stages;
        }

        public void apply() {
            TileEntityHydroponicBase.addPlant(this.seed, this.product, null, 100, this.block, this.stages, new boolean[]{false, false});
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            TileEntityHydroponicBase.getSeeds().remove(TileEntityHydroponicBase.getData(this.seed));
        }

        public String describe() {
            return String.format("Adding Hydroponic Farm recipe for seed %s", this.seed.func_82833_r());
        }

        public String describeUndo() {
            return String.format("Removing Hydroponic Farm recipe for seed %s", this.seed.func_82833_r());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

