/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.integration.minetweaker.handlers;

import galaxyspace.core.integration.minetweaker.GSMinetweakerConfig;
import galaxyspace.systems.SolarSystem.planets.overworld.recipe.AssemberRecipes;
import java.util.ArrayList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.galaxyspace.Assembler")
public class MTHandler_Assembler {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] ingredients) {
        MineTweakerAPI.apply((IUndoableAction)new Add(GSMinetweakerConfig.getStack(output), GSMinetweakerConfig.getObjects(ingredients)));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Remove(GSMinetweakerConfig.getStack(output)));
    }

    private static class Remove
    implements IUndoableAction {
        private final ItemStack output;
        List<ItemStack> removed = new ArrayList<ItemStack>();

        public Remove(ItemStack stack) {
            this.output = stack;
        }

        public void apply() {
            AssemberRecipes.instance.removeRecipe(this.output);
        }

        public boolean canUndo() {
            return false;
        }

        public void undo() {
        }

        public String describe() {
            return String.format("Removing all recipes for %s", this.output.func_77977_a());
        }

        public String describeUndo() {
            return String.format("Re-adding previously removed recipes for %s", this.output.func_77977_a());
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class Add
    implements IUndoableAction {
        private ItemStack stack;
        private Object[] objects;

        public Add(ItemStack stack, Object[] objects) {
            this.stack = stack;
            this.objects = objects;
        }

        public void apply() {
            AssemberRecipes.instance.addShapelessRecipe(this.stack, this.objects);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            AssemberRecipes.instance.removeRecipe(this.stack);
        }

        public String describe() {
            return String.format("Adding Assembly Machine recipe for item %s", this.stack.func_82833_r());
        }

        public String describeUndo() {
            return String.format("Removing Assembly Machine recipe for item %s", this.stack.func_82833_r());
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

