/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import galaxyspace.GalaxySpace;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.api.dimension.IProviderFreeze;
import galaxyspace.api.item.IItemPressurized;
import galaxyspace.api.item.IItemRadiation;
import galaxyspace.api.item.IItemSpaceFood;
import galaxyspace.api.item.IJetpack;
import galaxyspace.core.achievements.AchEvent;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.SetBlockEvent;
import galaxyspace.core.handler.GSLightningStormHandler;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.prefab.entity.GSEntityMeteor;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.registers.potions.GSPotions;
import galaxyspace.core.util.GSAttributePlayer;
import galaxyspace.core.util.GSDamageSource;
import galaxyspace.systems.SolarSystem.planets.kuiperbelt.dimension.WorldProviderKuiper;
import galaxyspace.systems.SolarSystem.planets.overworld.items.ItemGSOxygenTank;
import galaxyspace.systems.SolarSystem.planets.overworld.items.tools.ItemAncientSword;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import galaxyspace.systems.TCetiSystem.planets.tcetiF.dimension.WorldProviderTCetiF;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.api.inventory.AccessInventoryGC;
import micdoodle8.mods.galacticraft.api.inventory.IInventoryGC;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3Dim;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.EntityAlienVillager;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedZombie;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerHandler;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemBasic;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityParaChest;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderSurface;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class GSEventHandler {
    protected HashMap<String, InventoryPlayer> playerKeepsMap = new HashMap();

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing e) {
        if (e.entity instanceof EntityPlayer) {
            ((EntityPlayer)e.entity).func_110140_aT().func_111150_b(GSAttributePlayer.OXTANKS_LEFT);
            ((EntityPlayer)e.entity).func_110140_aT().func_111150_b(GSAttributePlayer.OXTANKS_RIGHT);
            ((EntityPlayer)e.entity).func_110140_aT().func_111150_b(GSAttributePlayer.RADIATION_LVL);
            ((EntityPlayer)e.entity).func_110140_aT().func_111150_b(GSAttributePlayer.TOGGLE_HELMET);
            ((EntityPlayer)e.entity).func_110140_aT().func_111150_b(GSAttributePlayer.TOGGLE_JETPACK);
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent e) {
        if (e.entityLiving instanceof EntityPlayer) {
            ItemStack chest = ((EntityPlayer)e.entityLiving).func_82169_q(2);
            e.setCanceled(chest != null && chest.func_77973_b() instanceof IJetpack && ((IJetpack)chest.func_77973_b()).canFly(chest, (EntityPlayer)e.entityLiving) && ((IJetpack)chest.func_77973_b()).isActivated(chest));
        }
    }

    @SubscribeEvent
    public void onChangeDim(PlayerEvent.PlayerChangedDimensionEvent e) {
        if (e.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)e.player;
            GCPlayerStats gCPlayerStats = GCPlayerStats.get((EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent event) {
        ItemStack i;
        block19: {
            block20: {
                i = event.entityPlayer.field_71071_by.func_70448_g();
                if (i == null) break block19;
                PlayerInteractEvent.Action cfr_ignored_0 = event.action;
                if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) break block20;
                PlayerInteractEvent.Action cfr_ignored_1 = event.action;
                if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_AIR) break block19;
            }
            if (!event.world.field_72995_K) {
                GalaxySpace.debug("" + GameData.getItemRegistry().func_148750_c((Object)i.func_77973_b()));
            }
        }
        if (!event.world.field_72995_K) {
            TileEntity tile;
            EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
            GCPlayerStats GCPlayer = GCPlayerStats.get((EntityPlayerMP)player);
            if (GCPlayer.spaceshipTier >= 5 && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && (tile = event.world.func_147438_o(event.x, event.y, event.z)) != null && tile instanceof TileEntityParaChest) {
                TileEntityParaChest chest = (TileEntityParaChest)tile;
                if (chest.fuelTank.getFluid().getFluid() == GalacticraftCore.fluidFuel) {
                    chest.fuelTank.setFluid(new FluidStack(GSFluids.HeliumHydrogen, chest.fuelTank.getFluidAmount()));
                    GCPlayer.spaceshipTier = 0;
                }
            }
        }
        if (!event.world.field_72995_K && GSConfigCore.enableHardMode && !event.entityPlayer.field_71075_bZ.field_75098_d && event.world.field_73011_w instanceof IGalacticraftWorldProvider && !((IGalacticraftWorldProvider)event.world.field_73011_w).hasBreathableAtmosphere()) {
            if (i != null && i.func_77973_b() instanceof ItemFood && !(i.func_77973_b() instanceof IItemSpaceFood) && !(i.func_77973_b() instanceof ItemBasic)) {
                PlayerInteractEvent.Action cfr_ignored_2 = event.action;
                if (event.action != PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
                    if (((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() <= -2.0f && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)event.entityPlayer, (boolean)true)) {
                        Event.Result cfr_ignored_3 = event.useItem;
                        event.setResult(Event.Result.DENY);
                        event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygenandthermal.food")));
                        event.setCanceled(true);
                    } else if (((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() > -2.0f && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)event.entityPlayer, (boolean)false)) {
                        Event.Result cfr_ignored_4 = event.useItem;
                        event.setResult(Event.Result.DENY);
                        event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygen.food")));
                        event.setCanceled(true);
                    }
                }
            }
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(event.x - 1), (double)event.y, (double)(event.z - 1), (double)(event.x + 1), (double)(event.y + 2), (double)(event.z + 1));
                for (ItemStack stack : OreDictionary.getOres((String)"treeLeaves")) {
                    if (i == null || !i.func_77973_b().equals(stack.func_77973_b())) continue;
                    if (((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() < -1.0f && !OxygenUtil.isAABBInBreathableAirBlock((World)event.world, (AxisAlignedBB)bb, (boolean)true)) {
                        event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygenthermal")));
                        event.setCanceled(true);
                        continue;
                    }
                    if (!(((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() >= -1.0f) || OxygenUtil.isAABBInBreathableAirBlock((World)event.world, (AxisAlignedBB)bb, (boolean)false)) continue;
                    event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygen")));
                    event.setCanceled(true);
                }
                for (ItemStack stack : OreDictionary.getOres((String)"treeSapling")) {
                    if (i == null || !i.func_77973_b().equals(stack.func_77973_b())) continue;
                    if (((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() < -1.0f && !OxygenUtil.isAABBInBreathableAirBlock((World)event.world, (AxisAlignedBB)bb, (boolean)true)) {
                        event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygenthermal")));
                        event.setCanceled(true);
                        continue;
                    }
                    if (!(((IGalacticraftWorldProvider)event.world.field_73011_w).getThermalLevelModifier() >= -1.0f) || OxygenUtil.isAABBInBreathableAirBlock((World)event.world, (AxisAlignedBB)bb, (boolean)false)) continue;
                    event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygen")));
                    event.setCanceled(true);
                }
                if (i != null && (i.func_77973_b() instanceof ItemSeeds || i.func_77973_b().equals(Items.field_151080_bb) || i.func_77973_b().equals(Items.field_151081_bc) || i.func_77973_b().equals(Items.field_151174_bG) || i.func_77973_b().equals(Items.field_151172_bF) || i.func_77973_b().equals(Items.field_151014_N)) && event.world.func_147439_a(event.x, event.y, event.z) == Blocks.field_150458_ak && !OxygenUtil.isAABBInBreathableAirBlock((World)event.world, (AxisAlignedBB)bb, (boolean)true)) {
                    event.entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needoxygenthermal")));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onSetBlock(SetBlockEvent e) {
        if (!e.world.field_72995_K && GSConfigCore.enableHardMode && e.world.field_73011_w instanceof IGalacticraftWorldProvider && (e.world.field_73011_w instanceof IProviderFreeze || e.world.field_73011_w instanceof WorldProviderMoon || e.world.field_73011_w instanceof WorldProviderMars)) {
            float thermal = ((IGalacticraftWorldProvider)e.world.field_73011_w).getThermalLevelModifier();
            AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(e.x - 1), (double)(e.y - 1), (double)(e.z - 1), (double)(e.x + 1), (double)(e.y + 2), (double)(e.z + 1));
            if (e.block == Blocks.field_150355_j && e.meta == 0 && !OxygenUtil.isAABBInBreathableAirBlock((World)e.world, (AxisAlignedBB)bb, (boolean)true) && e.block.func_149688_o().equals(Material.field_151586_h)) {
                if (thermal <= -1.0f || e.world.field_73011_w instanceof WorldProviderMoon) {
                    e.world.func_147449_b(e.x, e.y, e.z, Blocks.field_150432_aD);
                    e.setCanceled(true);
                } else if (thermal >= 2.0f) {
                    e.setCanceled(true);
                }
            }
            if (!OxygenUtil.isAABBInBreathableAirBlock((World)e.world, (AxisAlignedBB)bb, (thermal > 1.0f || thermal < -1.0f ? 1 : 0) != 0)) {
                if (e.block instanceof BlockLeavesBase) {
                    e.setCanceled(true);
                }
                if (e.block instanceof BlockSapling || e.block instanceof BlockBush && e.block != Blocks.field_150330_I) {
                    e.setCanceled(true);
                    e.world.func_147449_b(e.x, e.y, e.z, (Block)Blocks.field_150330_I);
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        EntityPlayer player;
        if (event.entityLiving instanceof EntityPlayer && !event.entityLiving.field_70170_p.func_82736_K().func_82766_b("keepInventory") && GSEventHandler.consumeItemStack(player = (EntityPlayer)event.entityLiving, (IInventory)player.field_71071_by, new ItemStack(GSItems.BasicItems, 1, 17))) {
            InventoryPlayer keepInventory = new InventoryPlayer(null);
            this.keepAllArmor(player, keepInventory);
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                keepInventory.field_70462_a[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70462_a[i]);
                player.field_71071_by.field_70462_a[i] = null;
            }
            keepInventory.func_70437_b(new ItemStack(GSItems.BasicItems, 1, 17));
            this.playerKeepsMap.put(player.func_70005_c_(), keepInventory);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            int i;
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            for (i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
                if (keepInventory.field_70460_b[i] == null) continue;
                player.field_71071_by.field_70460_b[i] = keepInventory.field_70460_b[i];
            }
            for (i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                if (keepInventory.field_70462_a[i] == null) continue;
                player.field_71071_by.field_70462_a[i] = keepInventory.field_70462_a[i];
            }
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onPlanetDecorated(GCCoreEventPopulate.Post event) {
        if (event.worldObj.field_73011_w instanceof WorldProviderMoon) {
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.Ores, 4, 2, true, GCBlocks.blockMoon, 4), 3, 4, 18);
        }
        if (event.worldObj.field_73011_w instanceof WorldProviderMars) {
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 4, 0, true, MarsBlocks.marsBlock, 9), 2, 4, 18);
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 6, 1, true, MarsBlocks.marsBlock, 9), 10, 6, 30);
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 16, 2, true, MarsBlocks.marsBlock, 9), 15, 6, 70);
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 10, 3, true, MarsBlocks.marsBlock, 9), 10, 6, 20);
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 8, 4, true, MarsBlocks.marsBlock, 9), 4, 6, 20);
            this.genOre(event.worldObj, event.chunkX, event.chunkZ, (WorldGenerator)new WorldGenMinableMeta(GSBlocks.MarsOresBlocks, 6, 5, true, MarsBlocks.marsBlock, 9), 16, 6, 45);
        }
    }

    void genOre(World world, int chunkX, int chunkZ, WorldGenerator wg, int amountPerChunk, int minY, int maxY) {
        int posX = chunkX + world.field_73012_v.nextInt(16);
        int posZ = chunkZ + world.field_73012_v.nextInt(16);
        int posY = world.field_73012_v.nextInt(maxY - minY) + minY;
        for (int i = 0; i < amountPerChunk; ++i) {
            wg.func_76484_a(world, world.field_73012_v, posX, posY, posZ);
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        EntityPlayer player = event.player;
        if (this.playerKeepsMap.containsKey(player.func_70005_c_())) {
            InventoryPlayer keepInventory = this.playerKeepsMap.get(player.func_70005_c_());
            keepInventory.field_70458_d = player;
            keepInventory.func_70436_m();
            this.playerKeepsMap.remove(player.func_70005_c_());
        }
    }

    private void keepAllArmor(EntityPlayer player, InventoryPlayer keepInventory) {
        for (int i = 0; i < player.field_71071_by.field_70460_b.length; ++i) {
            keepInventory.field_70460_b[i] = ItemStack.func_77944_b((ItemStack)player.field_71071_by.field_70460_b[i]);
            player.field_71071_by.field_70460_b[i] = null;
        }
    }

    @SubscribeEvent
    public void onEntityAttack(LivingHurtEvent event) {
        EntityPlayer player;
        ItemStack stack;
        if (event.entityLiving instanceof EntityPlayer && (stack = (player = (EntityPlayer)event.entityLiving).func_70694_bm()) != null && stack.func_77973_b() == GSItems.AncientSword && stack.func_77942_o() && stack.func_77978_p().func_74767_n(ItemAncientSword.charge) && player.func_71039_bw()) {
            EntityLivingBase base = (EntityLivingBase)event.source.func_76346_g();
            int i = 5;
            base.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
            double x = base.field_70165_t;
            double y = base.field_70163_u;
            double z = base.field_70161_v;
            for (int k = 0; k < 10; ++k) {
                GalaxySpace.proxy.spawnParticle("waterbubbles", new Vector3(x + base.field_70170_p.field_73012_v.nextDouble(), y + base.field_70170_p.field_73012_v.nextDouble(), z + base.field_70170_p.field_73012_v.nextDouble()), new Vector3(-0.03, 0.0, -0.03), new Object[]{10, (int)(Math.random() * 8.0), false, new Vector3((double)0.8f, 0.0, 0.0), 1.0});
            }
            stack.func_77978_p().func_74757_a(ItemAncientSword.charge, false);
        }
    }

    @SubscribeEvent
    public void onEntityInteract(EntityInteractEvent event) {
        EntityAlienVillager villager;
        if (!event.entityPlayer.func_130014_f_().field_72995_K && event.target instanceof EntityAlienVillager && GSConfigCore.enableAlienTradeSystem && !(villager = (EntityAlienVillager)event.target).func_70631_g_()) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
            GCPlayerStats stats = GCPlayerStats.get((EntityPlayerMP)player);
            if (stats.frequencyModuleInSlot == null && !player.field_71075_bZ.field_75098_d) {
                player.func_146105_b((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_RED + StatCollector.func_74838_a((String)"gui.message.needfrequencyModule")));
            } else {
                event.entityPlayer.openGui((Object)"GalaxySpace", 10, event.entityPlayer.func_130014_f_(), 0, 0, 0);
            }
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.world;
        MovingObjectPosition pos = event.target;
        Block block = world.func_147439_a(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        int meta = world.func_72805_g(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
        if (event.current.func_77973_b() == Items.field_151133_ar) {
            if (block == GSFluids.BlockHeliumHydrogen && meta == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                event.result = new ItemStack(GSItems.HeliumHydrogenBucket, 1, 0);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == GSFluids.BlockLiquidMethane && meta == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                event.result = new ItemStack(GSItems.EthaneMethaneBucket, 1, 0);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == GSFluids.BlockSulfurAcid && meta == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                event.result = new ItemStack(GSItems.SulfurAcidBucket, 1, 0);
                event.setResult(Event.Result.ALLOW);
            }
            if (block == Blocks.field_150432_aD && meta == 0) {
                world.func_147468_f(pos.field_72311_b, pos.field_72312_c, pos.field_72309_d);
                event.result = new ItemStack(GSItems.IceBucket, 1, 0);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void onThermalArmorEvent(GCPlayerHandler.ThermalArmorEvent event) {
        if (event.armorStack == null) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.REMOVE);
            return;
        }
        if (event.armorStack.func_77973_b() == GSItems.ThermalPaddingTier2 && event.armorStack.func_77960_j() == event.armorIndex) {
            event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.ADD);
            return;
        }
        event.setArmorAddResult(GCPlayerHandler.ThermalArmorEvent.ArmorAddResult.NOTHING);
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.entityLiving;
        World world = living.field_70170_p;
        if (living instanceof EntityPlayer) {
            double umot = 0.085;
            ItemStack chest = ((EntityPlayer)living).func_82169_q(2);
            if (chest != null && chest.func_77973_b() instanceof IJetpack && !((EntityPlayer)living).field_70122_E && ((IJetpack)chest.func_77973_b()).canFly(chest, (EntityPlayer)living) && ((IJetpack)chest.func_77973_b()).isActivated(chest) && ((EntityPlayer)living).field_70163_u < 256.0) {
                ((EntityPlayer)living).field_70143_R = 0.0f;
                ((EntityPlayer)living).field_70140_Q = 0.6f;
                GalaxySpace.proxy.resetPlayerInAirTime((EntityPlayer)living);
                ((IJetpack)chest.func_77973_b()).decrementFuel(chest);
            }
            EntityPlayer player = (EntityPlayer)living;
            if (player.field_70170_p.field_73011_w instanceof WorldProviderKuiper && player.field_70163_u <= 0.0) {
                player.func_70107_b(player.field_70165_t, 300.0, player.field_70161_v);
            }
            GSLightningStormHandler.spawnLightning(player);
        }
        if (living instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)living;
            GCPlayerStats GCPlayer = GCPlayerStats.get((EntityPlayerMP)player);
            AchEvent.onEntityUpdate(event);
            if (GCPlayer.usingPlanetSelectionGui && GSConfigCore.enableNewGalaxyMap) {
                this.sendPlanetList(player, GCPlayer);
            }
            if (player.field_70154_o instanceof EntityLanderBase) {
                EntityLanderBase lander = (EntityLanderBase)player.field_70154_o;
                if (GCPlayer.spaceshipTier >= 5 && lander.fuelTank.getFluid() != null && lander.fuelTank.getFluid().getFluid() == GalacticraftCore.fluidFuel) {
                    lander.fuelTank.setFluid(new FluidStack(GSFluids.HeliumHydrogen, lander.fuelTank.getFluidAmount()));
                }
            }
            if (player.field_70173_aa % 20 == 0 && player.func_70694_bm() != null && player.field_71071_by.func_70448_g().func_77973_b() == GSItems.BasicItems && player.field_71071_by.func_70448_g().func_77960_j() == 13) {
                player.func_70015_d(1);
            }
            ItemStack stack = player.func_82169_q(3);
            IInventoryGC inv = AccessInventoryGC.getGCInventoryForPlayer((EntityPlayerMP)player);
            if (stack != null && stack.func_77973_b() == GSItems.SpacesuitHelmet && player.func_70090_H()) {
                int air;
                int count = 150;
                if (inv.func_70301_a(2) != null) {
                    if (inv.func_70301_a(2).func_77960_j() != inv.func_70301_a(2).func_77958_k() && (air = player.func_70086_ai()) < count) {
                        player.func_70050_g(air + count);
                        inv.func_70301_a(2).func_77964_b(inv.func_70301_a(2).func_77960_j() + 1);
                    }
                } else if (inv.func_70301_a(2) == null && inv.func_70301_a(3) != null && inv.func_70301_a(3).func_77960_j() != inv.func_70301_a(3).func_77958_k() && (air = player.func_70086_ai()) < count) {
                    player.func_70050_g(air + count);
                    inv.func_70301_a(3).func_77964_b(inv.func_70301_a(3).func_77960_j() + 1);
                }
                if (inv.func_70301_a(2) != null && inv.func_70301_a(3) != null && inv.func_70301_a(2).func_77960_j() == inv.func_70301_a(2).func_77958_k() && inv.func_70301_a(3).func_77960_j() != inv.func_70301_a(3).func_77958_k() && (air = player.func_70086_ai()) < count) {
                    player.func_70050_g(air + count);
                    inv.func_70301_a(3).func_77964_b(inv.func_70301_a(3).func_77960_j() + 1);
                }
            }
            if (player.field_70173_aa % 10 == 0) {
                player.func_110148_a(GSAttributePlayer.OXTANKS_LEFT).func_111126_e();
                player.func_110148_a(GSAttributePlayer.OXTANKS_RIGHT).func_111126_e();
                for (int i = 2; i <= 3; ++i) {
                    IAttribute tank;
                    if (inv.func_70301_a(i) == null) continue;
                    IAttribute iAttribute = tank = i == 2 ? GSAttributePlayer.OXTANKS_LEFT : GSAttributePlayer.OXTANKS_RIGHT;
                    if (inv.func_70301_a(i).func_77973_b() instanceof ItemGSOxygenTank) {
                        ItemGSOxygenTank item = (ItemGSOxygenTank)inv.func_70301_a(i).func_77973_b();
                        player.func_110148_a(tank).func_111128_a((double)item.getTier());
                        if (!item.getEPP() || !(player.field_70170_p.field_73011_w instanceof WorldProviderSurface) && (!(player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || !((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).hasBreathableAtmosphere()) && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player) && !OxygenUtil.inOxygenBubble((World)world, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v)) continue;
                        inv.func_70301_a(i).func_77964_b(inv.func_70301_a(i).func_77960_j() - 1);
                        continue;
                    }
                    player.func_110148_a(tank).func_111128_a(0.0);
                }
            }
            this.doRadiationForEntity(world, (EntityLivingBase)player);
            this.doPressureForEntity(world, player);
            if (GSConfigCore.enableSolarRadiationSystem) {
                this.applyRadiation(world, player);
            }
        }
        if (living instanceof EntityPlayer && living.field_70170_p.field_73011_w instanceof WorldProviderTCetiF && living.func_70090_H()) {
            this.applyReverseWaterMovement(living);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void applyRadiation(World world, EntityPlayerMP player) {
        float j;
        boolean solar;
        if (!(player.field_70170_p.field_73011_w instanceof IAdvancedSpace)) {
            if (!(player.field_70170_p.field_73011_w instanceof WorldProviderMoon)) return;
        }
        IAttributeInstance lvl = player.func_110148_a(GSAttributePlayer.RADIATION_LVL);
        boolean bl = solar = player.field_70170_p.field_73011_w instanceof WorldProviderMoon ? true : ((IAdvancedSpace)player.field_70170_p.field_73011_w).SolarRadiation();
        if (!solar && player.field_70173_aa % 600 == 0 && lvl.func_111126_e() > 0.0) {
            lvl.func_111128_a(lvl.func_111126_e() - 1.0);
        }
        if (player.field_70173_aa % Math.round(j = 10.0f) != 0) return;
        if (!player.field_71075_bZ.field_75098_d && solar) {
            if (!CompatibilityManager.isAndroid((EntityPlayer)player)) {
                if (!GSEventHandler.getRadiationArmor(player)) {
                    if (!GSEventHandler.getProtectArmor((EntityPlayer)player)) {
                        if (!GSEventHandler.inRadiationBubble(world, player.field_70165_t, player.field_70163_u, player.field_70161_v)) {
                            if (!(lvl.func_111126_e() < 58.0)) return;
                            if (!player.field_70170_p.func_72935_r()) return;
                            if (!(player.field_70163_u > (double)(player.field_70170_p.func_72825_h((int)player.field_70165_t, (int)player.field_70161_v) - 1))) return;
                            lvl.func_111128_a(lvl.func_111126_e() + 1.0);
                            return;
                        }
                    }
                }
            }
            if (!(lvl.func_111126_e() > 45.0)) return;
            lvl.func_111128_a(lvl.func_111126_e() - 1.0);
            return;
        }
        lvl.func_111128_a(0.0);
    }

    private void doRadiationForEntity(World world, EntityLivingBase living) {
        block5: {
            EntityPlayerMP player;
            block8: {
                block7: {
                    block6: {
                        player = (EntityPlayerMP)living;
                        IAttributeInstance lvl = player.func_110148_a(GSAttributePlayer.RADIATION_LVL);
                        if (!(lvl.func_111126_e() > 45.0)) break block5;
                        WorldProvider provider = player.field_70170_p.field_73011_w;
                        if (!(living.field_70163_u <= 1000.0)) break block5;
                        if (living instanceof EntityPlayer) break block6;
                        if (living.field_70173_aa % 100 == 0 && !(living instanceof IEntityLivingData) && living.getClass() != EntityEvolvedZombie.class && living.getClass() != EntityEvolvedSpider.class && living.getClass() != EntityEvolvedSkeleton.class && living.getClass() != EntityEvolvedCreeper.class) {
                            living.func_70690_d(new PotionEffect(GSPotions.radiation.field_76415_H, 80));
                        }
                        break block5;
                    }
                    if (!(living instanceof EntityPlayerMP)) break block5;
                    if (player.field_70173_aa % 20 != 0 || player.field_71075_bZ.field_75098_d) break block7;
                    if (GSEventHandler.inRadiationBubble(world, player.field_70165_t, player.field_70163_u, player.field_70161_v)) break block7;
                    player.func_70690_d(new PotionEffect(GSPotions.radiation.field_76415_H, 80));
                    break block5;
                }
                if (GSEventHandler.getRadiationArmor(player)) break block8;
                if (GSEventHandler.getProtectArmor((EntityPlayer)player)) break block8;
                if (!GSEventHandler.inRadiationBubble(world, player.field_70165_t, player.field_70163_u, player.field_70161_v)) break block5;
            }
            player.func_82170_o(GSPotions.radiation.field_76415_H);
        }
    }

    public void doPressureForEntity(World world, EntityPlayerMP player) {
        if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
            IAdvancedSpace provider = (IAdvancedSpace)player.field_70170_p.field_73011_w;
            int level = provider.AtmosphericPressure();
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = player.func_82169_q(i);
                if (player.field_71075_bZ.field_75098_d) continue;
                if (stack != null) {
                    if (stack.func_77973_b() instanceof IItemPressurized) continue;
                    if (GSEventHandler.getProtectArmor((EntityPlayer)player)) continue;
                }
                if (GSEventHandler.inGravityZone(world, (EntityPlayer)player, true) || player.field_70173_aa % 50 != 0 || CompatibilityManager.isAndroid((EntityPlayer)player)) continue;
                if (level > 10) {
                    player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200));
                }
                if (level > 35) {
                    player.func_70690_d(new PotionEffect(Potion.field_76440_q.field_76415_H, 200));
                }
                if (level > 25) {
                    player.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 280, 4));
                }
                if (level <= 45) continue;
                player.func_70097_a((DamageSource)GSDamageSource.pressure, 2.5f);
            }
        }
    }

    public static boolean getRadiationArmor(EntityPlayerMP player) {
        boolean armor1 = player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() instanceof IItemRadiation;
        boolean armor2 = player.func_82169_q(1) != null && player.func_82169_q(1).func_77973_b() instanceof IItemRadiation;
        boolean armor3 = player.func_82169_q(2) != null && player.func_82169_q(2).func_77973_b() instanceof IItemRadiation;
        boolean armor4 = player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() instanceof IItemRadiation;
        return armor1 && armor2 && armor3 && armor4;
    }

    private void changeBlocks(World world, int x, int y, int z) {
        float thermal = ((IGalacticraftWorldProvider)world.field_73011_w).getThermalLevelModifier();
        AxisAlignedBB bb = AxisAlignedBB.func_72330_a((double)(x - 1), (double)(y - 1), (double)(z - 1), (double)(x + 1), (double)(y + 1), (double)(z + 1));
        if (!OxygenUtil.isAABBInBreathableAirBlock((World)world, (AxisAlignedBB)bb, (boolean)true)) {
            if (world.func_147439_a(x, y, z) == Blocks.field_150355_j && world.func_72805_g(x, y, z) == 0) {
                world.func_147465_d(x, y, z, Blocks.field_150432_aD, 0, 3);
            } else if (world.func_147439_a(x, y, z) instanceof BlockSapling || world.func_147439_a(x, y, z) instanceof BlockBush && world.func_147439_a(x, y, z) != Blocks.field_150330_I) {
                world.func_147465_d(x, y, z, (Block)Blocks.field_150330_I, 0, 3);
            } else if (world.func_147439_a(x, y, z) instanceof BlockLeavesBase) {
                world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
            }
        }
    }

    private void sendMessage(EntityPlayer player, String message, int countdown) {
        player.func_146105_b((IChatComponent)new ChatComponentText(message));
    }

    private void applyReverseWaterMovement(EntityLivingBase entity) {
        int j1;
        AxisAlignedBB par1AxisAlignedBB = entity.field_70121_D.func_72314_b(0.0, (double)-0.4f, 0.0).func_72331_e(0.001, 0.001, 0.001);
        int i = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72340_a);
        int j = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72338_b);
        int l = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)par1AxisAlignedBB.field_72339_c);
        if (!entity.field_70170_p.func_72904_c(i, k, i1, j, l, j1 = MathHelper.func_76128_c((double)(par1AxisAlignedBB.field_72334_f + 1.0)))) {
            return;
        }
        boolean flag = false;
        Vec3 vec3 = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    double d0;
                    Block block = entity.field_70170_p.func_147439_a(k1, l1, i2);
                    if (block == null || block.func_149688_o() != Material.field_151586_h || !((double)l >= (d0 = (double)((float)(l1 + 1) - BlockLiquid.func_149801_b((int)entity.field_70170_p.func_72805_g(k1, l1, i2)))))) continue;
                    flag = true;
                    block.func_149640_a(entity.field_70170_p, k1, l1, i2, (Entity)entity, vec3);
                }
            }
        }
        if (vec3.func_72433_c() > 0.0 && entity.func_70090_H()) {
            vec3 = vec3.func_72432_b();
            double d1 = -0.014;
            entity.field_70159_w += vec3.field_72450_a * d1;
            entity.field_70181_x += vec3.field_72448_b * d1;
            entity.field_70179_y += vec3.field_72449_c * d1;
        }
    }

    public static boolean consumeItemStack(EntityPlayer player, IInventory inventory, ItemStack stack) {
        if (GSEventHandler.getAmount(inventory, stack) >= stack.field_77994_a) {
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
                int amount = Math.min(stack.field_77994_a, inventory.func_70301_a((int)i).field_77994_a);
                if (amount > 0) {
                    inventory.func_70301_a((int)i).field_77994_a -= amount;
                    if (inventory.func_70301_a((int)i).field_77994_a <= 0) {
                        inventory.func_70299_a(i, null);
                    }
                    stack.field_77994_a -= amount;
                    player.field_71069_bz.func_75142_b();
                }
                if (stack.field_77994_a > 0) continue;
                return true;
            }
        }
        return false;
    }

    public static int getAmount(IInventory inventory, ItemStack stack) {
        int amount = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!GSEventHandler.isItemStackEqual(inventory.func_70301_a(i), stack)) continue;
            amount += inventory.func_70301_a((int)i).field_77994_a;
        }
        return amount;
    }

    public static boolean isItemStackEqual(ItemStack stack1, ItemStack stack2) {
        if (stack2.func_77960_j() == Short.MAX_VALUE) {
            return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b();
        }
        return stack1 != null && stack2 != null && stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j();
    }

    public static ItemStack changeStackItem(ItemStack stack, Item item) {
        ItemStack newStack = new ItemStack(item);
        newStack.func_77964_b(stack.func_77960_j());
        newStack.field_77990_d = stack.field_77990_d;
        return newStack;
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats playerStats) {
        Collections.sort(playerStats.unlockedSchematics);
        if (player.field_71135_a != null && (playerStats.unlockedSchematics.size() != playerStats.lastUnlockedSchematics.size() || (player.field_70173_aa - 1) % 100 == 0)) {
            Integer[] iArray = new Integer[playerStats.unlockedSchematics.size()];
            for (int i = 0; i < iArray.length; ++i) {
                ISchematicPage page = (ISchematicPage)playerStats.unlockedSchematics.get(i);
                iArray[i] = page == null ? -2 : page.getPageID();
            }
            ArrayList<Integer[]> objList = new ArrayList<Integer[]>();
            objList.add(iArray);
            GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, objList), player);
        }
    }

    protected void sendPlanetList(EntityPlayerMP player, GCPlayerStats playerStats) {
        HashMap map = player.field_70173_aa % 50 == 0 ? WorldUtil.getArrayOfPossibleDimensions((int)playerStats.spaceshipTier, (EntityPlayerMP)player) : WorldUtil.getArrayOfPossibleDimensionsAgain((int)playerStats.spaceshipTier, (EntityPlayerMP)player);
        String temp = "";
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            temp = temp.concat((String)entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        if (!temp.equals(playerStats.savedPlanetList) || player.field_70173_aa % 1 == 0) {
            Integer[] ints = new Integer[]{playerStats.spaceshipTier, playerStats.fuelLevel};
            GalaxySpace.packetPipeline.sendTo(new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.C_UPDATE_DIMENSION_LIST, player.func_146103_bH().getName(), temp, ints), player);
            playerStats.savedPlanetList = new String(temp);
        }
    }

    protected void throwMeteors(EntityPlayerMP player) {
        EntityPlayer closestPlayer;
        int f;
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IAdvancedSpace && !world.field_72995_K && ((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0 && world.field_73012_v.nextInt(f = (int)(((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() * 1000.0 * (1.0 / ConfigManagerCore.meteorSpawnMod))) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
            int x = world.field_73012_v.nextInt(1) - 8;
            int y = world.field_73012_v.nextInt(20) + 200;
            int z = world.field_73012_v.nextInt(1) - 8;
            double motX = world.field_73012_v.nextDouble() * 1.0;
            double motZ = world.field_73012_v.nextDouble() * 1.0;
            GSEntityMeteor meteor = new GSEntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 0.5, 0.0, motZ - 0.5, 6);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)meteor);
            }
        }
    }

    public static void enableFlight(EntityPlayer player, boolean state) {
        ItemStack chest = player.func_82169_q(2);
        if (chest != null && chest.func_77973_b() instanceof IJetpack) {
            ((IJetpack)chest.func_77973_b()).switchState(chest, state);
        }
    }

    public static boolean inGravityZone(World world, EntityPlayer player, boolean checkPressureModule) {
        for (BlockVec3Dim blockVec : TileEntityGravitationModule.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.field_76574_g || !((tile = world.func_147438_o(blockVec.x, blockVec.y, blockVec.z)) instanceof TileEntityGravitationModule)) continue;
            TileEntityGravitationModule gravity = (TileEntityGravitationModule)tile;
            if (gravity.disabled || !gravity.hasEnoughEnergyToRun || !gravity.inGravityZone(world, player)) continue;
            if (checkPressureModule && gravity.func_70301_a(1) != null) {
                return true;
            }
            if (checkPressureModule) continue;
            return true;
        }
        return false;
    }

    public static boolean inRadiationBubble(World world, double avgX, double avgY, double avgZ) {
        for (BlockVec3Dim blockVec : TileEntityRadiationStabiliser.loadedTiles) {
            TileEntity tile;
            if (blockVec == null || blockVec.dim != world.field_73011_w.field_76574_g || !((tile = world.func_147438_o(blockVec.x, blockVec.y, blockVec.z)) instanceof TileEntityRadiationStabiliser) || !((TileEntityRadiationStabiliser)tile).inBubble(avgX, avgY, avgZ)) continue;
            return true;
        }
        return false;
    }

    public static boolean getProtectArmor(EntityPlayer player) {
        boolean[] check = new boolean[4];
        for (String string : GSConfigCore.protect_armor) {
            Item item;
            String prefix;
            int i;
            String[] meta = string.split(":");
            if (meta.length > 2) {
                for (i = 0; i < 4; ++i) {
                    prefix = meta[0];
                    item = GameRegistry.findItem((String)prefix, (String)meta[1]);
                    int metadata = Integer.parseInt(meta[2]);
                    boolean bl = check[i] = item != null && player.field_71071_by.field_70460_b[i] != null && player.field_71071_by.field_70460_b[i].func_77973_b() == item && player.field_71071_by.field_70460_b[i].func_77960_j() == metadata;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < 4; ++i) {
                    prefix = meta.length == 1 ? "minecraft" : meta[0];
                    item = GameRegistry.findItem((String)prefix, (String)meta[1]);
                    boolean bl = check[i] = item != null && player.field_71071_by.field_70460_b[i] != null && player.field_71071_by.field_70460_b[i].func_77973_b() == item;
                    if (!check[i]) {
                        continue;
                    }
                    break;
                }
            }
            if (check[0] && check[1] && check[2] && check[3]) break;
        }
        return check[0] && check[1] && check[2] && check[3];
    }
}

