/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.events;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.GalaxySpace;
import galaxyspace.api.dimension.IAdvancedSpace;
import galaxyspace.api.item.IJetpack;
import galaxyspace.core.client.gui.GSGuiMainMenu;
import galaxyspace.core.client.gui.GSGuiUpdate;
import galaxyspace.core.client.gui.overlay.OverlayDetectors;
import galaxyspace.core.client.gui.overlay.OverlaySpaceSuit;
import galaxyspace.core.client.gui.screen.GSGuiCelestialSelection;
import galaxyspace.core.client.models.ModelOxygenTank;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.handler.GSColorRingClient;
import galaxyspace.core.network.packet.GSPacketSimple;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.util.GSAttributePlayer;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.core.world.gen.WorldProviderAdvancedSpace;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.WorldProviderTitan_WE;
import galaxyspace.systems.SolarSystem.moons.titan.dimension.sky.CloudProviderTitan;
import galaxyspace.systems.SolarSystem.planets.ceres.gui.GSGuiRocketInventory;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier4Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.items.armor.ItemSpaceArmors;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.WorldProviderVenus;
import galaxyspace.systems.SolarSystem.planets.venus.dimension.sky.CloudProviderVenus;
import java.util.Iterator;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IDetectableResource;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiRocketInventory;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.proxy.ClientProxyCore;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.wrappers.BlockMetaList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import org.lwjgl.opengl.GL11;

public class GSClientTickHandler {
    public static Minecraft mc = FMLClientHandler.instance().getClient();
    public Random rand;
    private static boolean toggleFlight;
    double urmot = 0.015;
    double ufmot = -0.015;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.gui instanceof GuiMainMenu && GSConfigCore.enableNewMenu) {
            event.gui = new GSGuiMainMenu();
        }
        if (event.gui instanceof GuiRocketInventory && mc.field_71439_g.field_70154_o instanceof EntityTier4Rocket) {
            event.gui = new GSGuiRocketInventory((IInventory)mc.field_71439_g.field_71071_by, (IInventory)((EntityTier4Rocket)mc.field_71439_g.field_70154_o), ((EntityTier4Rocket)mc.field_71439_g.field_70154_o).getType());
        }
        if (event.gui instanceof GuiCelestialSelection && GSConfigCore.enableNewGalaxyMap) {
            GameSettings cfr_ignored_0 = mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.gui = new GSGuiCelestialSelection(true, null, null);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        WorldClient world = GSClientTickHandler.mc.field_71441_e;
        if (event.phase == TickEvent.Phase.START) {
            if (!mc.func_147113_T()) {
                CloudProviderVenus.cloudTickCounter += 3;
                ++CloudProviderTitan.cloudTickCounter;
            }
            if (player != null && player.field_71071_by.func_70440_f(3) != null && player.field_71071_by.func_70440_f(3).func_77973_b() instanceof ItemSpaceArmors) {
                ClientProxyCore.valueableBlocks.clear();
                for (int i = -4; i < 5; ++i) {
                    int x = MathHelper.func_76128_c((double)(player.field_70165_t + (double)i));
                    for (int j = -4; j < 5; ++j) {
                        int y = MathHelper.func_76128_c((double)(player.field_70163_u + (double)j));
                        for (int k = -4; k < 5; ++k) {
                            int z = MathHelper.func_76128_c((double)(player.field_70161_v + (double)k));
                            Block block = player.field_70170_p.func_147439_a(x, y, z);
                            if (block.func_149688_o() == Material.field_151579_a) continue;
                            int metadata = world.func_72805_g(x, y, z);
                            boolean isDetectable = false;
                            for (BlockMetaList blockMetaList : ClientProxyCore.detectableBlocks) {
                                if (blockMetaList.getBlock() != block || !blockMetaList.getMetaList().contains(metadata)) continue;
                                isDetectable = true;
                                break;
                            }
                            if (!isDetectable && (!(block instanceof IDetectableResource) || !((IDetectableResource)block).isValueable(metadata))) continue;
                            ClientProxyCore.valueableBlocks.add(new BlockVec3(x, y, z));
                        }
                    }
                }
            }
        }
        if (world != null && world.field_73011_w instanceof WorldProviderVenus && world.func_72912_H().func_76059_o()) {
            world.func_72894_k(1.5f);
        }
        if (world != null && (world.field_73011_w instanceof WorldProviderTitan || world.field_73011_w instanceof WorldProviderTitan_WE) && world.func_72912_H().func_76059_o()) {
            world.func_72894_k(1.0f);
        }
        if (event.phase == TickEvent.Phase.END && Side.CLIENT != null && player != null && world != null) {
            ItemStack chest = player.func_82169_q(2);
            if (chest != null && chest.func_77973_b() instanceof IJetpack && ((IJetpack)chest.func_77973_b()).canFly(chest, (EntityPlayer)GSClientTickHandler.mc.field_71439_g) && ((IJetpack)chest.func_77973_b()).isActivated(chest) && !player.field_70122_E) {
                GalaxySpace.proxy.showJetpackParticles((World)GSClientTickHandler.mc.field_71441_e, (EntityLivingBase)player, ((IJetpack)chest.func_77973_b()).getFireStreams(chest));
            }
            if (GSConfigCore.enableCheckVersion && GSThreadVersionCheck.newversion && GSClientTickHandler.mc.field_71415_G) {
                GSThreadVersionCheck.newversion = false;
                GSGuiUpdate gui = new GSGuiUpdate();
                FMLClientHandler.instance().showGuiScreen((Object)gui);
            }
        }
    }

    private static void tickEnd() {
        if (!mc.func_147113_T()) {
            if (GSClientTickHandler.mc.field_71441_e.field_73010_i.isEmpty()) {
                GSClientTickHandler.mc.field_71441_e.field_73010_i.add(GSClientTickHandler.mc.field_71439_g);
            }
            Iterator itr = GSClientTickHandler.mc.field_71441_e.field_73010_i.iterator();
            while (itr.hasNext()) {
                EntityPlayer player = (EntityPlayer)itr.next();
                if (player == null || player.field_71093_bK != GSClientTickHandler.mc.field_71439_g.field_71093_bK) {
                    itr.remove();
                    continue;
                }
                ItemStack chest = player.func_82169_q(2);
                if (chest != null && chest.func_77973_b() instanceof IJetpack && ((IJetpack)chest.func_77973_b()).canFly(chest, (EntityPlayer)GSClientTickHandler.mc.field_71439_g) && ((IJetpack)chest.func_77973_b()).isActivated(chest) && !player.field_70122_E) {
                    GalaxySpace.proxy.showJetpackParticles((World)GSClientTickHandler.mc.field_71441_e, (EntityLivingBase)player, ((IJetpack)chest.func_77973_b()).getFireStreams(chest));
                    continue;
                }
                itr.remove();
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRender(RenderPlayerEvent.Specials.Post event) {
        GSColorRingClient.onPostRender(event);
        EntityPlayer player = event.entityPlayer;
        if (player != null) {
            double tex;
            ModelOxygenTank tank = new ModelOxygenTank();
            GL11.glPushMatrix();
            GL11.glDisable((int)3042);
            if (player.func_110148_a(GSAttributePlayer.OXTANKS_LEFT).func_111125_b() > 0.0) {
                tex = player.func_110148_a(GSAttributePlayer.OXTANKS_LEFT).func_111125_b() + 1.0;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(GalaxySpace.ASSET_PREFIX + ":textures/model/oxTank" + (int)tex + ".png"));
                tank.renderLeft(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            if (player.func_110148_a(GSAttributePlayer.OXTANKS_RIGHT).func_111125_b() > 0.0) {
                tex = player.func_110148_a(GSAttributePlayer.OXTANKS_RIGHT).func_111125_b() + 1.0;
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation(GalaxySpace.ASSET_PREFIX + ":textures/model/oxTank" + (int)tex + ".png"));
                tank.renderRight(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
            }
            GL11.glEnable((int)3042);
            GL11.glPopMatrix();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = minecraft.field_71439_g;
        int level = 0;
        if (event.phase == TickEvent.Phase.END) {
            if (player != null) {
                if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui((GuiScreen)minecraft.field_71462_r)) {
                    if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                        IAdvancedSpace provider = (IAdvancedSpace)player.field_70170_p.field_73011_w;
                        level = Math.round(provider.AtmosphericPressure() / 4);
                    }
                    OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(GSAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                }
                if (GSConfigCore.enableSpaceSuitHUD) {
                    // empty if block
                }
                if (minecraft.field_71415_G && GalaxySpace.debug) {
                    boolean isSpace = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider;
                    long t1 = player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? ((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength() : 24000L;
                    long time = player.field_70170_p.func_72820_D() % (t1 > 0L ? t1 : 1L);
                    String[] s = new String[]{"GalaxySpace 1.2.15 Pre-Final DEBUG Mode", "MC Version: 1.7.10", "Celestial Body: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)player.func_130014_f_().field_73011_w).getCelestialBody().getLocalizedName() : "Unnamed"), "", "Player Data:", "Username: " + player.func_70005_c_(), "X: " + (int)player.field_70165_t, "Y: " + (int)player.field_70163_u, "Z: " + (int)player.field_70161_v, "Current Item: " + (player.field_71071_by.func_70448_g() != null ? GameData.getItemRegistry().func_148750_c((Object)player.field_71071_by.func_70448_g().func_77973_b()) + ":" + player.field_71071_by.func_70448_g().func_77960_j() : "None"), "", "World Data:", "Dimension: " + player.field_70170_p.field_73011_w.func_80007_l() + " (ID: " + player.field_70170_p.field_73011_w.field_76574_g + ")", "Gravity: " + (isSpace ? Float.valueOf(((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getGravity()) : "0.085F"), "Biome: " + player.field_70170_p.func_72807_a((int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).field_76791_y + " (ID: " + player.field_70170_p.func_72807_a((int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).field_76756_M + ")", "Current Time: " + time + " | Total Time: " + (player.field_70170_p.field_73011_w instanceof WorldProviderSpace ? Long.valueOf(((WorldProviderSpace)player.field_70170_p.field_73011_w).getDayLength()) : "24000"), "Moon Phase: " + (player.field_70170_p.field_73011_w instanceof WorldProviderAdvancedSpace ? ((WorldProviderAdvancedSpace)player.field_70170_p.field_73011_w).func_76559_b(player.field_70170_p.func_72820_D()) : player.field_70170_p.field_73011_w.func_76559_b(player.field_70170_p.func_72820_D())), "", "Is Galacticraft Provider: " + (player.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? "Yes" : "No"), "Is Advance Space Provider: " + (player.func_130014_f_().field_73011_w instanceof IAdvancedSpace ? "Yes" : "No"), "Is Enable Oregen: " + (GSConfigCore.enableOresGeneration ? "Yes" : "No"), "Is Enable World Engine: " + (GSConfigCore.enableWorldEngine ? "Yes" : "No")};
                    int k = 3;
                    GameSettings cfr_ignored_0 = GSClientTickHandler.mc.field_71474_y;
                    if (GameSettings.func_100015_a((KeyBinding)GSClientTickHandler.mc.field_71474_y.field_74311_E)) {
                        k = s.length;
                    }
                    for (int i = 0; i < k; ++i) {
                        minecraft.field_71466_p.func_78261_a(s[i], 10, 28 + i * 10, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)255));
                    }
                }
                if (minecraft.field_71415_G && !minecraft.field_71474_y.field_74319_N && GSConfigCore.enableSpaceSuitHUD) {
                    OverlaySpaceSuit.renderSpaceSuitOverlay((EntityPlayer)player);
                }
            }
            GL11.glDisable((int)2896);
        }
    }

    private boolean getInvalidLevel(int mode) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityClientPlayerMP player = minecraft.field_71439_g;
        if (mode == 1) {
            int level;
            if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                IAdvancedSpace provider = (IAdvancedSpace)player.field_70170_p.field_73011_w;
                level = provider.AtmosphericPressure();
            } else {
                level = 0;
            }
            if (!(player.field_71075_bZ.field_75098_d || level <= 25 || GSClientTickHandler.getAtmoArmor((EntityPlayer)player) || GSEventHandler.getProtectArmor((EntityPlayer)player) || GSEventHandler.inGravityZone(player.field_70170_p, (EntityPlayer)player, true))) {
                return true;
            }
        } else if (mode == 2 && (int)player.func_110148_a(GSAttributePlayer.RADIATION_LVL).func_111126_e() > 45) {
            return true;
        }
        return false;
    }

    public static boolean getAtmoArmor(EntityPlayer player) {
        boolean armor1 = player.func_82169_q(3) != null && player.func_82169_q(3).func_77973_b() == GSItems.SpacesuitHelmet;
        boolean armor2 = player.func_82169_q(2) != null && player.func_82169_q(2).func_77973_b() == GSItems.SpacesuitPlate;
        boolean armor3 = player.func_82169_q(1) != null && player.func_82169_q(1).func_77973_b() == GSItems.SpacesuitLeg;
        boolean armor4 = player.func_82169_q(0) != null && player.func_82169_q(0).func_77973_b() == GSItems.SpacesuitBoots;
        return armor1 && armor2 && armor3 && armor4;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent e) {
        ItemStack chest;
        if (e.phase == TickEvent.Phase.START && e.side == Side.CLIENT && (chest = e.player.func_82169_q(2)) != null && chest.func_77973_b() instanceof IJetpack && ((IJetpack)chest.func_77973_b()).canFly(chest, e.player)) {
            this.parseKeybindings(e.player);
        }
    }

    private void parseKeybindings(EntityPlayer player) {
        float power = 1.0f;
        double y = player.field_70163_u;
        int worldHeight1 = player.func_130014_f_().func_72800_K();
        int maxFlightHeight1 = (int)((float)worldHeight1 / 1.28f);
        if (y > (double)(maxFlightHeight1 - 25)) {
            if (y > (double)maxFlightHeight1) {
                y = maxFlightHeight1;
            }
            power = (float)((double)power * (((double)maxFlightHeight1 - y) / 25.0));
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d()) {
            player.field_70181_x = Math.min(player.field_70181_x + (double)(power * 0.15f), (double)0.6f);
            GalaxySpace.packetPipeline.sendToServer(new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, true));
        } else {
            GalaxySpace.packetPipeline.sendToServer(new GSPacketSimple(GSPacketSimple.GSEnumSimplePacket.S_CHANGE_FLIGHT_STATE, false));
        }
    }
}

