/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.configs;

import cpw.mods.fml.common.FMLLog;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public class GSConfigEnergy {
    public static boolean loaded;
    static Configuration config;
    public static float coefficientFuelGenerator;
    public static float coefficientNuclearGenerator;
    public static float coefficientSolarWindPanel;
    public static float coefficientSolarPanel;
    public static float coefficientWindTurbine;
    public static float coefficientSpeedRocketAssembly;

    public GSConfigEnergy(File file) {
        if (!loaded) {
            config = new Configuration(file);
            GSConfigEnergy.syncConfig(true);
        }
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!GSConfigEnergy.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("general", "coefficientFuelGenerator", (double)coefficientFuelGenerator);
            prop.comment = "Fuel Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientFuelGenerator").setRequiresMcRestart(true);
            coefficientFuelGenerator = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientNuclearGenerator", (double)coefficientNuclearGenerator);
            prop.comment = "Nuclear Generator power factor";
            prop.setLanguageKey("gc.configgui.coefficientNuclearGenerator").setRequiresMcRestart(true);
            coefficientNuclearGenerator = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarWindPanel", (double)coefficientSolarWindPanel);
            prop.comment = "Solar Wind Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarWindPanel").setRequiresMcRestart(true);
            coefficientSolarWindPanel = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSolarPanel", (double)coefficientSolarPanel);
            prop.comment = "Gybrid Solar Panel power factor";
            prop.setLanguageKey("gc.configgui.coefficientSolarPanel").setRequiresMcRestart(true);
            coefficientSolarPanel = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientWindTurbine", (double)coefficientWindTurbine);
            prop.comment = "Wind Turbine power factor";
            prop.setLanguageKey("gc.configgui.coefficientWindTurbine").setRequiresMcRestart(true);
            coefficientWindTurbine = (float)prop.getDouble();
            propOrder.add(prop.getName());
            prop = config.get("general", "coefficientSpeedRocketAssembly", (double)coefficientSpeedRocketAssembly);
            prop.comment = "Rocket Assembly craft speed factor";
            prop.setLanguageKey("gc.configgui.coefficientSpeedRocketAssembly").setRequiresMcRestart(true);
            coefficientSpeedRocketAssembly = (float)prop.getDouble();
            propOrder.add(prop.getName());
            config.setCategoryPropertyOrder("general", propOrder);
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"GalaxySpace (Energy) has a problem loading it's config", (Object[])new Object[0]);
        }
    }

    static {
        coefficientFuelGenerator = 1.0f;
        coefficientNuclearGenerator = 1.0f;
        coefficientSolarWindPanel = 1.0f;
        coefficientSolarPanel = 1.0f;
        coefficientWindTurbine = 1.0f;
        coefficientSpeedRocketAssembly = 1.0f;
    }
}

