/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.render;

import galaxyspace.core.client.render.block.GSRenderEntityBlock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class FluidRenderer {
    public static final int DISPLAY_STAGES = 50;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    private static final GSRenderEntityBlock.RenderInfo liquidBlock = new GSRenderEntityBlock.RenderInfo();

    private FluidRenderer() {
    }

    public static void onTextureReload() {
        for (int[] ia : flowingRenderCache.values()) {
            for (int i : ia) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        flowingRenderCache.clear();
        for (int[] ia : stillRenderCache.values()) {
            for (int i : ia) {
                GL11.glDeleteLists((int)i, (int)1);
            }
        }
        stillRenderCache.clear();
    }

    public static IIcon getFluidTexture(FluidStack fluidStack, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        return FluidRenderer.getFluidTexture(fluidStack.getFluid(), flowing);
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        FluidRenderer.setGLColorFromInt(color);
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, World world, boolean flowing) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[50];
        if (fluid.getBlock() != null) {
            FluidRenderer.liquidBlock.baseBlock = fluid.getBlock();
            FluidRenderer.liquidBlock.texture = FluidRenderer.getFluidTexture(fluidStack, flowing);
        } else {
            FluidRenderer.liquidBlock.baseBlock = Blocks.field_150355_j;
            FluidRenderer.liquidBlock.texture = FluidRenderer.getFluidTexture(fluidStack, flowing);
        }
        cache.put(fluid, diplayLists);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 50; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRenderer.liquidBlock.minX = 0.01f;
            FluidRenderer.liquidBlock.minY = 0.0;
            FluidRenderer.liquidBlock.minZ = 0.01f;
            FluidRenderer.liquidBlock.maxX = 0.99f;
            FluidRenderer.liquidBlock.maxY = (float)Math.max(s, 1) / 50.0f;
            FluidRenderer.liquidBlock.maxZ = 0.99f;
            GSRenderEntityBlock.INSTANCE.renderBlock(liquidBlock);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        return diplayLists;
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }
}

