/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.client.gui.overlay;

import cpw.mods.fml.client.FMLClientHandler;
import galaxyspace.GalaxySpace;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldProvider;
import org.lwjgl.opengl.GL11;

public class OverlayDetectors {
    private static Minecraft minecraft = FMLClientHandler.instance().getClient();

    public static void renderPressureIndicator(int pressureLevel, boolean invalid, boolean right, boolean top) {
        EntityClientPlayerMP player = OverlayDetectors.minecraft.field_71439_g;
        ResourceLocation guiTexture = new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/gui.png");
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)minecraft, (int)OverlayDetectors.minecraft.field_71443_c, (int)OverlayDetectors.minecraft.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        OverlayDetectors.minecraft.field_71460_t.func_78478_c();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(guiTexture);
        int minLeftX = 0;
        int maxLeftX = 0;
        int minRightX = 0;
        int maxRightX = 0;
        double bottomY = 0.0;
        double topY = 0.0;
        double zLevel = -190.0;
        float texMod = 0.00390625f;
        topY = top ? 0.0 : (double)(height - 70);
        bottomY = OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? topY + 58.5 : topY + 1.5;
        if (right) {
            minLeftX = width - 49;
            maxLeftX = width - 40;
            minRightX = width - 59;
            maxRightX = width - 74;
        } else {
            minLeftX = 10;
            maxLeftX = 29;
            minRightX = 10;
            maxRightX = 49;
        }
        if (pressureLevel > 48) {
            pressureLevel = 48;
        }
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY, 49.0f, 9.0f, 0.0f, 0.0f, 64.0f, 9.0f, false, false, 256.0f, 256.0f);
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 1.0f, pressureLevel, 6.0f, 0.0f, 9.0f, pressureLevel + 14, 6.0f, false, false, 256.0f, 256.0f);
        OverlayDetectors.drawTexturedModalRect(minRightX, (float)bottomY + 3.0f, 50.0f, 9.0f, 0.0f, 15.0f, 64.0f, 9.0f, false, false, 256.0f, 256.0f);
        if (invalid) {
            String value = GCCoreUtil.translate((String)"gui.warning.atmosphericPressure");
            if (right) {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 40 - OverlayDetectors.minecraft.field_71466_p.func_78256_a(value), (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)10, (int)10));
            } else {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 60, (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)10, (int)10));
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glPopMatrix();
    }

    public static void renderRadiationIndicator(int radLevel, boolean invalid, boolean right, boolean top) {
        EntityClientPlayerMP player = OverlayDetectors.minecraft.field_71439_g;
        ResourceLocation guiTexture = new ResourceLocation(GalaxySpace.ASSET_PREFIX, "textures/gui/gui.png");
        ScaledResolution scaledresolution = ClientUtil.getScaledRes((Minecraft)minecraft, (int)OverlayDetectors.minecraft.field_71443_c, (int)OverlayDetectors.minecraft.field_71440_d);
        int width = scaledresolution.func_78326_a();
        int height = scaledresolution.func_78328_b();
        OverlayDetectors.minecraft.field_71460_t.func_78478_c();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(guiTexture);
        int minLeftX = 0;
        int maxLeftX = 0;
        int minRightX = 0;
        int maxRightX = 0;
        double bottomY = 0.0;
        double topY = 0.0;
        double zLevel = -190.0;
        float texMod = 0.00390625f;
        topY = top ? 0.0 : (double)(height - 70);
        bottomY = OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? topY + 10.5 : topY + 1.5;
        if (right) {
            minLeftX = width - 49;
            maxLeftX = width - 40;
            minRightX = width - 79;
            maxRightX = width - (OxygenUtil.noAtmosphericCombustion((WorldProvider)player.field_70170_p.field_73011_w) ? 69 : 9);
        } else {
            minLeftX = 10;
            maxLeftX = 29;
            minRightX = 69;
            maxRightX = 1;
        }
        Tessellator var9 = Tessellator.field_78398_a;
        var9.func_78382_b();
        var9.func_78374_a((double)maxRightX, bottomY + 56.0, zLevel, (double)(65.0f * texMod), (double)(56.0f * texMod));
        var9.func_78374_a((double)(maxRightX + 8), bottomY + 56.0, zLevel, (double)(73.0f * texMod), (double)(56.0f * texMod));
        var9.func_78374_a((double)(maxRightX + 8), bottomY, zLevel, (double)(73.0f * texMod), (double)(0.0f * texMod));
        var9.func_78374_a((double)maxRightX, bottomY, zLevel, (double)(65.0f * texMod), (double)(0.0f * texMod));
        var9.func_78381_a();
        var9.func_78382_b();
        var9.func_78374_a((double)maxRightX, bottomY + 56.0, zLevel, (double)(73.0f * texMod), (double)(56.0f * texMod));
        var9.func_78374_a((double)(maxRightX + 8), bottomY + 56.0, zLevel, (double)(81.0f * texMod), (double)(56.0f * texMod));
        var9.func_78374_a((double)(maxRightX + 8), bottomY + 56.0 - (double)radLevel, zLevel, (double)(81.0f * texMod), (double)((float)(56 - radLevel) * texMod));
        var9.func_78374_a((double)maxRightX, bottomY + 56.0 - (double)radLevel, zLevel, (double)(73.0f * texMod), (double)((float)(56 - radLevel) * texMod));
        var9.func_78381_a();
        if (invalid) {
            String value = GCCoreUtil.translate((String)"gui.warning.solarRadiation");
            if (right) {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX - 22 - OverlayDetectors.minecraft.field_71466_p.func_78256_a(value), (int)bottomY + 14 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)10));
            } else {
                OverlayDetectors.minecraft.field_71466_p.func_78276_b(value, minLeftX + 75, (int)bottomY + 7 - OverlayDetectors.minecraft.field_71466_p.field_78288_b / 2 - 1, ColorUtil.to32BitColor((int)255, (int)255, (int)255, (int)10));
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glPopMatrix();
    }

    public static void drawTexturedModalRect(float x, float y, float width, float height, float u, float v, float uWidth, float vHeight, boolean invertX, boolean invertY, float texSizeX, float texSizeY) {
        double zLevel = -190.0;
        GL11.glShadeModel((int)7424);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        float texModX = 1.0f / texSizeX;
        float texModY = 1.0f / texSizeY;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        float height0 = invertY ? 0.0f : vHeight;
        float height1 = invertY ? vHeight : 0.0f;
        float width0 = invertX ? uWidth : 0.0f;
        float width1 = invertX ? 0.0f : uWidth;
        tessellator.func_78374_a((double)x, (double)(y + height), zLevel, (double)((u + width0) * texModX), (double)((v + height0) * texModY));
        tessellator.func_78374_a((double)(x + width), (double)(y + height), zLevel, (double)((u + width1) * texModX), (double)((v + height0) * texModY));
        tessellator.func_78374_a((double)(x + width), (double)y, zLevel, (double)((u + width1) * texModX), (double)((v + height1) * texModY));
        tessellator.func_78374_a((double)x, (double)y, zLevel, (double)((u + width0) * texModX), (double)((v + height1) * texModY));
        tessellator.func_78381_a();
    }
}

