/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import cpw.mods.fml.relauncher.Side;
import galaxyspace.api.IBodiesHandler;
import galaxyspace.api.IBookPage;
import galaxyspace.api.IPage;
import galaxyspace.core.achievements.AchEvent;
import galaxyspace.core.achievements.AchievementList;
import galaxyspace.core.configs.GSConfigBiomes;
import galaxyspace.core.configs.GSConfigCore;
import galaxyspace.core.configs.GSConfigDimensions;
import galaxyspace.core.configs.GSConfigEnergy;
import galaxyspace.core.configs.GSConfigSchematics;
import galaxyspace.core.events.GSEventHandler;
import galaxyspace.core.handler.GSFuelHandler;
import galaxyspace.core.handler.GSGuiHandler;
import galaxyspace.core.handler.GSOreGenOtherMods;
import galaxyspace.core.handler.GSPlanetFogHandler;
import galaxyspace.core.integration.minetweaker.GSMinetweakerConfig;
import galaxyspace.core.network.packet.GalaxySpaceChannelHandler;
import galaxyspace.core.prefab.entity.EntityEntryPod;
import galaxyspace.core.prefab.entity.EntityIceSpike;
import galaxyspace.core.prefab.schematics.SchematicAdd;
import galaxyspace.core.proxy.CommonProxy;
import galaxyspace.core.registers.blocks.GSBlocks;
import galaxyspace.core.registers.fluids.GSFluids;
import galaxyspace.core.registers.items.GSItems;
import galaxyspace.core.registers.potions.GSPotions;
import galaxyspace.core.util.BookRegister;
import galaxyspace.core.util.BookUtils;
import galaxyspace.core.util.GSCreativeTabs;
import galaxyspace.core.util.GSThreadVersionCheck;
import galaxyspace.systems.ACentauriSystem.ACentauriSystemBodies;
import galaxyspace.systems.BarnardsSystem.BarnardsSystemBodies;
import galaxyspace.systems.SolarSystem.SolarSystemBodies;
import galaxyspace.systems.SolarSystem.moons.enceladus.tile.TileEntityBlockCrystallTE;
import galaxyspace.systems.SolarSystem.moons.europa.entities.EntityEvolvedColdBlaze;
import galaxyspace.systems.SolarSystem.moons.io.entities.EntityBossGhast;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityDungeonSpawnerIo;
import galaxyspace.systems.SolarSystem.moons.io.tile.TileEntityIoTreasureChest;
import galaxyspace.systems.SolarSystem.planets.ceres.entities.EntityBossBlaze;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityCeresTreasureChest;
import galaxyspace.systems.SolarSystem.planets.ceres.tile.TileEntityDungeonSpawnerCeres;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityCargoFluidRocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier4Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier5Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.entities.EntityTier6Rocket;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvFuelLoader;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPad;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvLandingPadSingle;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAdvOxygenSealer;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityAssemblyMachine;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityCargoFluidLoader;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityConverterSurface;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFluidTank;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityFuelGenerator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityGravitationModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicBase;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityHydroponicFarm;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidExtractor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityLiquidSeparator;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityModificationTable;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityOxStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityOxygenFiller;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityPortableNuclearReactor;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRadiationStabiliser;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRecycler;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityRocketAssemblyMachine;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntitySolarPanel;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntitySolarWind;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityStorageModule;
import galaxyspace.systems.SolarSystem.planets.overworld.tile.TileEntityWindTurbine;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireBlaze;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireCreeper;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireSkeleton;
import galaxyspace.systems.SolarSystem.planets.venus.entities.EntityEvolvedFireSpider;
import galaxyspace.systems.TCetiSystem.TauCetiSystemBodies;
import galaxyspace.systems.VegaSystem.VegaSystemBodies;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Level;

@Mod(modid="GalaxySpace", version="1.2.15 Pre-Final", dependencies="required-after:GalacticraftCore@[3.0.12,); required-after:GalacticraftMars;", name="GalaxySpace")
public class GalaxySpace {
    public static final int major_version = 1;
    public static final int minor_version = 2;
    public static final int build_version = 15;
    public static final String MODID = "GalaxySpace";
    public static final String VERSION = "1.2.15 Pre-Final";
    public static final String ASSET_PREFIX = "GalaxySpace".toLowerCase();
    public static boolean debug;
    public static GalaxySpaceChannelHandler packetPipeline;
    @Mod.Instance(value="GalaxySpace")
    public static GalaxySpace instance;
    @SidedProxy(clientSide="galaxyspace.core.proxy.ClientProxy", serverSide="galaxyspace.core.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static List<IBodiesHandler> bodies;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        new GSConfigDimensions(new File(event.getModConfigurationDirectory(), "GalaxySpace/dimensions.conf"));
        new GSConfigBiomes(new File(event.getModConfigurationDirectory(), "GalaxySpace/biomes.conf"));
        new GSConfigSchematics(new File(event.getModConfigurationDirectory(), "GalaxySpace/schematics.conf"));
        new GSConfigCore(new File(event.getModConfigurationDirectory(), "GalaxySpace/core.conf"));
        new GSConfigEnergy(new File(event.getModConfigurationDirectory(), "GalaxySpace/energy.conf"));
        this.initModInfo(event.getModMetadata());
        bodies.add(new SolarSystemBodies());
        bodies.add(new ACentauriSystemBodies());
        bodies.add(new BarnardsSystemBodies());
        if (GSConfigCore.enableOldSystems) {
            bodies.add(new TauCetiSystemBodies());
            bodies.add(new VegaSystemBodies());
        }
        debug = GSConfigCore.enableDebug;
        GSBlocks.initialize();
        GSItems.initialize();
        GSPotions.initialize();
        GSFluids.initialize();
        proxy.preload();
        GameRegistry.registerFuelHandler((IFuelHandler)new GSFuelHandler());
        SchematicRegistry.registerSchematicRecipe((ISchematicPage)new SchematicAdd());
        proxy.register_event(new GSEventHandler());
        proxy.register_event(new GSPlanetFogHandler());
        for (IBodiesHandler list : bodies) {
            list.preInit(event);
        }
        if (event.getSide() == Side.CLIENT) {
            for (ASMDataTable.ASMData data : event.getAsmData().getAll(IPage.class.getName())) {
                try {
                    IBookPage page = (IBookPage)Class.forName(data.getClassName()).newInstance();
                    String category = page.getCategory() == null ? BookUtils.Book_Cateroies.GENERAL.getName() : page.getCategory();
                    BookUtils.addGuideBookPage(category, page);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.load();
        proxy.register_event(new GSOreGenOtherMods());
        proxy.register_event(new AchEvent());
        packetPipeline = GalaxySpaceChannelHandler.init();
        this.registerEntities();
        AchievementList.load();
        GSCreativeTabs.GSBlocksTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsBlocks", Item.func_150898_a((Block)GSBlocks.AssemblyMachine), 0);
        GSCreativeTabs.GSItemsTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsItems", GSItems.RocketParts, 0);
        GSCreativeTabs.GSArmorTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsArmor", GSItems.JetPack, 0);
        if (!GSConfigCore.registeredRocket.isEmpty()) {
            GSCreativeTabs.GSRocketTab = new CreativeTabGC(CreativeTabs.getNextID(), "AddonsRocket", GSConfigCore.getRegisterRocket(4) ? GSItems.Tier4Rocket : AsteroidsItems.tier3Rocket, 0);
        }
        for (IBodiesHandler list : bodies) {
            list.init(event);
        }
        BookRegister.registerCatergories();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postload();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GSGuiHandler());
        GSThreadVersionCheck.startCheck();
        for (IBodiesHandler list : bodies) {
            list.postInit(event);
        }
        if (Loader.isModLoaded((String)"MineTweaker3")) {
            GSMinetweakerConfig.loadConfig();
        }
        for (String string : GSConfigCore.protect_armor) {
            String[] itemInfo = string.split(":");
            String prefix = itemInfo.length == 1 ? "minecraft" : itemInfo[0];
            Item item = GameRegistry.findItem((String)prefix, (String)itemInfo[1]);
            if (item != null) continue;
            GalaxySpace.debug("Warning! Item: \"" + string + "\" not found!");
        }
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        if (event.getSide() == Side.SERVER) {
            boolean x = false;
            try {
                String str;
                URL url = new URL("https://raw.githubusercontent.com/BlesseNtumble/GalaxySpace/master/check.txt");
                HttpURLConnection http = (HttpURLConnection)url.openConnection();
                http.addRequestProperty("User-Agent", "Mozilla/4.76");
                BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
                while ((str = in.readLine()) != null) {
                    String str2 = new String(str.getBytes(), "UTF-8");
                    String var1 = MinecraftServer.func_71276_C().func_71277_t();
                    if (!var1.equals(str)) continue;
                    x = true;
                }
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (x) {
                throw new RuntimeException("[GalaxySpace] This mod cannot run on you server!");
            }
        }
    }

    private void registerEntities() {
        this.registerCreatures();
        this.registerNonMobEntities();
        this.registerTileEntities();
        this.unsinhronedaddons();
    }

    public void registerCreatures() {
        int back = -16777216;
        int fore = -8388608;
        GCCoreUtil.registerGalacticraftCreature(EntityBossBlaze.class, (String)"EvolvedBossBlaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireCreeper.class, (String)"EvolvedFireCreeper", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSkeleton.class, (String)"EvolvedFireSkeleton", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireSpider.class, (String)"EvolvedFireSpider", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedFireBlaze.class, (String)"EvolvedBlaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityEvolvedColdBlaze.class, (String)"EvolvedColdBlaze", (int)back, (int)fore);
        GCCoreUtil.registerGalacticraftCreature(EntityBossGhast.class, (String)"EvolvedBossGhast", (int)back, (int)fore);
    }

    private void registerNonMobEntities() {
        if (GSConfigCore.getRegisterRocket(4)) {
            GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier4Rocket.class, (String)"SpaceshipT4", (int)150, (int)1, (boolean)false);
        }
        if (GSConfigCore.getRegisterRocket(5)) {
            GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier5Rocket.class, (String)"SpaceshipT5", (int)150, (int)1, (boolean)false);
        }
        if (GSConfigCore.getRegisterRocket(6)) {
            GCCoreUtil.registerGalacticraftNonMobEntity(EntityTier6Rocket.class, (String)"SpaceshipT6", (int)150, (int)1, (boolean)false);
        }
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityCargoFluidRocket.class, (String)"Cargo Fluid Spaceship", (int)150, (int)1, (boolean)false);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityEntryPod.class, (String)"FlameEntryPod", (int)150, (int)1, (boolean)true);
        GCCoreUtil.registerGalacticraftNonMobEntity(EntityIceSpike.class, (String)"IceSpike", (int)40, (int)100, (boolean)true);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAssemblyMachine.class, (String)"GS Assembly Machine");
        GameRegistry.registerTileEntity(TileEntityFuelGenerator.class, (String)"GS Fuel Generator");
        GameRegistry.registerTileEntity(TileEntityConverterSurface.class, (String)"GS Converter Surface");
        GameRegistry.registerTileEntity(TileEntitySolarWind.class, (String)"GS Solar Wind Panel");
        GameRegistry.registerTileEntity(TileEntityStorageModule.class, (String)"GS Storage Module");
        GameRegistry.registerTileEntity(TileEntityOxStorageModule.class, (String)"GS Oxygen Storage Module");
        GameRegistry.registerTileEntity(TileEntitySolarPanel.class, (String)"GS Solar Panel");
        GameRegistry.registerTileEntity(TileEntityGravitationModule.class, (String)"GS Gravitation Module");
        GameRegistry.registerTileEntity(TileEntityWindTurbine.class, (String)"GS Wind Turbine");
        GameRegistry.registerTileEntity(TileEntityAdvOxygenSealer.class, (String)"GS Oxygen Sealer");
        GameRegistry.registerTileEntity(TileEntityAdvFuelLoader.class, (String)"GS Fuel Loader");
        GameRegistry.registerTileEntity(TileEntityRocketAssemblyMachine.class, (String)"GS Rocket Assembly");
        GameRegistry.registerTileEntity(TileEntityRecycler.class, (String)"GS Recycler");
        GameRegistry.registerTileEntity(TileEntityLiquidExtractor.class, (String)"GS Liquid Extractor");
        GameRegistry.registerTileEntity(TileEntityPortableNuclearReactor.class, (String)"GS Thermodynamic Reactor");
        GameRegistry.registerTileEntity(TileEntityFluidTank.class, (String)"GS Fluid Tank");
        GameRegistry.registerTileEntity(TileEntityBlockCrystallTE.class, (String)"GS Crystal");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPadSingle.class, (String)"GS Adv Landing Pad");
        GameRegistry.registerTileEntity(TileEntityAdvLandingPad.class, (String)"GS Adv Landing Pad Full");
        GameRegistry.registerTileEntity(TileEntityCargoFluidLoader.class, (String)"GS Cargo Fluid Loader");
        GameRegistry.registerTileEntity(TileEntityHydroponicBase.class, (String)"GS Gydroponic Base");
        GameRegistry.registerTileEntity(TileEntityHydroponicFarm.class, (String)"GS Gydroponic Farm");
        GameRegistry.registerTileEntity(TileEntityLiquidSeparator.class, (String)"GS Liquid Separator");
        GameRegistry.registerTileEntity(TileEntityRadiationStabiliser.class, (String)"GS Radiation Stabiliser");
        GameRegistry.registerTileEntity(TileEntityModificationTable.class, (String)"GS Modification Table");
        GameRegistry.registerTileEntity(TileEntityOxygenFiller.class, (String)"GS Oxygen Filler");
        GameRegistry.registerTileEntity(TileEntityCeresTreasureChest.class, (String)"GS Tier 4 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerCeres.class, (String)"GS Ceres Dungeon Spawner");
        GameRegistry.registerTileEntity(TileEntityIoTreasureChest.class, (String)"GS Tier 5 Treasure Chest");
        GameRegistry.registerTileEntity(TileEntityDungeonSpawnerIo.class, (String)"GS Io Dungeon Spawner");
    }

    private void unsinhronedaddons() {
        if (Loader.isModLoaded((String)"ModuleGC3")) {
            throw new RuntimeException("You have installed 'Space Research' addon. Delete this addon, it's not supported!");
        }
        if (Loader.isModLoaded((String)"sr")) {
            throw new RuntimeException("You have installed 'Space Research' addon. Delete this addon, it's not supported!");
        }
    }

    public static void info(String message) {
        FMLRelaunchLog.log((String)"Galaxy Space", (Level)Level.INFO, (String)message, (Object[])new Object[0]);
    }

    public static void debug(String message) {
        if (debug) {
            FMLRelaunchLog.log((String)"[DEBUG] Galaxy Space", (Level)Level.INFO, (String)message, (Object[])new Object[0]);
        }
    }

    private void initModInfo(ModMetadata info) {
        info.autogenerated = false;
        info.modId = MODID;
        info.name = MODID;
        info.version = VERSION;
        info.description = "Global addon for Galacticraft 3.";
        info.authorList = Arrays.asList("BlesseNtumble");
    }

    static {
        bodies = new ArrayList<IBodiesHandler>();
    }
}

