/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.shared.tile;

import dan200.billund.shared.block.BillundBlocks;
import dan200.billund.shared.data.Brick;
import dan200.billund.shared.data.Stud;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityBillund
extends TileEntity {
    public static final int ROWS_PER_BLOCK = 6;
    public static final int LAYERS_PER_BLOCK = 5;
    public static final int STUDS_PER_ROW = 6;
    public static final int STUDS_PER_COLUMN = 5;
    public static final int STUDS_PER_LAYER = 36;
    public static final int STUDS_PER_BLOCK = 180;
    public boolean globalIllumination;
    private Stud[] m_studs = new Stud[180];

    public static Stud getStud(IBlockAccess world, int x, int y, int z) {
        int localX = (x % 6 + 6) % 6;
        int localY = (y % 5 + 5) % 5;
        int localZ = (z % 6 + 6) % 6;
        int blockX = (x - localX) / 6;
        int blockY = (y - localY) / 5;
        int blockZ = (z - localZ) / 6;
        if (blockY >= 0) {
            Block block = world.func_147439_a(blockX, blockY, blockZ);
            if (block == BillundBlocks.billund) {
                TileEntity entity = world.func_147438_o(blockX, blockY, blockZ);
                if (entity != null && entity instanceof TileEntityBillund) {
                    TileEntityBillund billund = (TileEntityBillund)entity;
                    return billund.getStudLocal(localX, localY, localZ);
                }
            } else if (!block.isAir(world, blockX, blockY, blockZ)) {
                Stud fake = new Stud(false, false, false, 0, x, y, z, 1, 1, 1);
                fake.actuallyExists = false;
                return fake;
            }
        }
        return null;
    }

    public static boolean canSetStud(IBlockAccess world, int x, int y, int z) {
        int localX = (x % 6 + 6) % 6;
        int localY = (y % 5 + 5) % 5;
        int localZ = (z % 6 + 6) % 6;
        int blockX = (x - localX) / 6;
        int blockY = (y - localY) / 5;
        int blockZ = (z - localZ) / 6;
        if (blockY >= 0) {
            Block block = world.func_147439_a(blockX, blockY, blockZ);
            if (block == BillundBlocks.billund) {
                TileEntity entity = world.func_147438_o(blockX, blockY, blockZ);
                if (entity != null && entity instanceof TileEntityBillund) {
                    TileEntityBillund billund = (TileEntityBillund)entity;
                    return billund.getStudLocal(localX, localY, localZ) == null;
                }
            } else if (block.isAir(world, blockX, blockY, blockZ)) {
                return true;
            }
        }
        return false;
    }

    public static void setStud(World world, int x, int y, int z, Stud stud) {
        int localX = (x % 6 + 6) % 6;
        int localY = (y % 5 + 5) % 5;
        int localZ = (z % 6 + 6) % 6;
        int blockX = (x - localX) / 6;
        int blockY = (y - localY) / 5;
        int blockZ = (z - localZ) / 6;
        if (blockY >= 0) {
            Block block = world.func_147439_a(blockX, blockY, blockZ);
            if (block == BillundBlocks.billund) {
                TileEntity entity = world.func_147438_o(blockX, blockY, blockZ);
                if (entity != null && entity instanceof TileEntityBillund) {
                    TileEntityBillund billund = (TileEntityBillund)entity;
                    billund.setStudLocal(localX, localY, localZ, stud);
                }
                world.func_147471_g(blockX, blockY, blockZ);
            } else if (block.isAir((IBlockAccess)world, blockX, blockY, blockZ) && world.func_147465_d(blockX, blockY, blockZ, (Block)BillundBlocks.billund, 0, 3)) {
                TileEntity entity = world.func_147438_o(blockX, blockY, blockZ);
                if (entity != null && entity instanceof TileEntityBillund) {
                    TileEntityBillund billund = (TileEntityBillund)entity;
                    billund.setStudLocal(localX, localY, localZ, stud);
                }
                world.func_147471_g(blockX, blockY, blockZ);
            }
        }
    }

    public static boolean canAddBrick(World world, Brick brick) {
        for (int x = brick.xOrigin; x < brick.xOrigin + brick.width; ++x) {
            for (int y = brick.yOrigin; y < brick.yOrigin + brick.height; ++y) {
                for (int z = brick.zOrigin; z < brick.zOrigin + brick.depth; ++z) {
                    if (TileEntityBillund.canSetStud((IBlockAccess)world, x, y, z)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static void addBrick(World world, Brick brick) {
        for (int x = brick.xOrigin; x < brick.xOrigin + brick.width; ++x) {
            for (int y = brick.yOrigin; y < brick.yOrigin + brick.height; ++y) {
                for (int z = brick.zOrigin; z < brick.zOrigin + brick.depth; ++z) {
                    Stud stud = new Stud(brick, x - brick.xOrigin, y - brick.yOrigin, z - brick.zOrigin);
                    TileEntityBillund.setStud(world, x, y, z, stud);
                }
            }
        }
    }

    public static void removeBrick(World world, Brick brick) {
        for (int x = brick.xOrigin; x < brick.xOrigin + brick.width; ++x) {
            for (int y = brick.yOrigin; y < brick.yOrigin + brick.height; ++y) {
                for (int z = brick.zOrigin; z < brick.zOrigin + brick.depth; ++z) {
                    TileEntityBillund.setStud(world, x, y, z, null);
                }
            }
        }
    }

    public static StudRaycastResult raycastStuds(World world, Vec3 origin, Vec3 direction, float distance) {
        float xScale = 6.0f;
        float yScale = 5.0f;
        float zScale = 6.0f;
        float x = (float)origin.field_72450_a * xScale;
        float y = (float)origin.field_72448_b * yScale;
        float z = (float)origin.field_72449_c * zScale;
        int sx = (int)Math.floor(x);
        int sy = (int)Math.floor(y);
        int sz = (int)Math.floor(z);
        x -= (float)sx;
        y -= (float)sy;
        z -= (float)sz;
        float dx = (float)direction.field_72450_a;
        float dy = (float)direction.field_72448_b * (yScale / xScale);
        float dz = (float)direction.field_72449_c;
        float dLen = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        dx /= dLen;
        dy /= dLen;
        dz /= dLen;
        distance *= xScale;
        int stepX = 0;
        int stepY = 0;
        int stepZ = 0;
        float edgeX = 0.0f;
        float edgeY = 0.0f;
        float edgeZ = 0.0f;
        if (dx > 0.0f) {
            stepX = 1;
            edgeX = 1.0f;
        } else if (dx < 0.0f) {
            stepX = -1;
            edgeX = 0.0f;
        }
        if (dy > 0.0f) {
            stepY = 1;
            edgeY = 1.0f;
        } else if (dy < 0.0f) {
            stepY = -1;
            edgeY = 0.0f;
        }
        if (dz > 0.0f) {
            stepZ = 1;
            edgeZ = 1.0f;
        } else if (dz < 0.0f) {
            stepZ = -1;
            edgeZ = 0.0f;
        }
        float distanceLeft = distance;
        Stud hitStud = null;
        int hitSide = -1;
        while (distanceLeft > 0.0f && hitStud == null) {
            float distToEdgeX = 999.0f;
            float distToEdgeY = 999.0f;
            float distToEdgeZ = 999.0f;
            if (stepX != 0) {
                distToEdgeX = (edgeX - x) / dx;
            }
            if (stepY != 0) {
                distToEdgeY = (edgeY - y) / dy;
            }
            if (stepZ != 0) {
                distToEdgeZ = (edgeZ - z) / dz;
            }
            if (distToEdgeX <= distToEdgeY && distToEdgeX <= distToEdgeZ) {
                if (distToEdgeX < distanceLeft) {
                    x += distToEdgeX * dx - (float)stepX;
                    y += distToEdgeX * dy;
                    z += distToEdgeX * dz;
                    distanceLeft -= distToEdgeX;
                    hitStud = TileEntityBillund.getStud((IBlockAccess)world, sx += stepX, sy, sz);
                    hitSide = stepX > 0 ? 4 : 5;
                    continue;
                }
                x += distToEdgeX * dx;
                y += distToEdgeX * dy;
                z += distToEdgeX * dz;
                distanceLeft = 0.0f;
                continue;
            }
            if (distToEdgeY <= distToEdgeX && distToEdgeY <= distToEdgeZ) {
                if (distToEdgeY < distanceLeft) {
                    x += distToEdgeY * dx;
                    y += distToEdgeY * dy - (float)stepY;
                    z += distToEdgeY * dz;
                    distanceLeft -= distToEdgeY;
                    hitStud = TileEntityBillund.getStud((IBlockAccess)world, sx, sy += stepY, sz);
                    hitSide = stepY > 0 ? 0 : 1;
                    continue;
                }
                x += distToEdgeY * dx;
                y += distToEdgeY * dy;
                z += distToEdgeY * dz;
                distanceLeft = 0.0f;
                continue;
            }
            if (distToEdgeZ < distanceLeft) {
                x += distToEdgeZ * dx;
                y += distToEdgeZ * dy;
                z += distToEdgeZ * dz - (float)stepZ;
                distanceLeft -= distToEdgeZ;
                hitStud = TileEntityBillund.getStud((IBlockAccess)world, sx, sy, sz += stepZ);
                hitSide = stepZ > 0 ? 2 : 3;
                continue;
            }
            x += distToEdgeZ * dx;
            y += distToEdgeZ * dy;
            z += distToEdgeZ * dz;
            distanceLeft = 0.0f;
        }
        if (hitStud != null) {
            StudRaycastResult result = new StudRaycastResult();
            result.hitX = sx;
            result.hitY = sy;
            result.hitZ = sz;
            result.hitSide = hitSide;
            return result;
        }
        return null;
    }

    public Stud getStudLocal(int x, int y, int z) {
        if (x >= 0 && x < 6 && y >= 0 && y < 5 && z >= 0 && z < 6) {
            return this.m_studs[x + z * 6 + y * 36];
        }
        return null;
    }

    public void setStudLocal(int x, int y, int z, Stud stud) {
        if (x >= 0 && x < 6 && y >= 0 && y < 5 && z >= 0 && z < 6) {
            this.m_studs[x + z * 6 + y * 36] = stud;
            this.cullOrphans();
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < 180; ++i) {
            if (this.m_studs[i] == null) continue;
            return false;
        }
        return true;
    }

    public void cullOrphans() {
        this.globalIllumination = false;
        boolean changed = false;
        for (int i = 0; i < 180; ++i) {
            Stud stud = this.m_studs[i];
            if (stud == null) continue;
            Stud origin = TileEntityBillund.getStud((IBlockAccess)this.field_145850_b, stud.xOrigin, stud.yOrigin, stud.zOrigin);
            if (origin == null) {
                this.m_studs[i] = null;
                changed = true;
                continue;
            }
            if (this.globalIllumination || !stud.illuminated) continue;
            this.globalIllumination = true;
            changed = true;
        }
        if (changed) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74757_a("globalIllumination", this.globalIllumination);
        for (int i = 0; i < 180; ++i) {
            Stud stud = this.m_studs[i];
            if (stud == null) continue;
            NBTTagCompound studTag = new NBTTagCompound();
            studTag.func_74757_a("i", stud.illuminated);
            studTag.func_74757_a("t", stud.transparent);
            studTag.func_74757_a("s", stud.smooth);
            studTag.func_74768_a("c", stud.color);
            studTag.func_74768_a("x", stud.xOrigin);
            studTag.func_74768_a("y", stud.yOrigin);
            studTag.func_74768_a("z", stud.zOrigin);
            studTag.func_74768_a("w", stud.brickWidth);
            studTag.func_74768_a("h", stud.brickHeight);
            studTag.func_74768_a("d", stud.brickDepth);
            nbttagcompound.func_74782_a("s" + i, (NBTBase)studTag);
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.globalIllumination = nbttagcompound.func_74767_n("globalIllumination");
        for (int i = 0; i < 180; ++i) {
            String key = "s" + i;
            if (nbttagcompound.func_74764_b(key)) {
                Stud stud = new Stud();
                NBTTagCompound studTag = nbttagcompound.func_74775_l(key);
                stud.illuminated = studTag.func_74767_n("i");
                stud.transparent = studTag.func_74767_n("t");
                stud.smooth = studTag.func_74767_n("s");
                stud.color = studTag.func_74762_e("c");
                stud.xOrigin = studTag.func_74762_e("x");
                stud.yOrigin = studTag.func_74762_e("y");
                stud.zOrigin = studTag.func_74762_e("z");
                stud.brickWidth = studTag.func_74762_e("w");
                stud.brickHeight = studTag.func_74762_e("h");
                stud.brickDepth = studTag.func_74762_e("d");
                this.m_studs[i] = stud;
                continue;
            }
            this.m_studs[i] = null;
        }
    }

    public static class StudRaycastResult {
        public int hitX;
        public int hitY;
        public int hitZ;
        public int hitSide;
    }
}

