/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.shared.item;

import dan200.billund.Billund;
import dan200.billund.shared.core.BillundProxyCommon;
import dan200.billund.shared.data.Brick;
import dan200.billund.shared.data.Stud;
import dan200.billund.shared.item.BillundItems;
import dan200.billund.shared.tile.TileEntityBillund;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemBrick
extends Item {
    public ItemBrick() {
        this.func_77625_d(64);
        this.func_77627_a(true);
        this.func_77655_b("brick");
        this.func_77637_a(Billund.TAB);
    }

    public static ItemStack create(int color, int width, int depth, int quantity) {
        return ItemBrick.create(false, false, false, color, width, depth, quantity);
    }

    public static ItemStack create(boolean illuminated, boolean transparent, boolean smooth, int colour, int width, int depth, int quantity) {
        int damage = (width - 1 & 1) + ((depth - 1 & 7) << 1);
        ItemStack stack = new ItemStack((Item)BillundItems.brick, quantity, damage);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("color", colour);
        nbt.func_74757_a("illuminated", illuminated);
        nbt.func_74757_a("transparent", transparent);
        nbt.func_74757_a("smooth", smooth);
        stack.func_77982_d(nbt);
        return stack;
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < ItemDye.field_150922_c.length; ++i) {
            int colour = ItemDye.field_150922_c[i];
            list.add(ItemBrick.create(colour, 1, 1, 1));
            list.add(ItemBrick.create(colour, 1, 2, 1));
            list.add(ItemBrick.create(colour, 1, 3, 1));
            list.add(ItemBrick.create(colour, 1, 4, 1));
            list.add(ItemBrick.create(colour, 1, 6, 1));
            list.add(ItemBrick.create(colour, 2, 2, 1));
            list.add(ItemBrick.create(colour, 2, 3, 1));
            list.add(ItemBrick.create(colour, 2, 4, 1));
            list.add(ItemBrick.create(colour, 2, 6, 1));
        }
    }

    public static TileEntityBillund.StudRaycastResult raycastFromPlayer(World world, EntityPlayer player, float f) {
        double yOffset2 = !world.field_72995_K && player.func_70093_af() ? -0.08 : 0.0;
        float pitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * f;
        float yaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * f;
        double x = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)f;
        double y = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)f + 1.62 - (double)player.field_70129_M + yOffset2;
        double z = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)f;
        Vec3 position = Vec3.func_72443_a((double)x, (double)y, (double)z);
        float f3 = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f5 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f6 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        float f7 = f4 * f5;
        float f8 = f3 * f5;
        float distance = 5.0f;
        if (player instanceof EntityPlayerMP) {
            distance = (float)((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 direction = Vec3.func_72443_a((double)f7, (double)f6, (double)f8);
        return TileEntityBillund.raycastStuds(world, position, direction, distance);
    }

    public static Brick getPotentialBrick(ItemStack stack, World world, EntityPlayer player, float f) {
        TileEntityBillund.StudRaycastResult result = ItemBrick.raycastFromPlayer(world, player, f);
        if (result != null) {
            Stud stud = TileEntityBillund.getStud((IBlockAccess)world, result.hitX, result.hitY, result.hitZ);
            if (result.hitSide == 1 && stud.smooth) {
                return null;
            }
            int defaultWidth = ItemBrick.getWidth(stack);
            int defaultDepth = ItemBrick.getDepth(stack);
            int width = 0;
            int depth = 0;
            int height = 1;
            int placeX = result.hitX;
            int placeY = result.hitY;
            int placeZ = result.hitZ;
            switch (BillundProxyCommon.rotate) {
                default: {
                    depth = defaultDepth;
                    width = defaultWidth;
                    break;
                }
                case 1: {
                    depth = defaultWidth;
                    width = defaultDepth;
                    break;
                }
                case 2: {
                    depth = defaultDepth;
                    width = defaultWidth;
                    placeZ -= depth - 1;
                    break;
                }
                case 3: {
                    depth = defaultWidth;
                    width = defaultDepth;
                    placeX -= width - 1;
                }
            }
            switch (result.hitSide) {
                case 0: {
                    placeY -= height;
                    break;
                }
                case 1: {
                    ++placeY;
                    break;
                }
                case 2: {
                    placeZ -= depth;
                    break;
                }
                case 3: {
                    ++placeZ;
                    break;
                }
                case 4: {
                    placeX -= width;
                    break;
                }
                case 5: {
                    ++placeX;
                }
            }
            Brick brick = new Brick(ItemBrick.getIlluminated(stack), ItemBrick.getTransparent(stack), ItemBrick.getSmooth(stack), ItemBrick.getColour(stack), placeX, placeY, placeZ, width, height, depth);
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < depth; ++z) {
                    for (int y = 0; y < height; ++y) {
                        brick.xOrigin = placeX - x;
                        brick.yOrigin = placeY - y;
                        brick.zOrigin = placeZ - z;
                        if (!TileEntityBillund.canAddBrick(world, brick)) continue;
                        return brick;
                    }
                }
            }
        }
        return null;
    }

    public static Brick getExistingBrick(World world, EntityPlayer player, float f) {
        Stud stud;
        TileEntityBillund.StudRaycastResult result = ItemBrick.raycastFromPlayer(world, player, f);
        if (result != null && (stud = TileEntityBillund.getStud((IBlockAccess)world, result.hitX, result.hitY, result.hitZ)) != null && stud.actuallyExists) {
            return new Brick(stud.illuminated, stud.transparent, stud.smooth, stud.color, stud.xOrigin, stud.yOrigin, stud.zOrigin, stud.brickWidth, stud.brickHeight, stud.brickDepth);
        }
        return null;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        list.add(ItemBrick.getWidth(stack) + "x" + ItemBrick.getDepth(stack));
        if (ItemBrick.getIlluminated(stack)) {
            list.add(I18n.func_135052_a((String)"brick.illuminated", (Object[])new Object[0]));
        }
        if (ItemBrick.getTransparent(stack)) {
            list.add(I18n.func_135052_a((String)"brick.transparent", (Object[])new Object[0]));
        }
        if (ItemBrick.getSmooth(stack)) {
            list.add(I18n.func_135052_a((String)"brick.smooth", (Object[])new Object[0]));
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        Brick brick = ItemBrick.getPotentialBrick(stack, world, player, 1.0f);
        if (brick != null && !world.field_72995_K) {
            TileEntityBillund.addBrick(world, brick);
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
        }
        return stack;
    }

    public static int getWidth(ItemStack stack) {
        int damage = stack.func_77960_j();
        return (damage & 1) + 1;
    }

    public static int getHeight(ItemStack stack) {
        return 1;
    }

    public static int getDepth(ItemStack stack) {
        int damage = stack.func_77960_j();
        return (damage >> 1 & 7) + 1;
    }

    public static int getColour(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e("color") : 0;
    }

    public static boolean getIlluminated(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("illuminated") : false;
    }

    public static boolean getTransparent(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("transparent") : false;
    }

    public static boolean getSmooth(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74767_n("smooth") : false;
    }
}

