/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.shared.data;

import dan200.billund.shared.data.Color;
import dan200.billund.shared.item.ItemBrick;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class BillundSet {
    private static String[] s_setNames = new String[]{"pack.starter", "pack.colorA", "pack.colorB", "pack.colorC", "pack.colorD", "pack.random"};
    private static int[] s_setCosts = new int[]{7, 10, 10, 10, 10, 15};
    private int m_index;
    private IInventory s_addInventory = null;
    private int s_addIndex = 0;

    public static BillundSet get(int index) {
        return new BillundSet(index);
    }

    public BillundSet(int index) {
        this.m_index = index;
    }

    public int getCost() {
        return s_setCosts[this.m_index];
    }

    public String getDescription() {
        return s_setNames[this.m_index];
    }

    public void populateChest(IInventory inv) {
        this.s_addIndex = 0;
        this.s_addInventory = inv;
        switch (this.m_index) {
            case 0: {
                this.addBasic(Color.RED);
                this.addBasic(Color.GREEN);
                this.addBasic(Color.BLUE);
                this.addBasic(Color.YELLOW);
                this.addBasic(Color.WHITE);
                this.addBasic(Color.BLACK);
                break;
            }
            case 1: {
                this.addAll(Color.RED);
                this.addAll(Color.GREEN);
                this.addAll(Color.BLUE);
                break;
            }
            case 2: {
                this.addAll(Color.ORANGE);
                this.addAll(Color.YELLOW);
                this.addAll(Color.LIME);
                break;
            }
            case 3: {
                this.addAll(Color.PINK);
                this.addAll(Color.PURPLE);
                this.addAll(Color.WHITE);
                break;
            }
            case 4: {
                this.addAll(Color.LIGHT_GRAY);
                this.addAll(Color.GRAY);
                this.addAll(Color.BLACK);
                break;
            }
            case 5: {
                for (int i = 0; i < 27; ++i) {
                    this.addRandom();
                }
                break;
            }
        }
    }

    private void add(ItemStack stack) {
        int slot;
        if ((slot = this.s_addIndex++) < this.s_addInventory.func_70302_i_()) {
            this.s_addInventory.func_70299_a(slot, stack);
        }
    }

    private void addBasic(Color colour) {
        this.add(ItemBrick.create(colour.getRGB(), 1, 2, 24));
        this.add(ItemBrick.create(colour.getRGB(), 1, 4, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 2, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 4, 24));
    }

    private void addAll(Color colour) {
        this.add(ItemBrick.create(colour.getRGB(), 1, 1, 24));
        this.add(ItemBrick.create(colour.getRGB(), 1, 2, 24));
        this.add(ItemBrick.create(colour.getRGB(), 1, 3, 24));
        this.add(ItemBrick.create(colour.getRGB(), 1, 4, 24));
        this.add(ItemBrick.create(colour.getRGB(), 1, 6, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 2, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 3, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 4, 24));
        this.add(ItemBrick.create(colour.getRGB(), 2, 6, 24));
    }

    private void addRandom() {
        Random random = new Random();
        this.add(ItemBrick.create(random.nextBoolean(), random.nextBoolean(), random.nextBoolean(), Color.values()[random.nextInt(Color.values().length)].getRGB(), random.nextInt(2) + 1, random.nextInt(6) + 1, 24));
    }
}

