/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.shared.block;

import dan200.billund.shared.data.Brick;
import dan200.billund.shared.data.Stud;
import dan200.billund.shared.item.ItemBrick;
import dan200.billund.shared.tile.TileEntityBillund;
import java.awt.Color;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBillund
extends BlockContainer {
    private static IIcon s_transparentIcon;
    private static Brick s_hoverBrick;
    public static int blockRenderID;

    public static void setHoverBrick(Brick brick) {
        s_hoverBrick = brick;
    }

    public BlockBillund() {
        super(Material.field_151575_d);
        this.func_149711_c(0.25f);
        this.func_149663_c("billund");
        blockRenderID = -1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) != null && tileEntity instanceof TileEntityBillund) {
            TileEntityBillund billund = (TileEntityBillund)tileEntity;
            Brick brick = ItemBrick.getExistingBrick(world, player, 1.0f);
            if (brick != null) {
                TileEntityBillund.removeBrick(world, brick);
                if (!player.field_71075_bZ.field_75098_d) {
                    float brickX = ((float)brick.xOrigin + (float)brick.width * 0.5f) / 6.0f;
                    float brickY = ((float)brick.yOrigin + (float)brick.height) / 5.0f;
                    float brickZ = ((float)brick.zOrigin + (float)brick.depth * 0.5f) / 6.0f;
                    ItemStack stack = ItemBrick.create(brick.illuminated, brick.transparent, brick.smooth, brick.color, Math.min(brick.width, brick.depth), Math.max(brick.width, brick.depth), 1);
                    EntityItem entityitem = new EntityItem(world, (double)brickX, (double)(brickY + 0.05f), (double)brickZ, stack);
                    entityitem.field_70159_w = 0.0;
                    entityitem.field_70181_x = 0.0;
                    entityitem.field_70179_y = 0.0;
                    entityitem.field_145804_b = 30;
                    world.func_72838_d((Entity)entityitem);
                }
                if (billund.isEmpty()) {
                    world.func_147468_f(x, y, z);
                    return true;
                }
            }
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity != null && tileEntity instanceof TileEntityBillund) {
            TileEntityBillund billund = (TileEntityBillund)tileEntity;
            return billund.globalIllumination ? 15 : 0;
        }
        return 0;
    }

    public void func_149695_a(World world, int i, int j, int k, Block block) {
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (tileEntity != null && tileEntity instanceof TileEntityBillund) {
            TileEntityBillund billund = (TileEntityBillund)tileEntity;
            billund.cullOrphans();
            if (billund.isEmpty()) {
                world.func_147468_f(i, j, k);
            }
        }
    }

    public void func_149719_a(IBlockAccess world, int i, int j, int k) {
        if (s_hoverBrick != null) {
            int sx = BlockBillund.s_hoverBrick.xOrigin;
            int sy = BlockBillund.s_hoverBrick.yOrigin;
            int sz = BlockBillund.s_hoverBrick.zOrigin;
            int localX = (sx % 6 + 6) % 6;
            int localY = (sy % 5 + 5) % 5;
            int localZ = (sz % 6 + 6) % 6;
            int blockX = (sx - localX) / 6;
            int blockY = (sy - localY) / 5;
            int blockZ = (sz - localZ) / 6;
            if (!(i != blockX && i != blockX + 1 || j != blockY && j != blockY + 1 || k != blockZ && k != blockZ + 1)) {
                float xScale = 0.16666667f;
                float yScale = 0.2f;
                float zScale = 0.16666667f;
                float startX = (float)(sx - i * 6) * xScale;
                float startY = (float)(sy - j * 5) * yScale;
                float startZ = (float)(sz - k * 6) * zScale;
                this.func_149676_a(startX, startY, startZ, startX + (float)BlockBillund.s_hoverBrick.width * xScale, startY + (float)BlockBillund.s_hoverBrick.height * yScale, startZ + (float)BlockBillund.s_hoverBrick.depth * zScale);
                return;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public AxisAlignedBB func_149633_g(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return AxisAlignedBB.func_72330_a((double)((double)par2 + this.field_149759_B), (double)((double)par3 + this.field_149760_C), (double)((double)par4 + this.field_149754_D), (double)((double)par2 + this.field_149755_E), (double)((double)par3 + this.field_149756_F), (double)((double)par4 + this.field_149757_G));
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB bigBox, List list, Entity entity) {
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (tileEntity != null && tileEntity instanceof TileEntityBillund) {
            double originX = i;
            double originY = j;
            double originZ = k;
            double stepX = 0.16666666666666666;
            double stepY = 0.2;
            double stepZ = 0.16666666666666666;
            int minsx = i * 6;
            int minsy = j * 5;
            int minsz = k * 6;
            TileEntityBillund billund = (TileEntityBillund)tileEntity;
            for (int x = 0; x < 6; ++x) {
                for (int y = 0; y < 5; ++y) {
                    for (int z = 0; z < 6; ++z) {
                        AxisAlignedBB littleBox;
                        Stud stud = billund.getStudLocal(x, y, z);
                        if (stud == null) continue;
                        double startX = originX + (double)x * stepX;
                        double startY = originY + (double)y * stepY;
                        double startZ = originZ + (double)z * stepZ;
                        if (stud.xOrigin < minsx || stud.yOrigin < minsy || stud.zOrigin < minsz) {
                            AxisAlignedBB littleBox2 = AxisAlignedBB.func_72330_a((double)startX, (double)startY, (double)startZ, (double)(startX + stepX), (double)(startY + stepY), (double)(startZ + stepZ));
                            if (!littleBox2.func_72326_a(bigBox)) continue;
                            list.add(littleBox2);
                            continue;
                        }
                        int sx = x + minsx;
                        int sy = y + minsy;
                        int sz = z + minsz;
                        if (sx != stud.xOrigin || sy != stud.yOrigin || sz != stud.zOrigin || !(littleBox = AxisAlignedBB.func_72330_a((double)startX, (double)startY, (double)startZ, (double)(startX + (double)stud.brickWidth * stepX), (double)(startY + (double)stud.brickHeight * stepY), (double)(startZ + (double)stud.brickDepth * stepZ))).func_72326_a(bigBox)) continue;
                        list.add(littleBox);
                    }
                }
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return ItemBrick.create(BlockBillund.s_hoverBrick.illuminated, BlockBillund.s_hoverBrick.transparent, BlockBillund.s_hoverBrick.smooth, BlockBillund.s_hoverBrick.color, BlockBillund.s_hoverBrick.width, BlockBillund.s_hoverBrick.depth, 1);
    }

    public IIcon func_149673_e(IBlockAccess world, int i, int j, int k, int side) {
        return s_transparentIcon;
    }

    public IIcon func_149691_a(int side, int damage) {
        return s_transparentIcon;
    }

    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer entityplayer, int l, float m, float n, float o) {
        ItemStack held;
        if (!world.field_72995_K && s_hoverBrick != null && (held = entityplayer.func_70694_bm()) != null && held.func_77973_b() instanceof ItemDye) {
            Brick newBrick = new Brick(BlockBillund.s_hoverBrick.illuminated, BlockBillund.s_hoverBrick.transparent, BlockBillund.s_hoverBrick.smooth, BlockBillund.s_hoverBrick.color, BlockBillund.s_hoverBrick.xOrigin, BlockBillund.s_hoverBrick.yOrigin, BlockBillund.s_hoverBrick.zOrigin, BlockBillund.s_hoverBrick.width, BlockBillund.s_hoverBrick.height, BlockBillund.s_hoverBrick.depth);
            Color brickColor = new Color(newBrick.color);
            Color dyeColor = new Color(ItemDye.field_150922_c[held.func_77960_j()]);
            int br = brickColor.getRed();
            int bg = brickColor.getGreen();
            int bb = brickColor.getBlue();
            int dr = dyeColor.getRed();
            int dg = dyeColor.getGreen();
            int db = dyeColor.getBlue();
            int ar = (br + dr) / 2;
            int ag = (bg + dg) / 2;
            int ab = (bb + db) / 2;
            newBrick.color = new Color(ar, ag, ab).getRGB();
            TileEntityBillund.addBrick(world, newBrick);
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityBillund();
    }

    public void func_149651_a(IIconRegister iconRegister) {
        s_transparentIcon = iconRegister.func_94245_a("billund:transparent");
    }

    static {
        s_hoverBrick = null;
    }
}

