/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.client.helper;

import dan200.billund.shared.block.BillundBlocks;
import dan200.billund.shared.data.Brick;
import dan200.billund.shared.data.Stud;
import dan200.billund.shared.item.ItemBrick;
import dan200.billund.shared.tile.TileEntityBillund;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class BrickRenderHelper {
    public static void translateToWorldCoords(Entity entity, float frame) {
        double interpPosX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)frame;
        double interpPosY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)frame;
        double interpPosZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)frame;
        GL11.glTranslated((double)(-interpPosX), (double)(-interpPosY), (double)(-interpPosZ));
    }

    public static int getColor(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
    }

    public static void renderBrick(ItemStack brick, boolean scale, boolean center) {
        Tessellator tessellator = Tessellator.field_78398_a;
        int brightness = 15;
        boolean smooth = ItemBrick.getSmooth(brick);
        int colour = ItemBrick.getColour(brick);
        int width = ItemBrick.getWidth(brick);
        int height = ItemBrick.getHeight(brick);
        int depth = ItemBrick.getDepth(brick);
        GL11.glPushMatrix();
        if (scale) {
            float scaleValue = 5.0f / Math.max(2.0f, (float)Math.max(width, depth) - 0.5f);
            GL11.glScalef((float)scaleValue, (float)scaleValue, (float)scaleValue);
        }
        if (center) {
            GL11.glTranslatef((float)(-0.5f * ((float)width / 6.0f)), (float)(-0.5f * ((float)height / 5.0f)), (float)(-0.5f * ((float)depth / 6.0f)));
        }
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        BrickRenderHelper.renderBrick(null, brightness, false, smooth, colour, 1.0f, 0, 0, 0, width, height, depth);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public static void renderBrick(IBlockAccess world, Brick brick) {
        int localX = (brick.xOrigin % 6 + 6) % 6;
        int localY = (brick.yOrigin % 5 + 5) % 5;
        int localZ = (brick.zOrigin % 6 + 6) % 6;
        int blockX = (brick.xOrigin - localX) / 6;
        int blockY = (brick.yOrigin - localY) / 5;
        int blockZ = (brick.zOrigin - localZ) / 6;
        Tessellator tessellator = Tessellator.field_78398_a;
        int brightness = BillundBlocks.billund.func_149677_c(world, blockX, blockY, blockZ);
        tessellator.func_78382_b();
        BrickRenderHelper.renderBrick(world, brightness, brick.illuminated, brick.smooth, brick.color, 0.65f, brick.xOrigin, brick.yOrigin, brick.zOrigin, brick.width, brick.height, brick.depth);
        tessellator.func_78381_a();
    }

    public static void renderBrick(IBlockAccess world, int brightness, boolean illuminated, boolean smooth, int colour, float alpha, int sx, int sy, int sz, int width, int height, int depth) {
        if (world != null && !illuminated) {
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78380_c(brightness);
        }
        float pixel = 0.010416667f;
        float xBlockSize = 6.0f;
        float yBlockSize = 5.0f;
        float zBlockSize = 6.0f;
        float startX = (float)sx / xBlockSize;
        float startY = (float)sy / yBlockSize;
        float startZ = (float)sz / zBlockSize;
        float endX = startX + (float)width / xBlockSize;
        float endY = startY + (float)height / yBlockSize;
        float endZ = startZ + (float)depth / zBlockSize;
        BrickRenderHelper.renderBox(colour, alpha, startX, startY, startZ, endX, endY, endZ, true);
        int sny = sy + height;
        startY = (float)sny / yBlockSize;
        endY = startY + 0.1666f / yBlockSize;
        for (int snx = sx; snx < sx + width; ++snx) {
            startX = (float)snx / xBlockSize;
            endX = startX + 1.0f / xBlockSize;
            for (int snz = sz; snz < sz + depth; ++snz) {
                Stud above;
                boolean drawStud = world != null ? (above = TileEntityBillund.getStud(world, snx, sny, snz)) == null || above.transparent : true;
                if (smooth) {
                    drawStud = false;
                }
                if (!drawStud) continue;
                startZ = (float)snz / zBlockSize;
                endZ = startZ + 1.0f / zBlockSize;
                BrickRenderHelper.renderBox(colour, alpha, startX + pixel * 2.0f, startY, startZ + pixel * 4.0f, startX + pixel * 4.0f, endY, endZ - pixel * 4.0f, false);
                BrickRenderHelper.renderBox(colour, alpha, startX + pixel * 4.0f, startY, startZ + pixel * 2.0f, endX - pixel * 4.0f, endY, endZ - pixel * 2.0f, false);
                BrickRenderHelper.renderBox(colour, alpha, endX - pixel * 4.0f, startY, startZ + pixel * 4.0f, endX - pixel * 2.0f, endY, endZ - pixel * 4.0f, false);
            }
        }
    }

    private static void renderBox(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ, boolean bottom) {
        BrickRenderHelper.renderFaceXNeg(color, alpha, startX, startY, startZ, endX, endY, endZ);
        BrickRenderHelper.renderFaceXPos(color, alpha, startX, startY, startZ, endX, endY, endZ);
        if (bottom) {
            BrickRenderHelper.renderFaceYNeg(color, alpha, startX, startY, startZ, endX, endY, endZ);
        }
        BrickRenderHelper.renderFaceYPos(color, alpha, startX, startY, startZ, endX, endY, endZ);
        BrickRenderHelper.renderFaceZNeg(color, alpha, startX, startY, startZ, endX, endY, endZ);
        BrickRenderHelper.renderFaceZPos(color, alpha, startX, startY, startZ, endX, endY, endZ);
    }

    private static void renderFaceXNeg(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r * 0.6f, g * 0.6f, b * 0.6f, alpha);
        tessellator.func_78377_a((double)startX, (double)endY, (double)endZ);
        tessellator.func_78377_a((double)startX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)startX, (double)startY, (double)startZ);
        tessellator.func_78377_a((double)startX, (double)startY, (double)endZ);
    }

    private static void renderFaceXPos(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r * 0.6f, g * 0.6f, b * 0.6f, alpha);
        tessellator.func_78377_a((double)endX, (double)startY, (double)endZ);
        tessellator.func_78377_a((double)endX, (double)startY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)endY, (double)endZ);
    }

    private static void renderFaceYNeg(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r * 0.5f, g * 0.5f, b * 0.5f, alpha);
        tessellator.func_78377_a((double)startX, (double)startY, (double)endZ);
        tessellator.func_78377_a((double)startX, (double)startY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)startY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)startY, (double)endZ);
    }

    private static void renderFaceYPos(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r, g, b, alpha);
        tessellator.func_78377_a((double)endX, (double)endY, (double)endZ);
        tessellator.func_78377_a((double)endX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)startX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)startX, (double)endY, (double)endZ);
    }

    private static void renderFaceZNeg(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r * 0.8f, g * 0.8f, b * 0.8f, alpha);
        tessellator.func_78377_a((double)startX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)endY, (double)startZ);
        tessellator.func_78377_a((double)endX, (double)startY, (double)startZ);
        tessellator.func_78377_a((double)startX, (double)startY, (double)startZ);
    }

    private static void renderFaceZPos(int color, float alpha, float startX, float startY, float startZ, float endX, float endY, float endZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        tessellator.func_78369_a(r * 0.8f, g * 0.8f, b * 0.8f, alpha);
        tessellator.func_78377_a((double)startX, (double)startY, (double)endZ);
        tessellator.func_78377_a((double)endX, (double)startY, (double)endZ);
        tessellator.func_78377_a((double)endX, (double)endY, (double)endZ);
        tessellator.func_78377_a((double)startX, (double)endY, (double)endZ);
    }
}

