/*
 * Decompiled with CFR 0.152.
 */
package dan200.billund.client.gui;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dan200.billund.shared.data.BillundSet;
import dan200.billund.shared.helper.EmeraldHelper;
import dan200.billund.shared.network.PacketHandler;
import dan200.billund.shared.network.message.MessageOrder;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiOrderForm
extends GuiScreen {
    private static final ResourceLocation background = new ResourceLocation("billund", "textures/gui/orderform.png");
    private static final int xSize = 192;
    private static final int ySize = 215;
    private static final int NUM_SETS = 6;
    private EntityPlayer m_player;
    private boolean[] m_orders;
    private boolean m_ordered;

    public GuiOrderForm(EntityPlayer player) {
        this.m_player = player;
        this.m_orders = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            this.m_orders[i] = false;
        }
        this.m_ordered = false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
    }

    public void func_146281_b() {
        super.func_146281_b();
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73876_c() {
        super.func_73876_c();
    }

    protected void func_73869_a(char c, int k) {
        super.func_73869_a(c, k);
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        int startY = (this.field_146295_m - 215) / 2;
        int startX = (this.field_146294_l - 192) / 2;
        if (button == 0) {
            int localX = x - startX;
            int localY = y - startY;
            if (localX >= 160 && localX < 177 && localY >= 33) {
                int tickBoxIndex = (localY - 33) / 23;
                int tickBoxLocalY = (localY - 33) % 23;
                if (tickBoxIndex >= 0 && tickBoxIndex < 6 && tickBoxLocalY < 17 && !this.m_ordered) {
                    for (int i = 0; i < 6; ++i) {
                        if (i != tickBoxIndex) continue;
                        this.m_orders[i] = !this.m_orders[i];
                    }
                }
            }
            if (localX >= 102 && localX < 177 && localY >= 173 && localY < 193 && this.canPlayerOrder()) {
                this.order();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(background);
        int startY = (this.field_146295_m - 215) / 2;
        int startX = (this.field_146294_l - 192) / 2;
        this.func_73729_b(startX, startY, 0, 0, 192, 215);
        this.func_73729_b(startX, startY - 5, 0, 215, 192, 5);
        for (int i = 0; i < 6; ++i) {
            if (!this.m_orders[i]) continue;
            this.func_73729_b(startX + 160, startY + 31 + i * 23, 192, 0, 19, 19);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.header", (Object[])new Object[0]), startX + 8, startY + 10, 5001558);
        String currency = EmeraldHelper.getPlayerBalance(this.m_player) + " / " + this.getOrderCost();
        int currencyColour = this.canPlayerAffordOrder() ? 5001558 : 11410978;
        this.field_146289_q.func_78276_b(currency, startX + 192 - 25 - this.field_146289_q.func_78256_a(currency), startY + 10, currencyColour);
        for (int i = 0; i < 6; ++i) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)this.getSetName(i), (Object[])new Object[0]), startX + 16, startY + 38 + i * 23, 5001558);
        }
        String order = this.m_ordered ? I18n.func_135052_a((String)"gui.order.placed", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.order.place", (Object[])new Object[0]);
        int colour = this.canPlayerOrder() ? 5001558 : 11774119;
        this.field_146289_q.func_78276_b(order, startX + 102 + (75 - this.field_146289_q.func_78256_a(order)) / 2, startY + 180, colour);
        super.func_73863_a(mouseX, mouseY, f);
    }

    private boolean canPlayerOrder() {
        int order;
        if (!this.m_ordered && (order = this.getOrderCost()) > 0) {
            int balance = EmeraldHelper.getPlayerBalance(this.m_player);
            return balance >= order;
        }
        return false;
    }

    private boolean canPlayerAffordOrder() {
        int order = this.getOrderCost();
        int balance = EmeraldHelper.getPlayerBalance(this.m_player);
        return balance >= order;
    }

    private void order() {
        if (!this.m_ordered) {
            for (int i = 0; i < 6; ++i) {
                if (!this.m_orders[i]) continue;
                MessageOrder messageOrder = new MessageOrder();
                messageOrder.orderType = i;
                PacketHandler.INSTANCE.sendToServer((IMessage)messageOrder);
            }
            this.m_ordered = true;
        }
    }

    private int getOrderCost() {
        int total = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.m_orders[i]) continue;
            total += this.getSetCost(i);
        }
        return total;
    }

    private String getSetName(int i) {
        return BillundSet.get(i).getDescription();
    }

    private int getSetCost(int i) {
        return BillundSet.get(i).getCost();
    }
}

