/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.utils;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.utils.BlockPos;

public class ToolEffectiveCheck {
    public static boolean canHarvestBlock(World world, Block block, int metadata, BlockPos pos, EntityPlayer player) {
        if (world == null || block == null || pos == null || player == null) {
            return false;
        }
        ItemStack held = player.func_70694_bm();
        if (ExcavationSettings.openHand && held == null) {
            return block.canHarvestBlock(player, metadata);
        }
        if (ExcavationSettings.toolClass) {
            if (held == null) {
                return false;
            }
            if (held.func_77973_b() instanceof ItemShears && block instanceof IShearable) {
                return true;
            }
            for (String type : held.func_77973_b().getToolClasses(held)) {
                if (type.equalsIgnoreCase(block.getHarvestTool(metadata)) && held.func_77973_b().getHarvestLevel(held, type) >= block.getHarvestLevel(metadata)) {
                    return true;
                }
                if (!block.isToolEffective(type, metadata)) continue;
                return true;
            }
            return false;
        }
        if (ExcavationSettings.altTools && held != null && held.func_77973_b().func_150893_a(held, block) > 1.0f) {
            return true;
        }
        if (held != null && held.func_77973_b() instanceof ItemShears && block instanceof IShearable) {
            return true;
        }
        return block.canHarvestBlock(player, metadata);
    }
}

